!{\src2tex{textfont=tt}}
!!****f* ABINIT/uspp2abi
!! NAME
!! uspp2abi
!!
!! FUNCTION
!! Main routine for building an atomic data file for PAW calculations
!! in Abinit, starting from the D. Vanderbilt ultra-soft
!! pseudopotential generator
!!
!! COPYRIGHT
!! Copyright (C) 1998-2005 ABINIT group (FJ, MT)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~ABINIT/Infos/copyright
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~ABINIT/Infos/contributors .
!!
!! NOTES
!! The present main routine drives the following operations :
!!
!! 1) Read useful data from D. Vanderbilt USPP code
!! 2) Calculate quantities that do not depend from self-consistent PAW
!!    iterations
!! 3) Write an output file to be read as an input PAW atomic data
!!    file in abinit
!!
!!       Units: Energies=Hartree, Lengths=Bohr
!!
!! NOTES
!! Version number= 1.8.1 (july 2005)
!!
!! PARENTS
!!
!! CHILDREN
!!    calc_dij0,calc_kij,calc_hatden,calc_ntild,calc_occ,calc_qijl,calc_rhoij0,
!!    calc_shapef,calc_tcore,calc_vhnzc,calc_vhtnzc,initpawps1,initpawps2,
!!    opt_proj,ortho_phi,readdat,rdusps1,rdusps2,scale_phi,transfunc,wrpawps
!!
!! SOURCE

 subroutine uspp2abi(abflname)

 use defs_basis
 use defs_pawps

 implicit none

!==================================================================
! DECLARATIONS

!Global variables -------------------------------------------------
 integer, parameter :: abunit=22
 integer            :: un_log

 character*(fnlen) :: empty='',abflname,&
&                     datfile='uspp2abinit.dat'

!These types are defined in defs_pawps
 type(pawarray_type) :: pawarray
 type(pawdata_type)  :: pawdata
 type(pawopt_type)   :: pawopt
 type(pawps_type)    :: pawps
 type(pawrso_type)   :: pawrso
 type(pshead_type)   :: pshead
 type(usdata_type)   :: usdata

!******************************************************************
!BEGIN EXECUTABLE SECTION

!------------------------------------------------------------------
!---- Read pseudopotential file produced by USPP
!------------------------------------------------------------------

 allocate(pshead%orbitals(26))

!---- Read sizes of arrays from USPP
 call rdusps1(pshead,usdata,un_log)

!---- Write info
 write(un_log,'(/,a)')'========================================================'
 write(un_log,'(a)')  '==   uspp2abinit - v1.8.1:                            =='
 write(un_log,'(a)')  '==   Use D. Vanderbilt ultrasoft psp generator (uspp) =='
 write(un_log,'(a)')  '==   to produce a PAW atomic data file readable       =='
 write(un_log,'(a)')  '==   by Abinit (v4.6.1+)                              =='
 write(un_log,'(a)')  '========================================================'

!---- Initialize some useful data
 allocate(pawdata%indlmn(6,pshead%lmn_size))
 call initpawps1(pawdata,pshead)

!---- Eventually read additional data file
 call readdat(datfile,pawopt,pawrso,un_log)

!---- Allocate memory
 allocate(pawps%phi(pshead%wav_meshsz,pshead%basis_size))
 allocate(pawps%tphi(pshead%wav_meshsz,pshead%basis_size))
 allocate(pawps%tproj(pshead%prj_msz_max,pshead%basis_size))
 allocate(pawps%vhtnzc(pshead%rho_meshsz))
 allocate(pawps%dij0(pshead%lmn2_size))
 allocate(pawps%rhoij0(pshead%lmn2_size))
 allocate(pawps%coredens(pshead%rho_meshsz))
 allocate(pawps%tcoredens(pshead%rho_meshsz))
 allocate(pawarray%shapefunc(pshead%sph_meshsz))
 allocate(pawarray%coreden4pr2(pshead%rho_meshsz))
 allocate(pawarray%tcoreden4pr2(pshead%rho_meshsz))
 allocate(pawarray%valeden4pr2(pshead%rho_meshsz))
 allocate(pawarray%tvaleden4pr2(pshead%rho_meshsz))
 allocate(pawarray%rvloc(pshead%rho_meshsz))
 allocate(pawarray%gnorm(pshead%l_size))
 allocate(pawarray%qij0(pshead%lmn2_size))
 allocate(pawarray%vhnzc(pshead%rho_meshsz))
 allocate(pawarray%vhnzcij(pshead%lmn2_size))
 allocate(pawarray%vhtnzcij(pshead%lmn2_size))
 allocate(pawarray%kij(pshead%lmn2_size))
 allocate(pawarray%hatden4pr2(pshead%sph_meshsz))
 allocate(pawarray%q00hat(pshead%sph_meshsz))
 allocate(pawarray%occ_(pshead%sph_meshsz,pshead%basis_size))
 allocate(pawdata%rad(pawdata%big_meshsz))
 allocate(pawdata%rad_(pawdata%big_meshsz))
 allocate(usdata%lval(usdata%nval),usdata%refkeys(pshead%basis_size))
 allocate(usdata%occ(usdata%nval),usdata%snl(pshead%wav_meshsz,usdata%nval))
 allocate(usdata%sss(pshead%basis_size,pshead%basis_size))

!---- Read (other) data from USPP
 call rdusps2(pawarray,pawps,pshead,usdata)

!---- Initialize some useful data
 call initpawps2(pawdata,pawopt,pshead,usdata,un_log)

!------------------------------------------------------------------
!---- Compute new data needed by Abinit
!------------------------------------------------------------------
 call calc_shapef(pawarray,pawdata,pshead,un_log)
!      Re-orthogonalization of Phi, tPhi and tProj...
 call ortho_phi(pawarray,pawdata,pawps,pshead,usdata,pawopt%iortho)
 call scale_phi(pawps,pshead,usdata,un_log)
 call calc_occ(pawarray,pawps,pshead,usdata,un_log)
 call calc_dens(pawarray,pawdata,pawps,pshead,un_log)
 call calc_ntild(pawarray,pawps,pshead)
 call calc_hatden(pawarray,pawdata,pshead)
!      Orthogonalization of projectors - Optional...
!      call transfunc(pawps,pshead,usdata,un_log)
 call calc_qij0(pawarray,pawdata,pawps,pshead)
 call calc_vhnzc(pawarray,pawdata,pawps,pshead)
 call calc_vhtnzc(pawopt%ivhtnzc,pawarray,pawdata,pawps,pshead,usdata,un_log)
 call calc_kij(pawarray,pawdata,pawps,pshead)
 call calc_dij0(pawarray,pawdata,pawps,pshead)
 call calc_rhoij0(pawarray,pawdata,pawps,pshead)
 call opt_proj(pawps,pawrso,pshead,un_log)

!------------------------------------------------------------------
!---- Write PAW pseudopotential file for Abinit
!------------------------------------------------------------------

 call wrpawps(abflname,abunit,pawarray,pawdata,pawps,pshead,un_log)

!------------------------------------------------------------------
!---- Deallocate memory
!------------------------------------------------------------------

 deallocate(pshead%orbitals)
 deallocate(pawps%phi,pawps%tphi,pawps%tproj)
 deallocate(pawps%coredens,pawps%tcoredens)
 deallocate(pawps%vhtnzc,pawps%rhoij0,pawps%dij0)
 deallocate(pawarray%gnorm,pawarray%shapefunc)
 deallocate(pawarray%coreden4pr2,pawarray%tcoreden4pr2)
 deallocate(pawarray%valeden4pr2,pawarray%tvaleden4pr2)
 deallocate(pawarray%qij0,pawarray%rvloc)
 deallocate(pawarray%hatden4pr2,pawarray%q00hat,pawarray%kij)
 deallocate(pawarray%vhnzcij,pawarray%vhtnzcij)
 deallocate(pawarray%vhnzc,pawarray%occ_)
 deallocate(pawdata%indlmn,pawdata%rad,pawdata%rad_)
 deallocate(usdata%lval,usdata%refkeys,usdata%occ)
 deallocate(usdata%snl,usdata%sss)

 write(un_log,'(/,a)') '> PAW atomic data file successfully created.'
 write(un_log,'(/,a)') '> Program ended.'

 end subroutine
!!***
