var xs = [
  // Definitely heap digits.
  -(2n ** 1000n),

  // -(2n**64n)
  -18446744073709551617n,
  -18446744073709551616n,
  -18446744073709551615n,

  // -(2n**63n)
  -9223372036854775809n,
  -9223372036854775808n,
  -9223372036854775807n,

  // -(2**32)
  -4294967297n,
  -4294967296n,
  -4294967295n,

  // -(2**31)
  -2147483649n,
  -2147483648n,
  -2147483647n,

  -1n,
  0n,
  1n,

  // 2**31
  2147483649n,
  2147483648n,
  2147483647n,

  // 2**32
  4294967297n,
  4294967296n,
  4294967295n,

  // 2n**63n
  9223372036854775809n,
  9223372036854775808n,
  9223372036854775807n,

  // 2n**64n
  18446744073709551617n,
  18446744073709551616n,
  18446744073709551615n,

  // Definitely heap digits.
  2n ** 1000n,
];

function test() {
  for (var i = 0; i < 100; ++i) {
    var x = xs[i % xs.length];

    // Implicit ToBool(x)
    var r = x ? true : false;
    assertEq(r, x !== 0n);
  }
}
test();

function testNot() {
  for (var i = 0; i < 100; ++i) {
    var x = xs[i % xs.length];

    var r = !x;
    assertEq(r, x === 0n);
  }
}
testNot();
