/* Copyright (C) 2020 Wildfire Games.
 * This file is part of 0 A.D.
 *
 * 0 A.D. is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * 0 A.D. is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with 0 A.D.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef INCLUDED_ICMPATTACK
#define INCLUDED_ICMPATTACK

#include "ps/CStr.h"
#include "simulation2/system/Interface.h"

#include <vector>

class ICmpAttack : public IComponent
{
public:
    virtual float GetRepeatTime(const std::string& type) const = 0;
    virtual std::vector<CStr> GetAttackTypes() const = 0;
    DECLARE_INTERFACE_TYPE(Attack)
};

#endif // INCLUDED_ICMPATTACK
