/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.util.Collections;
import java.util.Iterator;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.MonoIterator;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.pattern.EmptySequenceTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.SequenceType;

public abstract class GeneralVariable
extends Instruction
implements Binding {
    private static final int ASSIGNABLE = 1;
    private static final int REQUIRED = 4;
    private static final int TUNNEL = 8;
    private static final int IMPLICITLY_REQUIRED = 16;
    private byte properties = 0;
    Expression select = null;
    protected StructuredQName variableQName;
    SequenceType requiredType;
    protected int slotNumber;
    protected int referenceCount = 10;
    protected int evaluationMode = -1;

    public void init(Expression select, StructuredQName qName) {
        this.select = select;
        this.variableQName = qName;
        this.adoptChildExpression(select);
    }

    public void setSelectExpression(Expression select) {
        this.select = select;
        this.adoptChildExpression(select);
    }

    public Expression getSelectExpression() {
        return this.select;
    }

    public void setRequiredType(SequenceType required) {
        this.requiredType = required;
    }

    public SequenceType getRequiredType() {
        return this.requiredType;
    }

    public void setAssignable(boolean assignable) {
        this.properties = assignable ? (byte)(this.properties | 1) : (byte)(this.properties & 0xFFFFFFFE);
    }

    public void setRequiredParam(boolean requiredParam) {
        this.properties = requiredParam ? (byte)(this.properties | 4) : (byte)(this.properties & 0xFFFFFFFB);
    }

    public void setImplicitlyRequiredParam(boolean requiredParam) {
        this.properties = requiredParam ? (byte)(this.properties | 0x10) : (byte)(this.properties & 0xFFFFFFEF);
    }

    public void setTunnel(boolean tunnel) {
        this.properties = tunnel ? (byte)(this.properties | 8) : (byte)(this.properties & 0xFFFFFFF7);
    }

    public void setReferenceCount(int refCount) {
        this.referenceCount = refCount;
    }

    public int getEvaluationMode() {
        if (this.evaluationMode == -1 && this.referenceCount == 10000) {
            this.evaluationMode = 12;
        }
        return this.evaluationMode;
    }

    public final boolean isAssignable() {
        return (this.properties & 1) != 0;
    }

    public ItemType getItemType(TypeHierarchy th) {
        return EmptySequenceTest.getInstance();
    }

    public int getCardinality() {
        return 8192;
    }

    public boolean isGlobal() {
        return false;
    }

    public int getLocalSlotNumber() {
        return this.slotNumber;
    }

    public final boolean isRequiredParam() {
        return (this.properties & 4) != 0;
    }

    public final boolean isImplicitlyRequiredParam() {
        return (this.properties & 0x10) != 0;
    }

    public final boolean isTunnelParam() {
        return (this.properties & 8) != 0;
    }

    public int getInstructionNameCode() {
        return 185;
    }

    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        if (this.select != null) {
            this.select = visitor.simplify(this.select);
        }
        return this;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        if (this.select != null) {
            this.select = visitor.typeCheck(this.select, contextItemType);
            this.adoptChildExpression(this.select);
        }
        this.checkAgainstRequiredType(visitor);
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        if (this.select != null) {
            this.select = visitor.optimize(this.select, contextItemType);
            this.adoptChildExpression(this.select);
            this.evaluationMode = this.isAssignable() ? ExpressionTool.eagerEvaluationMode(this.select) : (this.referenceCount == 10000 ? 12 : ExpressionTool.lazyEvaluationMode(this.select));
        }
        return this;
    }

    public Expression copy() {
        throw new UnsupportedOperationException("copy");
    }

    private void checkAgainstRequiredType(ExpressionVisitor visitor) throws XPathException {
        RoleLocator role = new RoleLocator(3, this.variableQName, 0, null);
        role.setSourceLocator(this);
        SequenceType r = this.requiredType;
        if (r != null && this.select != null) {
            this.select = TypeChecker.staticTypeCheck(this.select, this.requiredType, false, role, visitor);
        }
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        this.process(context);
        return null;
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        this.evaluateItem(context);
        return EmptyIterator.getInstance();
    }

    public ValueRepresentation getSelectValue(XPathContext context) throws XPathException {
        if (this.select == null) {
            throw new AssertionError((Object)"*** No select expression!!");
        }
        return ExpressionTool.evaluate(this.select, this.evaluationMode, context, this.referenceCount);
    }

    protected void promoteInst(PromotionOffer offer) throws XPathException {
        if (this.select != null) {
            this.select = this.doPromotion(this.select, offer);
        }
    }

    public Iterator iterateSubExpressions() {
        if (this.select != null) {
            return new MonoIterator(this.select);
        }
        return Collections.EMPTY_LIST.iterator();
    }

    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        if (this.select == original) {
            this.select = replacement;
            found = true;
        }
        return found;
    }

    public void explain(ExpressionPresenter out) {
        out.startElement("variable");
        out.emitAttribute("name", this.variableQName.getDisplayName());
        if (this.select != null) {
            this.select.explain(out);
        }
        out.endElement();
    }

    public int getSlotNumber() {
        return this.slotNumber;
    }

    public void setSlotNumber(int s) {
        this.slotNumber = s;
    }

    public void setVariableQName(StructuredQName s) {
        this.variableQName = s;
    }

    public StructuredQName getVariableQName() {
        return this.variableQName;
    }
}

