#!/bin/bash
#
# This file is a part of the CM-LGC font package
# version 0.5 (May 07, 2005)
#
# Copyright (c) 2003--2005 Alexej Kryukov <basileia@yandex.ru>.
# 
# This package is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# As a special exception, permission is granted to include these font
# programs in a Postscript or PDF file that consists of a document that
# contains text to be displayed or printed using these fonts, regardless
# of the conditions or license applying to the document itself.
#
# This package is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

OPL2OFM=opl2ofm-old
OVP2OVF=ovp2ovf-old

function makeofm () {
	OPL_NAME=$1
	echo "Processing $OPL_NAME..."
	$OPL2OFM $OPL_NAME ${OPL_NAME%.opl}.tfm
}

function makeovf () {
	OVP_NAME=$1
	echo "Processing $OVP_NAME..."
	$OVP2OVF $OVP_NAME ${OVP_NAME%.ovp}.ovf ${OVP_NAME%.ovp}.ofm
}

PACKAGE_NAME="cm-lgc"
CUR_DIR=$PWD
TEX_DIR=$CUR_DIR/tex
AFM_DIR=$CUR_DIR/texmf/fonts/afm/public/$PACKAGE_NAME/
FD_DIR=$CUR_DIR/texmf/omega/lambda/cm-lgc
OFM_DIR=$CUR_DIR/texmf/fonts/ofm/public/$PACKAGE_NAME
OVF_DIR=$CUR_DIR/texmf/fonts/ovf/public/$PACKAGE_NAME

cp $TEX_DIR/getmtx.tex $AFM_DIR
cp $TEX_DIR/cyralias-uni.tex $AFM_DIR
cp $TEX_DIR/serbian.mtx $AFM_DIR
cd $AFM_DIR

lambda $TEX_DIR/cm-lgc-o.tex

for ovp in *.vpl; do
	mv $ovp ${ovp%.vpl}.ovp
done

for i in *.ovp; do
	makeovf $i
done

rm -f *.mtx *.tex
rm -f *.opl *.ovp
rm -f *.pl *.vpl
rm -f *.ofl

mv -f *.log $TEX_DIR
mv -f *.ofm $OFM_DIR
mv -f *.ovf $OVF_DIR

mv -f ut1*.fd $FD_DIR

exit 0
