#ifndef TIMING_H
#define TIMING_H

/*
 * Timing functions
 *
 * Copyright (C) 2006  Enrico Zini
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <sys/times.h>
#include <unistd.h>
#include <iostream>

class Timing
{
private:
	double tps;
	std::string tag;
	struct tms firsttms;
	struct tms lasttms;

	std::string format(const struct tms& curtms, const struct tms& lasttms) const
	{
		std::stringstream str;

		double user = (curtms.tms_utime - lasttms.tms_utime)/tps;
		double system = (curtms.tms_stime - lasttms.tms_stime)/tps;
		str << tag << ": "
		    << user << " user, "
		    << system << " system, "
		    << user + system << " total";

		return str.str();
	}
	
public:
	Timing(const std::string& tag) :
		tps(sysconf(_SC_CLK_TCK)),
		tag(tag)
	{
		if (times(&firsttms) == -1)
			throw wibble::exception::System("reading timing informations");
		lasttms = firsttms;
	}

	std::string partial()
	{
		struct tms curtms;
		if (times(&curtms) == -1)
			throw wibble::exception::System("reading timing informations");

		std::string res = format(curtms, lasttms);

		if (times(&lasttms) == -1)
			throw wibble::exception::System("reading timing informations");
	
		return res;
	}

	std::string total()
	{
		struct tms curtms;
		if (times(&curtms) == -1)
			throw wibble::exception::System("reading timing informations");

		return format(curtms, firsttms);
	}
};

// vim:set ts=4 sw=4:
#endif
