// re2d $INPUT -o $OUTPUT -i --header lexer/state.d
module main;

import core.stdc.stddef;
import lexer.state; // the module is generated by re2c

/*!header:re2c:on*/
module lexer.state;

struct LexerState {
    const(char)* str, yycursor;
    /*!stags:re2c format = "const(char)* @@;"; */
};
/*!header:re2c:off*/

private long lex(ref LexerState yyrecord) {
    const(char)* t;
    /*!re2c
        re2c:api = record;
        re2c:YYCTYPE = "char";
        re2c:tags = 1;
        re2c:yyfill:enable = 0;
        re2c:header = "lexer/state.d";

        [a]* @t [b]* { return t - yyrecord.str; }
    */
}

void main() {
    const(char)* s = "ab";
    LexerState st = {s, s /*!stags:re2c format = ", null"; */};
    assert(lex(st) == 1);

    const(char)* s2 = "aaabbbbbbbb";
    LexerState st2 = {s2, s2 /*!stags:re2c format = ", null"; */};
    assert(lex(st2) == 3);
}
