/*
 * SPDX-License-Identifier: GPL-2.0-or-later
 *
 * uefi vars device - GUIDs
 */

#include "qemu/osdep.h"
#include "system/dma.h"

#include "hw/uefi/var-service.h"

/* variable namespaces */

const QemuUUID EfiGlobalVariable = {
    .data = UUID_LE(0x8be4df61, 0x93ca, 0x11d2, 0xaa, 0x0d,
                    0x00, 0xe0, 0x98, 0x03, 0x2b, 0x8c)
};

const QemuUUID EfiImageSecurityDatabase = {
    .data = UUID_LE(0xd719b2cb, 0x3d3a, 0x4596, 0xa3, 0xbc,
                    0xda, 0xd0, 0x0e, 0x67, 0x65, 0x6f)
};

const QemuUUID EfiCustomModeEnable = {
    .data = UUID_LE(0xc076ec0c, 0x7028, 0x4399, 0xa0, 0x72,
                    0x71, 0xee, 0x5c, 0x44, 0x8b, 0x9f)
};

const QemuUUID EfiSecureBootEnableDisable = {
    .data = UUID_LE(0xf0a30bc7, 0xaf08, 0x4556, 0x99, 0xc4,
                    0x0, 0x10, 0x9, 0xc9, 0x3a, 0x44)
};

/* signatures */

const QemuUUID EfiCertSha256Guid = {
    .data = UUID_LE(0xc1c41626, 0x504c, 0x4092, 0xac, 0xa9,
                    0x41, 0xf9, 0x36, 0x93, 0x43, 0x28)
};

const QemuUUID EfiCertSha384Guid = {
    .data = UUID_LE(0xff3e5307, 0x9fd0, 0x48c9, 0x85, 0xf1,
                    0x8a, 0xd5, 0x6c, 0x70, 0x1e, 0x1)
};

const QemuUUID EfiCertSha512Guid = {
    .data = UUID_LE(0x93e0fae, 0xa6c4, 0x4f50, 0x9f, 0x1b,
                    0xd4, 0x1e, 0x2b, 0x89, 0xc1, 0x9a)
};

const QemuUUID EfiCertRsa2048Guid = {
    .data = UUID_LE(0x3c5766e8, 0x269c, 0x4e34, 0xaa, 0x14,
                    0xed, 0x77, 0x6e, 0x85, 0xb3, 0xb6)
};

const QemuUUID EfiCertX509Guid = {
    .data = UUID_LE(0xa5c059a1, 0x94e4, 0x4aa7, 0x87, 0xb5,
                    0xab, 0x15, 0x5c, 0x2b, 0xf0, 0x72)
};

const QemuUUID EfiCertTypePkcs7Guid = {
    .data = UUID_LE(0x4aafd29d, 0x68df, 0x49ee, 0x8a, 0xa9,
                    0x34, 0x7d, 0x37, 0x56, 0x65, 0xa7)
};

/*
 * mm_header.guid values that the guest DXE/BDS phases use for
 * sending requests to management mode
 */

const QemuUUID EfiSmmVariableProtocolGuid = {
    .data = UUID_LE(0xed32d533, 0x99e6, 0x4209, 0x9c, 0xc0,
                    0x2d, 0x72, 0xcd, 0xd9, 0x98, 0xa7)
};

const QemuUUID VarCheckPolicyLibMmiHandlerGuid = {
    .data = UUID_LE(0xda1b0d11, 0xd1a7, 0x46c4, 0x9d, 0xc9,
                    0xf3, 0x71, 0x48, 0x75, 0xc6, 0xeb)
};

/*
 * mm_header.guid values that the guest DXE/BDS phases use for
 * reporting event groups being signaled to management mode
 */

const QemuUUID EfiEndOfDxeEventGroupGuid = {
    .data = UUID_LE(0x02ce967a, 0xdd7e, 0x4FFc, 0x9e, 0xe7,
                    0x81, 0x0c, 0xF0, 0x47, 0x08, 0x80)
};

const QemuUUID EfiEventReadyToBootGuid = {
    .data = UUID_LE(0x7ce88Fb3, 0x4bd7, 0x4679, 0x87, 0xa8,
                    0xa8, 0xd8, 0xde, 0xe5, 0x0d, 0x2b)
};

const QemuUUID EfiEventExitBootServicesGuid = {
    .data = UUID_LE(0x27abF055, 0xb1b8, 0x4c26, 0x80, 0x48,
                    0x74, 0x8F, 0x37, 0xba, 0xa2, 0xdF)
};
