/* --------------------------------------------------------------------------
 * ibam_stup.cpp
 * interface to integrate IBAM into pbbuttonsd
 *
 * Copyright 2005 Matthias Grimm
 * IBAM is Copyright by Sebastion Ritterbusch <sebastian@ritterbusch.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 * -------------------------------------------------------------------------*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#ifdef WITH_IBAM

#include "debug.h"
#if defined(DEBUG) && IBAM
#  define IBAM_DEBUG	1
#endif

#define IBAM_VERSION	"0.4"

#include "ibam.hpp"
extern "C" {

static ibam *ObjIBAM = NULL;

int
ibam_init(const char *data_path)
{
	int rc = 1;  // SUCCESS
	
	if (!ObjIBAM) {  // Object already created ?
		try {
			ObjIBAM = new ibam(data_path);
		} catch(...) {
			rc = 0;  // ERROR
		}
	}
	return rc;
}

void
ibam_exit()
{
	if (ObjIBAM) {
		delete(ObjIBAM);
		ObjIBAM = NULL;
	}
}

void
ibam_recordProfile()
{
	static long lasttime = time(NULL); 

	ObjIBAM->update();
	if (ObjIBAM->valid()) {
		if (time(NULL) < lasttime+10)
			ObjIBAM->update_statistics();
		else
			ObjIBAM->ignore_statistics();
		lasttime = time(NULL);
		ObjIBAM->save();
	}
}

int
ibam_getBatteryTimeAdaptive()
{
	if (!ObjIBAM->valid()) return 0;
	return (ObjIBAM->seconds_left_battery_adaptive()
	           + ObjIBAM->seconds_battery_correction()+30)/60;
}

int
ibam_getChargeTimeAdaptive()
{
	if (!ObjIBAM->valid()) return 0;
	return (ObjIBAM->seconds_left_charge_adaptive()
	           + ObjIBAM->seconds_charge_correction()+30)/60;
}

} /* extern "C" */
#endif  /* WITH_IBAM */
