/*
 * Copyright 2022-2023 the Pacemaker project contributors
 *
 * The version control history for this file may have further details.
 *
 * This source code is licensed under the GNU General Public License version 2
 * or later (GPLv2+) WITHOUT ANY WARRANTY.
 */

#include <crm_internal.h>

#include <crm/common/unittest_internal.h>
#include <crm/common/agents.h>

static void
all_params_null(void **state) {
    assert_int_equal(crm_parse_agent_spec(NULL, NULL, NULL, NULL), -EINVAL);
    assert_int_equal(crm_parse_agent_spec("", NULL, NULL, NULL), -EINVAL);
    assert_int_equal(crm_parse_agent_spec(":", NULL, NULL, NULL), -EINVAL);
    assert_int_equal(crm_parse_agent_spec("::", NULL, NULL, NULL), -EINVAL);
}

static void
no_prov_or_type(void **state) {
    char *std = NULL;
    char *prov = NULL;
    char *ty = NULL;

    assert_int_equal(crm_parse_agent_spec("ocf", &std, &prov, &ty), -EINVAL);
    assert_int_equal(crm_parse_agent_spec("ocf:", &std, &prov, &ty), -EINVAL);
    assert_int_equal(crm_parse_agent_spec("ocf::", &std, &prov, &ty), -EINVAL);
}

static void
no_type(void **state) {
    char *std = NULL;
    char *prov = NULL;
    char *ty = NULL;

    assert_int_equal(crm_parse_agent_spec("ocf:pacemaker:", &std, &prov, &ty), -EINVAL);
}

static void
get_std_and_ty(void **state) {
    char *std = NULL;
    char *prov = NULL;
    char *ty = NULL;

    assert_int_equal(crm_parse_agent_spec("stonith:fence_xvm", &std, &prov, &ty), pcmk_ok);
    assert_string_equal(std, "stonith");
    assert_null(prov);
    assert_string_equal(ty, "fence_xvm");

    free(std);
    free(ty);
}

static void
get_all_values(void **state) {
    char *std = NULL;
    char *prov = NULL;
    char *ty = NULL;

    assert_int_equal(crm_parse_agent_spec("ocf:pacemaker:ping", &std, &prov, &ty), pcmk_ok);
    assert_string_equal(std, "ocf");
    assert_string_equal(prov, "pacemaker");
    assert_string_equal(ty, "ping");

    free(std);
    free(prov);
    free(ty);
}

static void
get_systemd_values(void **state) {
    char *std = NULL;
    char *prov = NULL;
    char *ty = NULL;

    assert_int_equal(crm_parse_agent_spec("systemd:UNIT@A:B", &std, &prov, &ty), pcmk_ok);
    assert_string_equal(std, "systemd");
    assert_null(prov);
    assert_string_equal(ty, "UNIT@A:B");

    free(std);
    free(ty);
}

PCMK__UNIT_TEST(NULL, NULL,
                cmocka_unit_test(all_params_null),
                cmocka_unit_test(no_prov_or_type),
                cmocka_unit_test(no_type),
                cmocka_unit_test(get_std_and_ty),
                cmocka_unit_test(get_all_values),
                cmocka_unit_test(get_systemd_values))
