.\"
.\" Copyright 2011, Jim Rees.
.\"
.\" You may distribute under the terms of the GNU General Public
.\" License as specified in the file COPYING that comes with the
.\" nfs-utils distribution.
.\"
.TH blkmapd 8 "11 August 2011"
.SH NAME
blkmapd \- pNFS block layout mapping daemon
.SH SYNOPSIS
.B "blkmapd [-h] [-d] [-f]"
.SH DESCRIPTION
The
.B blkmapd
daemon performs device discovery and mapping for the parallel NFS (pNFS) block layout
client [RFC5663].
.PP
The pNFS block layout protocol builds a complex storage hierarchy from a set
of
.I simple volumes.
These simple volumes are addressed by content, using a signature on the
volume to uniquely name each one.
The daemon locates a volume by examining each block device in the system for
the given signature.
.PP
The topology typically consists of a hierarchy of volumes built by striping,
slicing, and concatenating the simple volumes.
The
.B blkmapd
daemon uses the device-mapper driver to construct logical devices that
reflect the server topology, and passes these devices to the kernel for use
by the pNFS block layout client.
.SH OPTIONS
.TP
.B -h
Display usage message.
.TP
.B -d
Performs device discovery only then exits.
.TP
.B -f
Runs
.B blkmapd
in the foreground and sends output to stderr (as opposed to syslogd)
.SH SEE ALSO
.BR nfs (5),
.BR dmsetup (8)
.sp
RFC 5661 for the NFS version 4.1 specification.
.br
RFC 5663 for the pNFS block layout specification.
.SH AUTHORS
.br
Haiying Tang <Tang_Haiying@emc.com>
.br
Jim Rees <rees@umich.edu>
