/* Policies for result and outcome
(C) 2017-2019 Niall Douglas <http://www.nedproductions.biz/> (59 commits)
File Created: Oct 2017


Boost Software License - Version 1.0 - August 17th, 2003

Permission is hereby granted, free of charge, to any person or organization
obtaining a copy of the software and accompanying documentation covered by
this license (the "Software") to use, reproduce, display, distribute,
execute, and transmit the Software, and to prepare derivative works of the
Software, and to permit third-parties to whom the Software is furnished to
do so, all subject to the following:

The copyright notices in the Software and this entire statement, including
the above license grant, this restriction and the following disclaimer,
must be included in all copies of the Software, in whole or in part, and
all derivative works of the Software, unless such copies or derivative
works are solely in the form of machine-executable object code generated by
a source language processor.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
*/

#ifndef BOOST_OUTCOME_POLICY_BASE_HPP
#define BOOST_OUTCOME_POLICY_BASE_HPP

#include "../config.hpp"

#include <cassert>

BOOST_OUTCOME_V2_NAMESPACE_EXPORT_BEGIN

namespace policy
{
  /*! AWAITING HUGO JSON CONVERSION TOOL 
SIGNATURE NOT RECOGNISED
*/
  struct base
  {
  protected:
    template <class Impl>
    static constexpr
#ifdef _MSC_VER
    __declspec(noreturn)
#elif defined(__GNUC__) || defined(__clang__)
        __attribute__((noreturn))
#endif
    void _ub(Impl && /*unused*/)
    {
      assert(false);  // NOLINT
#if defined(__GNUC__) || defined(__clang__)
      __builtin_unreachable();
#elif defined(_MSC_VER)
      __assume(0);
#endif
    }

    template <class Impl> static constexpr bool _has_value(Impl &&self) noexcept { return (self._state._status & BOOST_OUTCOME_V2_NAMESPACE::detail::status_have_value) != 0; }
    template <class Impl> static constexpr bool _has_error(Impl &&self) noexcept { return (self._state._status & BOOST_OUTCOME_V2_NAMESPACE::detail::status_have_error) != 0; }
    template <class Impl> static constexpr bool _has_exception(Impl &&self) noexcept { return (self._state._status & BOOST_OUTCOME_V2_NAMESPACE::detail::status_have_exception) != 0; }
    template <class Impl> static constexpr bool _has_error_is_errno(Impl &&self) noexcept { return (self._state._status & BOOST_OUTCOME_V2_NAMESPACE::detail::status_error_is_errno) != 0; }

    template <class Impl> static constexpr void _set_has_value(Impl &&self, bool v) noexcept { v ? self._state._status |= BOOST_OUTCOME_V2_NAMESPACE::detail::status_have_value : self._state._status &= ~BOOST_OUTCOME_V2_NAMESPACE::detail::status_have_value; }
    template <class Impl> static constexpr void _set_has_error(Impl &&self, bool v) noexcept { v ? self._state._status |= BOOST_OUTCOME_V2_NAMESPACE::detail::status_have_error : self._state._status &= ~BOOST_OUTCOME_V2_NAMESPACE::detail::status_have_error; }
    template <class Impl> static constexpr void _set_has_exception(Impl &&self, bool v) noexcept { v ? self._state._status |= BOOST_OUTCOME_V2_NAMESPACE::detail::status_have_exception : self._state._status &= ~BOOST_OUTCOME_V2_NAMESPACE::detail::status_have_exception; }
    template <class Impl> static constexpr void _set_has_error_is_errno(Impl &&self, bool v) noexcept { v ? self._state._status |= BOOST_OUTCOME_V2_NAMESPACE::detail::status_error_is_errno : self._state._status &= ~BOOST_OUTCOME_V2_NAMESPACE::detail::status_error_is_errno; }

    template <class Impl> static constexpr auto &&_value(Impl &&self) noexcept { return static_cast<Impl &&>(self)._state._value; }
    template <class Impl> static constexpr auto &&_error(Impl &&self) noexcept { return static_cast<Impl &&>(self)._error; }

  public:
    template <class R, class S, class P, class NoValuePolicy, class Impl> static inline constexpr auto &&_exception(Impl &&self) noexcept;

    template <class Impl> static constexpr void narrow_value_check(Impl &&self) noexcept
    {
      if(!_has_value(self))
      {
        _ub(self);
      }
    }
    template <class Impl> static constexpr void narrow_error_check(Impl &&self) noexcept
    {
      if(!_has_error(self))
      {
        _ub(self);
      }
    }
    template <class Impl> static constexpr void narrow_exception_check(Impl &&self) noexcept
    {
      if(!_has_exception(self))
      {
        _ub(self);
      }
    }
  };
}  // namespace policy

BOOST_OUTCOME_V2_NAMESPACE_END

#endif
