Thanks for contributing to `Plotters`! 

Here's the useful information about contributing to Plotters.

# License

The `Plotters` project is under MIT license.
You may interested in reading [the full text of the license](https://github.com/38/plotters/blob/master/LICENSE).
If you have any questions or concerns please contact us at <haohou302@gmail.com>.

# Contributing to Plotters codebase

You are warmly welcomed to contribute code and make Plotters better. Here's a few things that may be helpful to you.

## How to make sure my code works

*Help wanted:* You may realize that `Plotters` doesn't have a high testing coverage, but we are trying hard to improve. It would be nice if you add more test cases for newly added code, or contribute new test cases directly.

Before you finalize your PR, please check the following thing:

- Please make sure all test case passes. If any case fails, we need to dig into that. For more details about testing, please read the [Testing notes](#testing-notes).

- Please run the benchmark to check if the performance changed compare to the master branch.

- Please run the following command to check if the example output changes. (There shouldn't be any change if you are not modifying the layout)

  ```bash
  cargo test --doc
  cargo build --release --examples
  for i in examples/*.rs
  do
  ./target/release/examples/$(basename $i .rs)
  done
  cd plotters-doc-data
  git status
  ```

- Please make sure the WASM target works as well. The easiest way to do that is try to run our WASM demo under [examples/wasm-demo](https://github.com/38/plotters/blob/master/examples/wasm-demo) directory and follow the instruction in the `README.md` file under that directory.

## Is my code meets the styling guideline

Although there's no strictly enforced rules for the style, but please read the following recommendations before you start work.

- In general, the only guide line is we need to make sure `cargo fmt` doesn't change anything. So it's recommended use `cargo fmt` to fix the code styling issues before you wrap up the work. (Such as submit a PR)
- For naming, acronyms or initials aren't normally used in the code base. Descriptive identifier is highly recommended.
- Documentation is highly recommended. (But there are still a lot of undocumented code unfortunately).
- For API documentation, we normally follows Doxygen's style, which looks like

```rust
/// Some description to this API
/// - `param_1`: What param_1 do
/// - `param_2`: What param_2 do
/// - **returns**: The return value description
fn foo(param_1: u32, param_2: u32) -> u32{ 0 }
```

## Top Level Documentation and Readme

Please notice we put almost same content for top level `rustdoc` and `README.md`. Thus the both part are generated by script.
If you need to modify the readme and documentation, please change the template at [doc-template/readme.template.md](https://github.com/38/plotters/blob/master/doc-template/readme.template.md) and 
use the following command to synchronize the doc to both `src/lib.rs` and `README.md`.

```bash
bash doc-template/update-readme.sh
```

## Testing Notes

As the project is intended to work in various environments, it's important to test its all features and different feature combinations. The notes below may help you with that task.

### Native

Testing all features:

```bash
cargo test --all-features
```

Testing no features at all:

```bash
cargo test --no-default-features --lib
```

Since all examples and most doc-test requires `bitmap` features, so we don't test examples and doc test in this case.

### WebAssembly

Wasm target is not tested by default, and you may want to use [wasm-bindgen](https://rustwasm.github.io/docs/wasm-bindgen/wasm-bindgen-test/usage.html) CLI tool.

Installation:

```bash
rustup target add wasm32-unknown-unknown
cargo install wasm-bindgen-cli
```

Additionally, the web browser and its driver should be available, please see [Configuring Which Browser is Used](https://rustwasm.github.io/wasm-bindgen/wasm-bindgen-test/browsers.html#configuring-which-browser-is-used-1). For example, to use Firefox, its binary (`firefox`) and [geckodriver](https://github.com/mozilla/geckodriver/releases) must be on your `$PATH`.

Usage (only library tests are supported for now):

```bash
cargo test --lib --target wasm32-unknown-unknown
```

For the debugging you could set the `NO_HEADLESS=1` environment variable to run the tests using the local server instead of the headless browser.

### Minimal Supported Compiler Version

Currently we should make sure Plotters is compatible with rustc 1.36.0.
Before making a PR, please check if the code compile with 1.36.0 (with default features).

### Code Coverage

For for the code coverage information you may want to use [cargo-tarpaulin](https://crates.io/crates/cargo-tarpaulin). Please note that it works with x86_64 GNU/Linux only, and the doc tests coverage require nightly Rust.

Installation ([pycobertura](https://pypi.python.org/pypi/pycobertura) is used to get the detailed report about the coverage):

```bash
cargo install cargo-tarpaulin
pip install pycobertura
```

Usage:

```bash
cargo tarpaulin --all-features --run-types Tests Doctests -o Xml --output-dir target/test
pycobertura show target/test/cobertura.xml
```


