/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/*
 * This file is part of the libe-book project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */

#ifndef PLKRPARSER_H_INCLUDED
#define PLKRPARSER_H_INCLUDED

#include <map>
#include <vector>

#include <boost/shared_ptr.hpp>

#include "PDXParser.h"

namespace libebook
{

typedef std::map<unsigned, std::vector<unsigned char> > PLKRImageMap_t;

struct PLKRHeader;
struct PLKRParserState;
struct PLKRRecordHeader;

class PLKRParser : public PDXParser
{
  // -Weffc++
  PLKRParser(const PLKRParser &other);
  PLKRParser &operator=(const PLKRParser &other);

public:
  explicit PLKRParser(librevenge::RVNGInputStream *input, librevenge::RVNGTextInterface *document = 0);
  virtual ~PLKRParser();

  static bool checkType(unsigned type, unsigned creator);

private:
  virtual void readAppInfoRecord(librevenge::RVNGInputStream *record);
  virtual void readSortInfoRecord(librevenge::RVNGInputStream *record);
  virtual void readIndexRecord(librevenge::RVNGInputStream *record);
  virtual void readDataRecord(librevenge::RVNGInputStream *record, bool last = false);

  virtual void readDataRecords();

  void readMetadata(librevenge::RVNGInputStream *input, const PLKRRecordHeader &header);
  void readImage(librevenge::RVNGInputStream *input, const PLKRRecordHeader &header);
  void readText(librevenge::RVNGInputStream *input, const PLKRRecordHeader &header, const std::vector<unsigned> &paragraphLengths);

  boost::shared_ptr<librevenge::RVNGInputStream> getUncompressedStream(librevenge::RVNGInputStream *input) const;

private:
  PLKRHeader *m_header;
  PLKRParserState *const m_state;
};

} // namespace libebook

#endif // PLKRPARSER_H_INCLUDED
/* vim:set shiftwidth=2 softtabstop=2 expandtab: */
