/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* libe-book
 * Version: MPL 2.0 / LGPLv2.1+
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * Alternatively, the contents of this file may be used under the terms
 * of the GNU Lesser General Public License Version 2.1 or later
 * (LGPLv2.1+), in which case the provisions of the LGPLv2.1+ are
 * applicable instead of those above.
 *
 * For further information visit http://libebook.sourceforge.net
 */

#include <algorithm>

#include <libwpd-stream/libwpd-stream.h>

#include <libe-book/ZVRDocument.h>

#include "libebook_utils.h"
#include "ZVRParser.h"

namespace libebook
{

namespace
{

const char ZVR_SIGNATURE[] = "!!Compressed!!\n";

}

bool ZVRDocument::isSupported(WPXInputStream *const input) try
{
  // ignore the trailing \0
  const size_t length = EBOOK_NUM_ELEMENTS(ZVR_SIGNATURE) - 1;
  input->seek(0, WPX_SEEK_SET);
  const char *const sig = reinterpret_cast<const char *>(readNBytes(input, length));
  return std::equal(sig, sig + length, ZVR_SIGNATURE);
}
catch (...)
{
  return false;
}

bool ZVRDocument::parse(WPXInputStream *const input, WPXDocumentInterface *const document) try
{
  if (!ZVRDocument::isSupported(input))
    return false;

  input->seek(0, WPX_SEEK_SET);
  ZVRParser parser(input, document);
  return parser.parse();
}
catch (...)
{
  return false;
}

}

/* vim:set shiftwidth=2 softtabstop=2 expandtab: */
