/*
 * Decompiled with CFR 0.152.
 */
package jd.xml.xslt.trax;

import java.io.StringReader;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TemplatesHandler;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamSource;
import jd.xml.util.UriResolver;
import jd.xml.util.XmlSource;
import jd.xml.xslt.IdentityTransformation;
import jd.xml.xslt.parser.StylesheetData;
import jd.xml.xslt.parser.StylesheetParser;
import jd.xml.xslt.trax.DefaultUriResolver;
import jd.xml.xslt.trax.TemplatesHandlerImpl;
import jd.xml.xslt.trax.TemplatesImpl;
import jd.xml.xslt.trax.TransformerHandlerImpl;
import jd.xml.xslt.trax.TransformerImpl;
import jd.xml.xslt.trax.TraxUtil;
import jd.xml.xslt.util.AssocStylesheetBuilder;
import org.xml.sax.XMLFilter;

public class TransformerFactoryImpl
extends SAXTransformerFactory {
    private ErrorListener errorListener_;
    private UriResolver uriResolver_;
    private URIResolver traxUriResolver_ = DefaultUriResolver.INSTANCE;

    public Transformer newTransformer(Source source) throws TransformerConfigurationException {
        return this.newTemplates(source).newTransformer();
    }

    public Transformer newTransformer() throws TransformerConfigurationException {
        try {
            IdentityTransformation identityTransformation = new IdentityTransformation();
            identityTransformation.setUriResolver(this.uriResolver_);
            return new TransformerImpl(identityTransformation);
        }
        catch (Exception exception) {
            throw this.getException(exception);
        }
    }

    public Templates newTemplates(Source source) throws TransformerConfigurationException {
        try {
            return this.newTemplates(TraxUtil.getXmlSource(source));
        }
        catch (Exception exception) {
            throw this.getException(exception);
        }
    }

    public Templates newTemplates(XmlSource xmlSource) throws TransformerConfigurationException {
        try {
            StylesheetParser stylesheetParser = new StylesheetParser();
            stylesheetParser.setUriResolver(this.uriResolver_);
            StylesheetData stylesheetData = stylesheetParser.parseStylesheet(xmlSource);
            return new TemplatesImpl(stylesheetData, this.uriResolver_);
        }
        catch (Exception exception) {
            throw this.getException(exception);
        }
    }

    public Source getAssociatedStylesheet(Source source, String string, String string2, String string3) throws TransformerConfigurationException {
        try {
            XmlSource xmlSource = TraxUtil.getXmlSource(source);
            AssocStylesheetBuilder assocStylesheetBuilder = new AssocStylesheetBuilder(string2, string, string3);
            String string4 = assocStylesheetBuilder.getStylesheetString(xmlSource);
            StreamSource streamSource = new StreamSource(source.getSystemId());
            streamSource.setReader(new StringReader(string4));
            return streamSource;
        }
        catch (Exception exception) {
            throw this.getException(exception);
        }
    }

    public void setURIResolver(URIResolver uRIResolver) {
        this.traxUriResolver_ = uRIResolver;
        this.uriResolver_ = TraxUtil.getUriResolver(uRIResolver);
    }

    public URIResolver getURIResolver() {
        return this.traxUriResolver_;
    }

    public boolean getFeature(String string) {
        if ("http://javax.xml.transform.stream.StreamSource/feature".equals(string)) {
            return true;
        }
        if ("http://javax.xml.transform.stream.StreamResult/feature".equals(string)) {
            return true;
        }
        if ("http://javax.xml.transform.dom.DOMSource/feature".equals(string)) {
            return true;
        }
        if ("http://javax.xml.transform.dom.DOMResult/feature".equals(string)) {
            return true;
        }
        if ("http://javax.xml.transform.sax.SAXSource/feature".equals(string)) {
            return true;
        }
        if ("http://javax.xml.transform.sax.SAXResult/feature".equals(string)) {
            return true;
        }
        return "http://javax.xml.transform.sax.SAXTransformerFactory/feature".equals(string);
    }

    public void setAttribute(String string, Object object) throws IllegalArgumentException {
        throw new IllegalArgumentException("unknown attribute " + string);
    }

    public Object getAttribute(String string) throws IllegalArgumentException {
        throw new IllegalArgumentException("unknown attribute " + string);
    }

    public void setErrorListener(ErrorListener errorListener) throws IllegalArgumentException {
        this.errorListener_ = errorListener;
    }

    public ErrorListener getErrorListener() {
        return this.errorListener_;
    }

    public TemplatesHandler newTemplatesHandler() {
        return new TemplatesHandlerImpl(this);
    }

    public TransformerHandler newTransformerHandler() throws TransformerConfigurationException {
        return this.newTransformerHandler(this.newTransformer());
    }

    public TransformerHandler newTransformerHandler(Source source) throws TransformerConfigurationException {
        return this.newTransformerHandler(this.newTransformer(source));
    }

    public TransformerHandler newTransformerHandler(Templates templates) throws TransformerConfigurationException {
        return this.newTransformerHandler(templates.newTransformer());
    }

    private TransformerHandler newTransformerHandler(Transformer transformer) throws TransformerConfigurationException {
        return new TransformerHandlerImpl((TransformerImpl)transformer);
    }

    public XMLFilter newXMLFilter(Source source) {
        return null;
    }

    public XMLFilter newXMLFilter(Templates templates) {
        return null;
    }

    private TransformerConfigurationException getException(Exception exception) {
        if (exception instanceof TransformerConfigurationException) {
            return (TransformerConfigurationException)exception;
        }
        return new TransformerConfigurationException(exception);
    }
}

