/*
 * Decompiled with CFR 0.152.
 */
package jd.util;

import java.util.Calendar;
import java.util.GregorianCalendar;
import jd.util.StringUtil;

public class Date
implements Cloneable {
    public static final int WEEKDAY_SUNDAY = 1;
    public static final int WEEKDAY_MONDAY = 2;
    public static final int WEEKDAY_TUESDAY = 3;
    public static final int WEEKDAY_WEDNESDAY = 4;
    public static final int WEEKDAY_THURSDAY = 5;
    public static final int WEEKDAY_FRIDAY = 6;
    public static final int WEEKDAY_SATURDAY = 7;
    private int day_;
    private int month_;
    private int year_;
    private static final short[] DAYS_IN_MONTH_NOLEAP = new short[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31, 30, 31};
    private static final short[] DAYS_IN_MONTH_LEAP = new short[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31, 30, 31};
    private static final short[] JULIAN_DAY_MONTH_TABLE = new short[]{306, 337, 0, 31, 61, 92, 122, 153, 184, 214, 245, 275};

    public static Date today() {
        return new Date();
    }

    public Date() {
        this(System.currentTimeMillis());
    }

    public Date(long l) {
        this(new java.util.Date(l));
    }

    public Date(int n, int n2, int n3) {
        if (!Date.isValidDate(n, n2, n3)) {
            throw new IllegalArgumentException("invalid date arguments");
        }
        this.init(n, n2, n3);
    }

    public Date(Date date) {
        this.init(date.year_, date.month_, date.day_);
    }

    public Date(java.util.Date date) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        this.init(gregorianCalendar);
    }

    public Date(Calendar calendar) {
        this.init(calendar);
    }

    private void init(Calendar calendar) {
        this.init(calendar.get(1), calendar.get(2) + 1, calendar.get(5));
    }

    private void init(int n, int n2, int n3) {
        this.year_ = n;
        this.month_ = n2;
        this.day_ = n3;
    }

    public int getDay() {
        return this.day_;
    }

    public int getMonth() {
        return this.month_;
    }

    public int getYear() {
        return this.year_;
    }

    public int getLastDayOfMonth() {
        return Date.getLastDayOfMonth(this.month_, this.year_);
    }

    public static int getLastDayOfMonth(int n, int n2) {
        return Date.isLeapYear(n2) ? DAYS_IN_MONTH_LEAP[n - 1] : DAYS_IN_MONTH_NOLEAP[n - 1];
    }

    public boolean isLeapYear() {
        return Date.isLeapYear(this.getYear());
    }

    public static boolean isLeapYear(int n) {
        if (n >= 1582) {
            return n % 4 == 0 && (n % 100 != 0 || n % 400 == 0);
        }
        return n % 4 == 0;
    }

    public int getDayOfWeek() {
        return (this.toJulianDayNumber() + 1) % 7 + 1;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Date)) {
            return false;
        }
        Date date = (Date)object;
        return date.day_ == this.day_ && date.month_ == this.month_ && date.year_ == this.year_;
    }

    public boolean isBefore(Date date) {
        return this.toInteger() < date.toInteger();
    }

    public boolean isAfter(Date date) {
        return this.toInteger() > date.toInteger();
    }

    public Date addYears(int n) {
        Date date = new Date(this);
        date.addYearsInternal(n);
        return date;
    }

    private void addYearsInternal(int n) {
        this.year_ += n;
        this.correctDayOfMonth();
    }

    public Date addMonths(int n) {
        Date date = new Date(this);
        date.addMonthInternal(n);
        return date;
    }

    private void addMonthInternal(int n) {
        int n2 = this.month_ + n - 1;
        if (n2 >= 0) {
            this.year_ += n2 / 12;
            this.month_ = n2 % 12 + 1;
        } else {
            this.year_ += (n2 + 1) / 12 - 1;
            if ((n2 %= 12) < 0) {
                n2 += 12;
            }
            this.month_ = n2 + 1;
        }
        this.correctDayOfMonth();
    }

    public Date addDays(int n) {
        Date date = new Date(this);
        date.addDaysInternal(n);
        return date;
    }

    private void addDaysInternal(int n) {
        if (n == 0) {
            return;
        }
        if (n > 0) {
            this.addDaysInternalFuture(n);
        } else {
            this.addDaysInternalPast(-n);
        }
    }

    private void addDaysInternalFuture(int n) {
        int n2;
        if (n >= 365) {
            n2 = this.day_;
            this.addYearsInternal(n / 365);
            n %= 365;
            n += n2 - this.day_;
        }
        while (n > 0) {
            n2 = Date.getLastDayOfMonth(this.month_, this.year_);
            if (n <= n2 - this.day_) {
                this.day_ += n;
                n = 0;
                continue;
            }
            n -= n2 - this.day_ + 1;
            this.day_ = 1;
            ++this.month_;
            if (this.month_ <= 12) continue;
            this.month_ = 1;
            ++this.year_;
        }
    }

    private void addDaysInternalPast(int n) {
        if (n >= 365) {
            int n2 = this.day_;
            this.addYearsInternal(-(n / 365));
            n %= 365;
            n -= n2 - this.day_;
        }
        while (n > 0) {
            if (n < this.day_) {
                this.day_ -= n;
                n = 0;
                continue;
            }
            n -= this.day_;
            --this.month_;
            if (this.month_ == 0) {
                this.month_ = 12;
                --this.year_;
            }
            this.day_ = this.getLastDayOfMonth();
        }
    }

    private void correctDayOfMonth() {
        int n = this.getLastDayOfMonth();
        if (this.day_ >= n) {
            this.day_ = n;
        }
    }

    public int difference(Date date) {
        return this.toJulianDayNumber() - date.toJulianDayNumber();
    }

    public static boolean isValidDate(int n, int n2, int n3) {
        if (n2 < 1 || n2 > 12) {
            return false;
        }
        short[] sArray = Date.isLeapYear(n) ? DAYS_IN_MONTH_LEAP : DAYS_IN_MONTH_NOLEAP;
        return n3 >= 1 && n3 <= sArray[n2 - 1];
    }

    public String toString() {
        return StringUtil.fillupLeft(String.valueOf(this.toInteger()), 8, '0');
    }

    public Calendar toCalendar() {
        return new GregorianCalendar(this.year_, this.month_ - 1, this.day_);
    }

    public java.util.Date toJavaDate() {
        return this.toCalendar().getTime();
    }

    public java.sql.Date toJavaSqlDate() {
        return new java.sql.Date(this.toJavaDate().getTime());
    }

    public int toInteger() {
        return 10000 * this.year_ + 100 * this.month_ + this.day_;
    }

    public static int toInteger(int n, int n2, int n3) {
        return 10000 * n3 + 100 * n2 + n;
    }

    public static Date fromInteger(int n) {
        int n2 = n / 10000;
        int n3 = (n %= 10000) / 100;
        int n4 = n % 100;
        return new Date(n2, n3, n4);
    }

    public int toJulianDayNumber() {
        int n = this.month_ < 3 ? this.year_ - 1 : this.year_;
        short s = JULIAN_DAY_MONTH_TABLE[this.month_ - 1];
        return this.day_ + s + 365 * n + (int)Math.floor((double)n / 4.0) - (int)Math.floor((double)n / 100.0) + (int)Math.floor((double)n / 400.0) + 1721119;
    }

    public synchronized Object clone() {
        return new Date(this);
    }

    public int hashCode() {
        return this.toInteger();
    }
}

