/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.CodeAttr;
import gnu.bytecode.Label;
import gnu.bytecode.PrimType;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import gnu.expr.Compilation;
import gnu.expr.ConditionalTarget;
import gnu.expr.ExitExp;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.IgnoreTarget;
import gnu.expr.Language;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.Target;
import gnu.mapping.CallContext;
import gnu.mapping.OutPort;
import gnu.mapping.Values;

public class IfExp
extends Expression {
    Expression test;
    Expression then_clause;
    Expression else_clause;

    public IfExp(Expression i, Expression t, Expression e) {
        this.test = i;
        this.then_clause = t;
        this.else_clause = e;
    }

    protected final Language getLanguage() {
        return Language.getDefaultLanguage();
    }

    protected boolean mustCompile() {
        return false;
    }

    public void apply(CallContext ctx) throws Throwable {
        if (this.getLanguage().isTrue(this.test.eval(ctx))) {
            this.then_clause.apply(ctx);
        } else if (this.else_clause != null) {
            this.else_clause.apply(ctx);
        }
    }

    public void compile(Compilation comp, Target target) {
        IfExp.compile(this.test, this.then_clause, this.else_clause == null ? QuoteExp.voidExp : this.else_clause, comp, target);
    }

    public static void compile(Expression test2, Expression then_clause, Expression else_clause, Compilation comp, Target target) {
        Variable callContextSave;
        Label trueLabel;
        boolean trueInherited;
        Label falseLabel;
        boolean falseInherited;
        Language language = comp.getLanguage();
        CodeAttr code = comp.getCode();
        if (target instanceof ConditionalTarget && else_clause instanceof QuoteExp) {
            falseInherited = true;
            Object value = ((QuoteExp)else_clause).getValue();
            falseLabel = language.isTrue(value) ? ((ConditionalTarget)target).ifTrue : ((ConditionalTarget)target).ifFalse;
        } else if (else_clause instanceof ExitExp && ((ExitExp)else_clause).result instanceof QuoteExp && ((ExitExp)else_clause).block.subTarget instanceof IgnoreTarget) {
            falseInherited = true;
            falseLabel = ((ExitExp)else_clause).block.exitLabel;
        } else {
            falseInherited = false;
            falseLabel = new Label(code);
        }
        if (test2 == then_clause && target instanceof ConditionalTarget && then_clause instanceof ReferenceExp) {
            trueInherited = true;
            trueLabel = ((ConditionalTarget)target).ifTrue;
        } else {
            trueInherited = false;
            trueLabel = new Label(code);
        }
        ConditionalTarget ctarget = new ConditionalTarget(trueLabel, falseLabel, language);
        if (trueInherited) {
            ctarget.trueBranchComesFirst = false;
        }
        test2.compile(comp, ctarget);
        code.emitIfThen();
        if (!trueInherited) {
            trueLabel.define(code);
            callContextSave = comp.callContextVar;
            then_clause.compileWithPosition(comp, target);
            comp.callContextVar = callContextSave;
        }
        if (!falseInherited) {
            code.emitElse();
            falseLabel.define(code);
            callContextSave = comp.callContextVar;
            if (else_clause == null) {
                comp.compileConstant(Values.empty, target);
            } else {
                else_clause.compileWithPosition(comp, target);
            }
            comp.callContextVar = callContextSave;
        } else {
            code.setUnreachable();
        }
        code.emitFi();
    }

    protected Expression walk(ExpWalker walker) {
        return walker.walkIfExp(this);
    }

    protected void walkChildren(ExpWalker walker) {
        this.test = this.test.walk(walker);
        if (walker.exitValue == null) {
            this.then_clause = walker.walk(this.then_clause);
        }
        if (walker.exitValue == null && this.else_clause != null) {
            this.else_clause = walker.walk(this.else_clause);
        }
    }

    public Type getType() {
        PrimType t2;
        Type t1 = this.then_clause.getType();
        Type type = t2 = this.else_clause == null ? Type.void_type : this.else_clause.getType();
        if (t1 == t2) {
            return t1;
        }
        return Type.pointer_type;
    }

    public void print(OutPort out) {
        out.startLogicalBlock("(If ", false, ")");
        out.setIndentation(-2, false);
        this.test.print(out);
        out.writeSpaceLinear();
        this.then_clause.print(out);
        if (this.else_clause != null) {
            out.writeSpaceLinear();
            this.else_clause.print(out);
        }
        out.endLogicalBlock(")");
    }
}

