/*
 * Decompiled with CFR 0.152.
 */
package alt.jiapi.reflect;

import alt.jiapi.file.Attribute;
import alt.jiapi.file.ClassFile;
import alt.jiapi.file.CodeAttribute;
import alt.jiapi.file.ConstantPool;
import alt.jiapi.file.Field;
import alt.jiapi.file.Method;
import alt.jiapi.file.SyntheticAttribute;
import alt.jiapi.reflect.FieldExistsException;
import alt.jiapi.reflect.JiapiField;
import alt.jiapi.reflect.JiapiMethod;
import alt.jiapi.reflect.MethodExistsException;
import alt.jiapi.reflect.Signature;
import alt.jiapi.reflect.TypeHelper;
import java.util.LinkedList;
import java.util.List;

class ClassBuilder {
    private ClassFile clazz;

    ClassBuilder(ClassFile clazz) {
        this.clazz = clazz;
    }

    JiapiField addField(short modifiers, String type, String name) throws FieldExistsException {
        ConstantPool cp = this.clazz.getConstantPool();
        List fields = this.clazz.getFields();
        for (Field field : fields) {
            if (!field.getName().equals(name)) continue;
            throw new FieldExistsException(new JiapiField(field));
        }
        LinkedList<SyntheticAttribute> attrs = new LinkedList<SyntheticAttribute>();
        attrs.add(new SyntheticAttribute(cp));
        Field f = new Field(cp, modifiers, name, TypeHelper.typeToDescriptor(type), attrs);
        fields.add(f);
        return new JiapiField(f);
    }

    JiapiMethod addMethod(short modifiers, String name, Signature signature) throws MethodExistsException {
        ConstantPool cp = this.clazz.getConstantPool();
        LinkedList<Attribute> attrs = new LinkedList<Attribute>();
        attrs.add(new SyntheticAttribute(cp));
        short maxStack = 0;
        int maxLocals = signature.getParameters().length + 1;
        attrs.add(new CodeAttribute(cp, maxStack, (short)maxLocals));
        Method m = new Method(cp, modifiers, name, signature.getDescriptor(), attrs);
        this.clazz.getMethods().add(m);
        return new JiapiMethod(m);
    }

    ClassFile getClassFile() {
        return this.clazz;
    }
}

