/*
 * Decompiled with CFR 0.152.
 */
package alt.jiapi.instrumentor;

import alt.jiapi.Runtime;
import alt.jiapi.instrumentor.AbstractInstrumentor;
import alt.jiapi.reflect.FieldExistsException;
import alt.jiapi.reflect.InstructionList;
import alt.jiapi.reflect.JiapiClass;
import alt.jiapi.reflect.JiapiField;
import java.lang.reflect.Modifier;
import org.apache.log4j.Category;

public class CreateFieldInstrumentor
extends AbstractInstrumentor {
    private static Category log = Runtime.getLogCategory(CreateFieldInstrumentor.class);
    private int modifiers;
    private String type;
    private String name;

    public CreateFieldInstrumentor(int modifiers, String type, String name) {
        this.modifiers = modifiers;
        this.type = type;
        this.name = name;
    }

    public CreateFieldInstrumentor(JiapiField field) {
        this(field.getModifiers(), field.getTypeName(), field.getName());
    }

    public void instrument(InstructionList il) {
        JiapiClass clazz = this.getCurrentClass();
        log.info((Object)("Adding field '" + this.modifiers + " " + this.type + " " + this.name + "' to " + clazz.getName()));
        if (!(!Modifier.isInterface(clazz.getModifiers()) || Modifier.isPublic(this.modifiers) && Modifier.isStatic(this.modifiers) && Modifier.isFinal(this.modifiers))) {
            log.info((Object)("Cannot add '" + this.modifiers + " " + this.type + " " + this.name + "' to " + clazz.getName()));
            this.forward(il);
            return;
        }
        try {
            clazz.addField(this.modifiers, this.type, this.name);
        }
        catch (FieldExistsException fee) {
            log.info((Object)("field " + fee.getField() + " already exists in a class " + clazz.getName()));
        }
        this.forward(il);
    }
}

