/*
 * Decompiled with CFR 0.152.
 */
package alt.jiapi.event;

import alt.jiapi.InstrumentationDescriptor;
import alt.jiapi.event.EventProducer;
import alt.jiapi.event.MethodEvent;
import alt.jiapi.event.MethodEventInstrumentor;
import alt.jiapi.event.MethodListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MethodEventProducer
extends EventProducer {
    private List listeners = new ArrayList();

    public MethodEventProducer(InstrumentationDescriptor id) {
        this(id, "*");
    }

    public MethodEventProducer(InstrumentationDescriptor id, String resolution) {
        super(resolution);
        id.addInstrumentor(new MethodEventInstrumentor(this));
    }

    public synchronized void addMethodListener(MethodListener mel) {
        this.listeners.add(mel);
    }

    public synchronized void removeMethodListener(MethodListener mel) {
        this.listeners.remove(mel);
    }

    public void methodEntered(Object sourceObject, String methodName) {
        if (!this.isProtected(sourceObject)) {
            this.fireMethodEnterEvent(sourceObject, methodName);
        }
    }

    public void methodExited(Object sourceObject, String methodName) {
        if (!this.isProtected(sourceObject)) {
            this.fireMethodExitEvent(sourceObject, methodName);
        }
    }

    protected synchronized void fireMethodEnterEvent(Object sourceObject, String methodName) {
        Iterator i = this.listeners.iterator();
        MethodEvent event = new MethodEvent(this, sourceObject, methodName, 1);
        while (i.hasNext()) {
            MethodListener ml = (MethodListener)i.next();
            ml.methodEntered(event);
        }
    }

    protected synchronized void fireMethodExitEvent(Object sourceObject, String methodName) {
        Iterator i = this.listeners.iterator();
        MethodEvent event = new MethodEvent(this, sourceObject, methodName, 2);
        while (i.hasNext()) {
            MethodListener ml = (MethodListener)i.next();
            ml.methodExited(event);
        }
    }
}

