/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.util;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.cojen.util.KeyFactory;
import org.cojen.util.WeakIdentityMap;

public class SoftValuedHashMap
extends AbstractMap
implements Map,
Cloneable {
    private transient Entry[] table;
    private transient int count;
    private int threshold;
    private final float loadFactor;
    private volatile transient int modCount;
    private transient Set keySet;
    private transient Set entrySet;
    private transient Collection values;

    public SoftValuedHashMap(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Initial Capacity: " + initialCapacity);
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal Load factor: " + loadFactor);
        }
        if (initialCapacity == 0) {
            initialCapacity = 1;
        }
        this.loadFactor = loadFactor;
        this.table = new Entry[initialCapacity];
        this.threshold = (int)((float)initialCapacity * loadFactor);
    }

    public SoftValuedHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public SoftValuedHashMap() {
        this(11, 0.75f);
    }

    public SoftValuedHashMap(Map t) {
        this(Math.max(2 * t.size(), 11), 0.75f);
        this.putAll(t);
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public boolean containsValue(Object value) {
        if (value == null) {
            value = KeyFactory.NULL;
        }
        Entry[] tab = this.table;
        int i = tab.length;
        while (i-- > 0) {
            Entry e = tab[i];
            Entry prev = null;
            while (e != null) {
                Object entryValue = e.get();
                if (entryValue == null) {
                    ++this.modCount;
                    if (prev != null) {
                        prev.next = e.next;
                    } else {
                        tab[i] = e.next;
                    }
                    --this.count;
                } else {
                    if (value.equals(entryValue)) {
                        return true;
                    }
                    prev = e;
                }
                e = e.next;
            }
        }
        return false;
    }

    public boolean containsKey(Object key) {
        Entry[] tab = this.table;
        if (key != null) {
            int hash = key.hashCode();
            int index = (hash & Integer.MAX_VALUE) % tab.length;
            Entry e = tab[index];
            Entry prev = null;
            while (e != null) {
                if (e.get() == null) {
                    ++this.modCount;
                    if (prev != null) {
                        prev.next = e.next;
                    } else {
                        tab[index] = e.next;
                    }
                    --this.count;
                } else {
                    if (e.hash == hash && key.equals(e.key)) {
                        return true;
                    }
                    prev = e;
                }
                e = e.next;
            }
        } else {
            Entry e = tab[0];
            Entry prev = null;
            while (e != null) {
                if (e.get() == null) {
                    ++this.modCount;
                    if (prev != null) {
                        prev.next = e.next;
                    } else {
                        tab[0] = e.next;
                    }
                    --this.count;
                } else {
                    if (e.key == null) {
                        return true;
                    }
                    prev = e;
                }
                e = e.next;
            }
        }
        return false;
    }

    public Object get(Object key) {
        Entry[] tab = this.table;
        if (key != null) {
            int hash = key.hashCode();
            int index = (hash & Integer.MAX_VALUE) % tab.length;
            Entry e = tab[index];
            Entry prev = null;
            while (e != null) {
                Object entryValue = e.get();
                if (entryValue == null) {
                    ++this.modCount;
                    if (prev != null) {
                        prev.next = e.next;
                    } else {
                        tab[index] = e.next;
                    }
                    --this.count;
                } else {
                    if (e.hash == hash && key.equals(e.key)) {
                        return entryValue == KeyFactory.NULL ? null : entryValue;
                    }
                    prev = e;
                }
                e = e.next;
            }
        } else {
            Entry e = tab[0];
            Entry prev = null;
            while (e != null) {
                Object entryValue = e.get();
                if (entryValue == null) {
                    ++this.modCount;
                    if (prev != null) {
                        prev.next = e.next;
                    } else {
                        tab[0] = e.next;
                    }
                    --this.count;
                } else {
                    if (e.key == null) {
                        return entryValue == KeyFactory.NULL ? null : entryValue;
                    }
                    prev = e;
                }
                e = e.next;
            }
        }
        return null;
    }

    private void cleanup() {
        Entry[] tab = this.table;
        int i = tab.length;
        while (i-- > 0) {
            Entry e = tab[i];
            Entry prev = null;
            while (e != null) {
                if (e.get() == null) {
                    ++this.modCount;
                    if (prev != null) {
                        prev.next = e.next;
                    } else {
                        tab[i] = e.next;
                    }
                    --this.count;
                } else {
                    prev = e;
                }
                e = e.next;
            }
        }
    }

    private void rehash() {
        int oldCapacity = this.table.length;
        Entry[] oldMap = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        Entry[] newMap = new Entry[newCapacity];
        ++this.modCount;
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            Entry old = oldMap[i];
            while (old != null) {
                Entry e = old;
                old = old.next;
                if (e.get() == null) {
                    --this.count;
                    continue;
                }
                int index = (e.hash & Integer.MAX_VALUE) % newCapacity;
                e.next = newMap[index];
                newMap[index] = e;
            }
        }
    }

    public Object put(Object key, Object value) {
        Entry e;
        int index;
        int hash;
        if (value == null) {
            value = KeyFactory.NULL;
        }
        Entry[] tab = this.table;
        if (key != null) {
            hash = key.hashCode();
            index = (hash & Integer.MAX_VALUE) % tab.length;
            e = tab[index];
            Entry prev = null;
            while (e != null) {
                Object entryValue = e.get();
                if (entryValue == null) {
                    ++this.modCount;
                    if (prev != null) {
                        prev.next = e.next;
                    } else {
                        tab[index] = e.next;
                    }
                    --this.count;
                } else {
                    if (e.hash == hash && key.equals(e.key)) {
                        e.setValue(value);
                        return entryValue == KeyFactory.NULL ? null : entryValue;
                    }
                    prev = e;
                }
                e = e.next;
            }
        } else {
            hash = 0;
            index = 0;
            e = tab[0];
            Entry prev = null;
            while (e != null) {
                Object entryValue = e.get();
                if (entryValue == null) {
                    ++this.modCount;
                    if (prev != null) {
                        prev.next = e.next;
                    } else {
                        tab[0] = e.next;
                    }
                    --this.count;
                } else {
                    if (e.key == null) {
                        e.setValue(value);
                        return entryValue == KeyFactory.NULL ? null : entryValue;
                    }
                    prev = e;
                }
                e = e.next;
            }
        }
        ++this.modCount;
        if (this.count >= this.threshold) {
            this.cleanup();
        }
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = (hash & Integer.MAX_VALUE) % tab.length;
        }
        tab[index] = e = new Entry(hash, key, value, tab[index]);
        ++this.count;
        return null;
    }

    public Object remove(Object key) {
        Entry[] tab = this.table;
        if (key != null) {
            int hash = key.hashCode();
            int index = (hash & Integer.MAX_VALUE) % tab.length;
            Entry e = tab[index];
            Entry prev = null;
            while (e != null) {
                Object entryValue = e.get();
                if (entryValue == null) {
                    ++this.modCount;
                    if (prev != null) {
                        prev.next = e.next;
                    } else {
                        tab[index] = e.next;
                    }
                    --this.count;
                } else {
                    if (e.hash == hash && key.equals(e.key)) {
                        ++this.modCount;
                        if (prev != null) {
                            prev.next = e.next;
                        } else {
                            tab[index] = e.next;
                        }
                        --this.count;
                        e.setValue((Object)null);
                        return entryValue == KeyFactory.NULL ? null : entryValue;
                    }
                    prev = e;
                }
                e = e.next;
            }
        } else {
            Entry e = tab[0];
            Entry prev = null;
            while (e != null) {
                Object entryValue = e.get();
                if (entryValue == null) {
                    ++this.modCount;
                    if (prev != null) {
                        prev.next = e.next;
                    } else {
                        tab[0] = e.next;
                    }
                    --this.count;
                } else {
                    if (e.key == null) {
                        ++this.modCount;
                        if (prev != null) {
                            prev.next = e.next;
                        } else {
                            tab[0] = e.next;
                        }
                        --this.count;
                        e.setValue((Object)null);
                        return entryValue == KeyFactory.NULL ? null : entryValue;
                    }
                    prev = e;
                }
                e = e.next;
            }
        }
        return null;
    }

    public void putAll(Map t) {
        Iterator i = t.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            this.put(e.getKey(), e.getValue());
        }
    }

    public void clear() {
        Entry[] tab = this.table;
        ++this.modCount;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.count = 0;
    }

    public Object clone() {
        try {
            SoftValuedHashMap t = (SoftValuedHashMap)super.clone();
            t.table = new Entry[this.table.length];
            int i = this.table.length;
            while (i-- > 0) {
                t.table[i] = this.table[i] != null ? (Entry)this.table[i].clone() : null;
            }
            t.keySet = null;
            t.entrySet = null;
            t.values = null;
            t.modCount = 0;
            return t;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public Set keySet() {
        if (this.keySet == null) {
            this.keySet = new AbstractSet(){

                public Iterator iterator() {
                    return SoftValuedHashMap.this.createHashIterator(0);
                }

                public int size() {
                    return SoftValuedHashMap.this.count;
                }

                public boolean contains(Object o) {
                    return SoftValuedHashMap.this.containsKey(o);
                }

                public boolean remove(Object o) {
                    if (o == null) {
                        if (SoftValuedHashMap.this.containsKey(null)) {
                            SoftValuedHashMap.this.remove(null);
                            return true;
                        }
                        return false;
                    }
                    return SoftValuedHashMap.this.remove(o) != null;
                }

                public void clear() {
                    SoftValuedHashMap.this.clear();
                }

                public String toString() {
                    return WeakIdentityMap.toString(this);
                }
            };
        }
        return this.keySet;
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new AbstractCollection(){

                public Iterator iterator() {
                    return SoftValuedHashMap.this.createHashIterator(1);
                }

                public int size() {
                    return SoftValuedHashMap.this.count;
                }

                public boolean contains(Object o) {
                    return SoftValuedHashMap.this.containsValue(o);
                }

                public void clear() {
                    SoftValuedHashMap.this.clear();
                }

                public String toString() {
                    return WeakIdentityMap.toString(this);
                }
            };
        }
        return this.values;
    }

    public Set entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet(){

                public Iterator iterator() {
                    return SoftValuedHashMap.this.createHashIterator(2);
                }

                public boolean contains(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)o;
                    Object key = entry.getKey();
                    Entry[] tab = SoftValuedHashMap.this.table;
                    int hash = key == null ? 0 : key.hashCode();
                    int index = (hash & Integer.MAX_VALUE) % tab.length;
                    Entry e = tab[index];
                    Entry prev = null;
                    while (e != null) {
                        Object entryValue = e.get();
                        if (entryValue == null) {
                            SoftValuedHashMap.this.modCount++;
                            if (prev != null) {
                                prev.next = e.next;
                            } else {
                                tab[index] = e.next;
                            }
                            SoftValuedHashMap.this.count--;
                        } else {
                            if (e.hash == hash && e.equals(entry)) {
                                return true;
                            }
                            prev = e;
                        }
                        e = e.next;
                    }
                    return false;
                }

                public boolean remove(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)o;
                    Object key = entry.getKey();
                    Entry[] tab = SoftValuedHashMap.this.table;
                    int hash = key == null ? 0 : key.hashCode();
                    int index = (hash & Integer.MAX_VALUE) % tab.length;
                    Entry e = tab[index];
                    Entry prev = null;
                    while (e != null) {
                        Object entryValue = e.get();
                        if (entryValue == null) {
                            SoftValuedHashMap.this.modCount++;
                            if (prev != null) {
                                prev.next = e.next;
                            } else {
                                tab[index] = e.next;
                            }
                            SoftValuedHashMap.this.count--;
                        } else {
                            if (e.hash == hash && e.equals(entry)) {
                                SoftValuedHashMap.this.modCount++;
                                if (prev != null) {
                                    prev.next = e.next;
                                } else {
                                    tab[index] = e.next;
                                }
                                SoftValuedHashMap.this.count--;
                                e.setValue((Object)null);
                                return true;
                            }
                            prev = e;
                        }
                        e = e.next;
                    }
                    return false;
                }

                public int size() {
                    return SoftValuedHashMap.this.count;
                }

                public void clear() {
                    SoftValuedHashMap.this.clear();
                }

                public String toString() {
                    return WeakIdentityMap.toString(this);
                }
            };
        }
        return this.entrySet;
    }

    public String toString() {
        this.cleanup();
        return WeakIdentityMap.toString(this);
    }

    private Iterator createHashIterator(int type) {
        if (this.count == 0) {
            return Collections.EMPTY_SET.iterator();
        }
        return new HashIterator(type);
    }

    private class HashIterator
    implements Iterator {
        private final int type;
        private final Entry[] table;
        private int index;
        private Object entryValue;
        private Entry entry;
        private Entry last;
        private int expectedModCount;

        HashIterator(int type) {
            this.expectedModCount = SoftValuedHashMap.this.modCount;
            this.table = SoftValuedHashMap.this.table;
            this.type = type;
            this.index = this.table.length;
        }

        public boolean hasNext() {
            while (this.entry == null || (this.entryValue = this.entry.get()) == null) {
                if (this.entry != null) {
                    this.remove(this.entry);
                    this.entry = this.entry.next;
                }
                if (this.entry != null) continue;
                if (this.index <= 0) {
                    return false;
                }
                this.entry = this.table[--this.index];
            }
            return true;
        }

        public Object next() {
            if (SoftValuedHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.last = this.entry;
            this.entry = this.entry.next;
            return this.type == 0 ? this.last.getKey() : (this.type == 1 ? this.last.getValue() : this.last);
        }

        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            if (SoftValuedHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.remove(this.last);
            this.last = null;
        }

        private void remove(Entry toRemove) {
            Entry[] tab = this.table;
            int index = (toRemove.hash & Integer.MAX_VALUE) % tab.length;
            Entry e = tab[index];
            Entry prev = null;
            while (e != null) {
                if (e == toRemove) {
                    SoftValuedHashMap.this.modCount++;
                    ++this.expectedModCount;
                    if (prev == null) {
                        tab[index] = e.next;
                    } else {
                        prev.next = e.next;
                    }
                    SoftValuedHashMap.this.count--;
                    return;
                }
                prev = e;
                e = e.next;
            }
            throw new ConcurrentModificationException();
        }
    }

    private static class Entry
    implements Map.Entry {
        int hash;
        Object key;
        Entry next;
        private Reference value;

        Entry(int hash, Object key, Object value, Entry next) {
            this.hash = hash;
            this.key = key;
            this.value = new SoftReference<Object>(value);
            this.next = next;
        }

        private Entry(int hash, Object key, Reference value, Entry next) {
            this.hash = hash;
            this.key = key;
            this.value = value;
            this.next = next;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            Object value = this.value.get();
            return value == KeyFactory.NULL ? null : value;
        }

        public Object setValue(Object value) {
            Object oldValue = this.getValue();
            this.value = new SoftReference<Object>(value == null ? KeyFactory.NULL : value);
            return oldValue;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            return this.equals((Map.Entry)obj);
        }

        boolean equals(Map.Entry e) {
            Object thisValue = this.get();
            if (thisValue == null) {
                return false;
            }
            if (thisValue == KeyFactory.NULL) {
                thisValue = null;
            }
            return (this.key == null ? e.getKey() == null : this.key.equals(e.getKey())) && (thisValue == null ? e.getValue() == null : thisValue.equals(e.getValue()));
        }

        public int hashCode() {
            return this.hash ^ this.get().hashCode();
        }

        public String toString() {
            return this.key + "=" + this.getValue();
        }

        protected Object clone() {
            return new Entry(this.hash, this.key, this.value, this.next == null ? null : (Entry)this.next.clone());
        }

        Object get() {
            return this.value.get();
        }
    }
}

