; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s                               -mtriple=x86_64-apple-darwin10 | FileCheck %s --check-prefix=ALL --check-prefix=SDAG
; RUN: llc < %s -fast-isel -fast-isel-abort=1 -mtriple=x86_64-apple-darwin10 | FileCheck %s --check-prefix=ALL --check-prefix=FAST

define zeroext i1 @fcmp_oeq(float %x, float %y) {
; SDAG-LABEL: fcmp_oeq:
; SDAG:       ## BB#0:
; SDAG-NEXT:    cmpeqss %xmm1, %xmm0
; SDAG-NEXT:    movd %xmm0, %eax
; SDAG-NEXT:    andl $1, %eax
; SDAG-NEXT:    ## kill: %AL<def> %AL<kill> %EAX<kill>
; SDAG-NEXT:    retq
;
; FAST-LABEL: fcmp_oeq:
; FAST:       ## BB#0:
; FAST-NEXT:    ucomiss %xmm1, %xmm0
; FAST-NEXT:    sete %al
; FAST-NEXT:    setnp %cl
; FAST-NEXT:    andb %al, %cl
; FAST-NEXT:    andb $1, %cl
; FAST-NEXT:    movzbl %cl, %eax
; FAST-NEXT:    retq
  %1 = fcmp oeq float %x, %y
  ret i1 %1
}

define zeroext i1 @fcmp_ogt(float %x, float %y) {
; SDAG-LABEL: fcmp_ogt:
; SDAG:       ## BB#0:
; SDAG-NEXT:    ucomiss %xmm1, %xmm0
; SDAG-NEXT:    seta %al
; SDAG-NEXT:    retq
;
; FAST-LABEL: fcmp_ogt:
; FAST:       ## BB#0:
; FAST-NEXT:    ucomiss %xmm1, %xmm0
; FAST-NEXT:    seta %al
; FAST-NEXT:    andb $1, %al
; FAST-NEXT:    movzbl %al, %eax
; FAST-NEXT:    retq
  %1 = fcmp ogt float %x, %y
  ret i1 %1
}

define zeroext i1 @fcmp_oge(float %x, float %y) {
; SDAG-LABEL: fcmp_oge:
; SDAG:       ## BB#0:
; SDAG-NEXT:    ucomiss %xmm1, %xmm0
; SDAG-NEXT:    setae %al
; SDAG-NEXT:    retq
;
; FAST-LABEL: fcmp_oge:
; FAST:       ## BB#0:
; FAST-NEXT:    ucomiss %xmm1, %xmm0
; FAST-NEXT:    setae %al
; FAST-NEXT:    andb $1, %al
; FAST-NEXT:    movzbl %al, %eax
; FAST-NEXT:    retq
  %1 = fcmp oge float %x, %y
  ret i1 %1
}

define zeroext i1 @fcmp_olt(float %x, float %y) {
; SDAG-LABEL: fcmp_olt:
; SDAG:       ## BB#0:
; SDAG-NEXT:    ucomiss %xmm0, %xmm1
; SDAG-NEXT:    seta %al
; SDAG-NEXT:    retq
;
; FAST-LABEL: fcmp_olt:
; FAST:       ## BB#0:
; FAST-NEXT:    ucomiss %xmm0, %xmm1
; FAST-NEXT:    seta %al
; FAST-NEXT:    andb $1, %al
; FAST-NEXT:    movzbl %al, %eax
; FAST-NEXT:    retq
  %1 = fcmp olt float %x, %y
  ret i1 %1
}

define zeroext i1 @fcmp_ole(float %x, float %y) {
; SDAG-LABEL: fcmp_ole:
; SDAG:       ## BB#0:
; SDAG-NEXT:    ucomiss %xmm0, %xmm1
; SDAG-NEXT:    setae %al
; SDAG-NEXT:    retq
;
; FAST-LABEL: fcmp_ole:
; FAST:       ## BB#0:
; FAST-NEXT:    ucomiss %xmm0, %xmm1
; FAST-NEXT:    setae %al
; FAST-NEXT:    andb $1, %al
; FAST-NEXT:    movzbl %al, %eax
; FAST-NEXT:    retq
  %1 = fcmp ole float %x, %y
  ret i1 %1
}

define zeroext i1 @fcmp_one(float %x, float %y) {
; SDAG-LABEL: fcmp_one:
; SDAG:       ## BB#0:
; SDAG-NEXT:    ucomiss %xmm1, %xmm0
; SDAG-NEXT:    setne %al
; SDAG-NEXT:    retq
;
; FAST-LABEL: fcmp_one:
; FAST:       ## BB#0:
; FAST-NEXT:    ucomiss %xmm1, %xmm0
; FAST-NEXT:    setne %al
; FAST-NEXT:    andb $1, %al
; FAST-NEXT:    movzbl %al, %eax
; FAST-NEXT:    retq
  %1 = fcmp one float %x, %y
  ret i1 %1
}

define zeroext i1 @fcmp_ord(float %x, float %y) {
; SDAG-LABEL: fcmp_ord:
; SDAG:       ## BB#0:
; SDAG-NEXT:    ucomiss %xmm1, %xmm0
; SDAG-NEXT:    setnp %al
; SDAG-NEXT:    retq
;
; FAST-LABEL: fcmp_ord:
; FAST:       ## BB#0:
; FAST-NEXT:    ucomiss %xmm1, %xmm0
; FAST-NEXT:    setnp %al
; FAST-NEXT:    andb $1, %al
; FAST-NEXT:    movzbl %al, %eax
; FAST-NEXT:    retq
  %1 = fcmp ord float %x, %y
  ret i1 %1
}

define zeroext i1 @fcmp_uno(float %x, float %y) {
; SDAG-LABEL: fcmp_uno:
; SDAG:       ## BB#0:
; SDAG-NEXT:    ucomiss %xmm1, %xmm0
; SDAG-NEXT:    setp %al
; SDAG-NEXT:    retq
;
; FAST-LABEL: fcmp_uno:
; FAST:       ## BB#0:
; FAST-NEXT:    ucomiss %xmm1, %xmm0
; FAST-NEXT:    setp %al
; FAST-NEXT:    andb $1, %al
; FAST-NEXT:    movzbl %al, %eax
; FAST-NEXT:    retq
  %1 = fcmp uno float %x, %y
  ret i1 %1
}

define zeroext i1 @fcmp_ueq(float %x, float %y) {
; SDAG-LABEL: fcmp_ueq:
; SDAG:       ## BB#0:
; SDAG-NEXT:    ucomiss %xmm1, %xmm0
; SDAG-NEXT:    sete %al
; SDAG-NEXT:    retq
;
; FAST-LABEL: fcmp_ueq:
; FAST:       ## BB#0:
; FAST-NEXT:    ucomiss %xmm1, %xmm0
; FAST-NEXT:    sete %al
; FAST-NEXT:    andb $1, %al
; FAST-NEXT:    movzbl %al, %eax
; FAST-NEXT:    retq
  %1 = fcmp ueq float %x, %y
  ret i1 %1
}

define zeroext i1 @fcmp_ugt(float %x, float %y) {
; SDAG-LABEL: fcmp_ugt:
; SDAG:       ## BB#0:
; SDAG-NEXT:    ucomiss %xmm0, %xmm1
; SDAG-NEXT:    setb %al
; SDAG-NEXT:    retq
;
; FAST-LABEL: fcmp_ugt:
; FAST:       ## BB#0:
; FAST-NEXT:    ucomiss %xmm0, %xmm1
; FAST-NEXT:    setb %al
; FAST-NEXT:    andb $1, %al
; FAST-NEXT:    movzbl %al, %eax
; FAST-NEXT:    retq
  %1 = fcmp ugt float %x, %y
  ret i1 %1
}

define zeroext i1 @fcmp_uge(float %x, float %y) {
; SDAG-LABEL: fcmp_uge:
; SDAG:       ## BB#0:
; SDAG-NEXT:    ucomiss %xmm0, %xmm1
; SDAG-NEXT:    setbe %al
; SDAG-NEXT:    retq
;
; FAST-LABEL: fcmp_uge:
; FAST:       ## BB#0:
; FAST-NEXT:    ucomiss %xmm0, %xmm1
; FAST-NEXT:    setbe %al
; FAST-NEXT:    andb $1, %al
; FAST-NEXT:    movzbl %al, %eax
; FAST-NEXT:    retq
  %1 = fcmp uge float %x, %y
  ret i1 %1
}

define zeroext i1 @fcmp_ult(float %x, float %y) {
; SDAG-LABEL: fcmp_ult:
; SDAG:       ## BB#0:
; SDAG-NEXT:    ucomiss %xmm1, %xmm0
; SDAG-NEXT:    setb %al
; SDAG-NEXT:    retq
;
; FAST-LABEL: fcmp_ult:
; FAST:       ## BB#0:
; FAST-NEXT:    ucomiss %xmm1, %xmm0
; FAST-NEXT:    setb %al
; FAST-NEXT:    andb $1, %al
; FAST-NEXT:    movzbl %al, %eax
; FAST-NEXT:    retq
  %1 = fcmp ult float %x, %y
  ret i1 %1
}

define zeroext i1 @fcmp_ule(float %x, float %y) {
; SDAG-LABEL: fcmp_ule:
; SDAG:       ## BB#0:
; SDAG-NEXT:    ucomiss %xmm1, %xmm0
; SDAG-NEXT:    setbe %al
; SDAG-NEXT:    retq
;
; FAST-LABEL: fcmp_ule:
; FAST:       ## BB#0:
; FAST-NEXT:    ucomiss %xmm1, %xmm0
; FAST-NEXT:    setbe %al
; FAST-NEXT:    andb $1, %al
; FAST-NEXT:    movzbl %al, %eax
; FAST-NEXT:    retq
  %1 = fcmp ule float %x, %y
  ret i1 %1
}

define zeroext i1 @fcmp_une(float %x, float %y) {
; SDAG-LABEL: fcmp_une:
; SDAG:       ## BB#0:
; SDAG-NEXT:    cmpneqss %xmm1, %xmm0
; SDAG-NEXT:    movd %xmm0, %eax
; SDAG-NEXT:    andl $1, %eax
; SDAG-NEXT:    ## kill: %AL<def> %AL<kill> %EAX<kill>
; SDAG-NEXT:    retq
;
; FAST-LABEL: fcmp_une:
; FAST:       ## BB#0:
; FAST-NEXT:    ucomiss %xmm1, %xmm0
; FAST-NEXT:    setne %al
; FAST-NEXT:    setp %cl
; FAST-NEXT:    orb %al, %cl
; FAST-NEXT:    andb $1, %cl
; FAST-NEXT:    movzbl %cl, %eax
; FAST-NEXT:    retq
  %1 = fcmp une float %x, %y
  ret i1 %1
}

define zeroext i1 @icmp_eq(i32 %x, i32 %y) {
; SDAG-LABEL: icmp_eq:
; SDAG:       ## BB#0:
; SDAG-NEXT:    cmpl %esi, %edi
; SDAG-NEXT:    sete %al
; SDAG-NEXT:    retq
;
; FAST-LABEL: icmp_eq:
; FAST:       ## BB#0:
; FAST-NEXT:    cmpl %esi, %edi
; FAST-NEXT:    sete %al
; FAST-NEXT:    andb $1, %al
; FAST-NEXT:    movzbl %al, %eax
; FAST-NEXT:    retq
  %1 = icmp eq i32 %x, %y
  ret i1 %1
}

define zeroext i1 @icmp_ne(i32 %x, i32 %y) {
; SDAG-LABEL: icmp_ne:
; SDAG:       ## BB#0:
; SDAG-NEXT:    cmpl %esi, %edi
; SDAG-NEXT:    setne %al
; SDAG-NEXT:    retq
;
; FAST-LABEL: icmp_ne:
; FAST:       ## BB#0:
; FAST-NEXT:    cmpl %esi, %edi
; FAST-NEXT:    setne %al
; FAST-NEXT:    andb $1, %al
; FAST-NEXT:    movzbl %al, %eax
; FAST-NEXT:    retq
  %1 = icmp ne i32 %x, %y
  ret i1 %1
}

define zeroext i1 @icmp_ugt(i32 %x, i32 %y) {
; SDAG-LABEL: icmp_ugt:
; SDAG:       ## BB#0:
; SDAG-NEXT:    cmpl %esi, %edi
; SDAG-NEXT:    seta %al
; SDAG-NEXT:    retq
;
; FAST-LABEL: icmp_ugt:
; FAST:       ## BB#0:
; FAST-NEXT:    cmpl %esi, %edi
; FAST-NEXT:    seta %al
; FAST-NEXT:    andb $1, %al
; FAST-NEXT:    movzbl %al, %eax
; FAST-NEXT:    retq
  %1 = icmp ugt i32 %x, %y
  ret i1 %1
}

define zeroext i1 @icmp_uge(i32 %x, i32 %y) {
; SDAG-LABEL: icmp_uge:
; SDAG:       ## BB#0:
; SDAG-NEXT:    cmpl %esi, %edi
; SDAG-NEXT:    setae %al
; SDAG-NEXT:    retq
;
; FAST-LABEL: icmp_uge:
; FAST:       ## BB#0:
; FAST-NEXT:    cmpl %esi, %edi
; FAST-NEXT:    setae %al
; FAST-NEXT:    andb $1, %al
; FAST-NEXT:    movzbl %al, %eax
; FAST-NEXT:    retq
  %1 = icmp uge i32 %x, %y
  ret i1 %1
}

define zeroext i1 @icmp_ult(i32 %x, i32 %y) {
; SDAG-LABEL: icmp_ult:
; SDAG:       ## BB#0:
; SDAG-NEXT:    cmpl %esi, %edi
; SDAG-NEXT:    setb %al
; SDAG-NEXT:    retq
;
; FAST-LABEL: icmp_ult:
; FAST:       ## BB#0:
; FAST-NEXT:    cmpl %esi, %edi
; FAST-NEXT:    setb %al
; FAST-NEXT:    andb $1, %al
; FAST-NEXT:    movzbl %al, %eax
; FAST-NEXT:    retq
  %1 = icmp ult i32 %x, %y
  ret i1 %1
}

define zeroext i1 @icmp_ule(i32 %x, i32 %y) {
; SDAG-LABEL: icmp_ule:
; SDAG:       ## BB#0:
; SDAG-NEXT:    cmpl %esi, %edi
; SDAG-NEXT:    setbe %al
; SDAG-NEXT:    retq
;
; FAST-LABEL: icmp_ule:
; FAST:       ## BB#0:
; FAST-NEXT:    cmpl %esi, %edi
; FAST-NEXT:    setbe %al
; FAST-NEXT:    andb $1, %al
; FAST-NEXT:    movzbl %al, %eax
; FAST-NEXT:    retq
  %1 = icmp ule i32 %x, %y
  ret i1 %1
}

define zeroext i1 @icmp_sgt(i32 %x, i32 %y) {
; SDAG-LABEL: icmp_sgt:
; SDAG:       ## BB#0:
; SDAG-NEXT:    cmpl %esi, %edi
; SDAG-NEXT:    setg %al
; SDAG-NEXT:    retq
;
; FAST-LABEL: icmp_sgt:
; FAST:       ## BB#0:
; FAST-NEXT:    cmpl %esi, %edi
; FAST-NEXT:    setg %al
; FAST-NEXT:    andb $1, %al
; FAST-NEXT:    movzbl %al, %eax
; FAST-NEXT:    retq
  %1 = icmp sgt i32 %x, %y
  ret i1 %1
}

define zeroext i1 @icmp_sge(i32 %x, i32 %y) {
; SDAG-LABEL: icmp_sge:
; SDAG:       ## BB#0:
; SDAG-NEXT:    cmpl %esi, %edi
; SDAG-NEXT:    setge %al
; SDAG-NEXT:    retq
;
; FAST-LABEL: icmp_sge:
; FAST:       ## BB#0:
; FAST-NEXT:    cmpl %esi, %edi
; FAST-NEXT:    setge %al
; FAST-NEXT:    andb $1, %al
; FAST-NEXT:    movzbl %al, %eax
; FAST-NEXT:    retq
  %1 = icmp sge i32 %x, %y
  ret i1 %1
}

define zeroext i1 @icmp_slt(i32 %x, i32 %y) {
; SDAG-LABEL: icmp_slt:
; SDAG:       ## BB#0:
; SDAG-NEXT:    cmpl %esi, %edi
; SDAG-NEXT:    setl %al
; SDAG-NEXT:    retq
;
; FAST-LABEL: icmp_slt:
; FAST:       ## BB#0:
; FAST-NEXT:    cmpl %esi, %edi
; FAST-NEXT:    setl %al
; FAST-NEXT:    andb $1, %al
; FAST-NEXT:    movzbl %al, %eax
; FAST-NEXT:    retq
  %1 = icmp slt i32 %x, %y
  ret i1 %1
}

define zeroext i1 @icmp_sle(i32 %x, i32 %y) {
; SDAG-LABEL: icmp_sle:
; SDAG:       ## BB#0:
; SDAG-NEXT:    cmpl %esi, %edi
; SDAG-NEXT:    setle %al
; SDAG-NEXT:    retq
;
; FAST-LABEL: icmp_sle:
; FAST:       ## BB#0:
; FAST-NEXT:    cmpl %esi, %edi
; FAST-NEXT:    setle %al
; FAST-NEXT:    andb $1, %al
; FAST-NEXT:    movzbl %al, %eax
; FAST-NEXT:    retq
  %1 = icmp sle i32 %x, %y
  ret i1 %1
}

; Test cmp folding and condition optimization.
define zeroext i1 @fcmp_oeq2(float %x) {
; SDAG-LABEL: fcmp_oeq2:
; SDAG:       ## BB#0:
; SDAG-NEXT:    ucomiss %xmm0, %xmm0
; SDAG-NEXT:    setnp %al
; SDAG-NEXT:    retq
;
; FAST-LABEL: fcmp_oeq2:
; FAST:       ## BB#0:
; FAST-NEXT:    ucomiss %xmm0, %xmm0
; FAST-NEXT:    setnp %al
; FAST-NEXT:    andb $1, %al
; FAST-NEXT:    movzbl %al, %eax
; FAST-NEXT:    retq
  %1 = fcmp oeq float %x, %x
  ret i1 %1
}

define zeroext i1 @fcmp_oeq3(float %x) {
; SDAG-LABEL: fcmp_oeq3:
; SDAG:       ## BB#0:
; SDAG-NEXT:    xorps %xmm1, %xmm1
; SDAG-NEXT:    cmpeqss %xmm0, %xmm1
; SDAG-NEXT:    movd %xmm1, %eax
; SDAG-NEXT:    andl $1, %eax
; SDAG-NEXT:    ## kill: %AL<def> %AL<kill> %EAX<kill>
; SDAG-NEXT:    retq
;
; FAST-LABEL: fcmp_oeq3:
; FAST:       ## BB#0:
; FAST-NEXT:    xorps %xmm1, %xmm1
; FAST-NEXT:    ucomiss %xmm1, %xmm0
; FAST-NEXT:    sete %al
; FAST-NEXT:    setnp %cl
; FAST-NEXT:    andb %al, %cl
; FAST-NEXT:    andb $1, %cl
; FAST-NEXT:    movzbl %cl, %eax
; FAST-NEXT:    retq
  %1 = fcmp oeq float %x, 0.000000e+00
  ret i1 %1
}

define zeroext i1 @fcmp_ogt2(float %x) {
; SDAG-LABEL: fcmp_ogt2:
; SDAG:       ## BB#0:
; SDAG-NEXT:    xorl %eax, %eax
; SDAG-NEXT:    retq
;
; FAST-LABEL: fcmp_ogt2:
; FAST:       ## BB#0:
; FAST-NEXT:    xorl %eax, %eax
; FAST-NEXT:    andb $1, %al
; FAST-NEXT:    movzbl %al, %eax
; FAST-NEXT:    retq
  %1 = fcmp ogt float %x, %x
  ret i1 %1
}

define zeroext i1 @fcmp_ogt3(float %x) {
; SDAG-LABEL: fcmp_ogt3:
; SDAG:       ## BB#0:
; SDAG-NEXT:    xorps %xmm1, %xmm1
; SDAG-NEXT:    ucomiss %xmm1, %xmm0
; SDAG-NEXT:    seta %al
; SDAG-NEXT:    retq
;
; FAST-LABEL: fcmp_ogt3:
; FAST:       ## BB#0:
; FAST-NEXT:    xorps %xmm1, %xmm1
; FAST-NEXT:    ucomiss %xmm1, %xmm0
; FAST-NEXT:    seta %al
; FAST-NEXT:    andb $1, %al
; FAST-NEXT:    movzbl %al, %eax
; FAST-NEXT:    retq
  %1 = fcmp ogt float %x, 0.000000e+00
  ret i1 %1
}

define zeroext i1 @fcmp_oge2(float %x) {
; SDAG-LABEL: fcmp_oge2:
; SDAG:       ## BB#0:
; SDAG-NEXT:    ucomiss %xmm0, %xmm0
; SDAG-NEXT:    setnp %al
; SDAG-NEXT:    retq
;
; FAST-LABEL: fcmp_oge2:
; FAST:       ## BB#0:
; FAST-NEXT:    ucomiss %xmm0, %xmm0
; FAST-NEXT:    setnp %al
; FAST-NEXT:    andb $1, %al
; FAST-NEXT:    movzbl %al, %eax
; FAST-NEXT:    retq
  %1 = fcmp oge float %x, %x
  ret i1 %1
}

define zeroext i1 @fcmp_oge3(float %x) {
; SDAG-LABEL: fcmp_oge3:
; SDAG:       ## BB#0:
; SDAG-NEXT:    xorps %xmm1, %xmm1
; SDAG-NEXT:    ucomiss %xmm1, %xmm0
; SDAG-NEXT:    setae %al
; SDAG-NEXT:    retq
;
; FAST-LABEL: fcmp_oge3:
; FAST:       ## BB#0:
; FAST-NEXT:    xorps %xmm1, %xmm1
; FAST-NEXT:    ucomiss %xmm1, %xmm0
; FAST-NEXT:    setae %al
; FAST-NEXT:    andb $1, %al
; FAST-NEXT:    movzbl %al, %eax
; FAST-NEXT:    retq
  %1 = fcmp oge float %x, 0.000000e+00
  ret i1 %1
}

define zeroext i1 @fcmp_olt2(float %x) {
; SDAG-LABEL: fcmp_olt2:
; SDAG:       ## BB#0:
; SDAG-NEXT:    xorl %eax, %eax
; SDAG-NEXT:    retq
;
; FAST-LABEL: fcmp_olt2:
; FAST:       ## BB#0:
; FAST-NEXT:    xorl %eax, %eax
; FAST-NEXT:    andb $1, %al
; FAST-NEXT:    movzbl %al, %eax
; FAST-NEXT:    retq
  %1 = fcmp olt float %x, %x
  ret i1 %1
}

define zeroext i1 @fcmp_olt3(float %x) {
; SDAG-LABEL: fcmp_olt3:
; SDAG:       ## BB#0:
; SDAG-NEXT:    xorps %xmm1, %xmm1
; SDAG-NEXT:    ucomiss %xmm0, %xmm1
; SDAG-NEXT:    seta %al
; SDAG-NEXT:    retq
;
; FAST-LABEL: fcmp_olt3:
; FAST:       ## BB#0:
; FAST-NEXT:    xorps %xmm1, %xmm1
; FAST-NEXT:    ucomiss %xmm0, %xmm1
; FAST-NEXT:    seta %al
; FAST-NEXT:    andb $1, %al
; FAST-NEXT:    movzbl %al, %eax
; FAST-NEXT:    retq
  %1 = fcmp olt float %x, 0.000000e+00
  ret i1 %1
}

define zeroext i1 @fcmp_ole2(float %x) {
; SDAG-LABEL: fcmp_ole2:
; SDAG:       ## BB#0:
; SDAG-NEXT:    ucomiss %xmm0, %xmm0
; SDAG-NEXT:    setnp %al
; SDAG-NEXT:    retq
;
; FAST-LABEL: fcmp_ole2:
; FAST:       ## BB#0:
; FAST-NEXT:    ucomiss %xmm0, %xmm0
; FAST-NEXT:    setnp %al
; FAST-NEXT:    andb $1, %al
; FAST-NEXT:    movzbl %al, %eax
; FAST-NEXT:    retq
  %1 = fcmp ole float %x, %x
  ret i1 %1
}

define zeroext i1 @fcmp_ole3(float %x) {
; SDAG-LABEL: fcmp_ole3:
; SDAG:       ## BB#0:
; SDAG-NEXT:    xorps %xmm1, %xmm1
; SDAG-NEXT:    ucomiss %xmm0, %xmm1
; SDAG-NEXT:    setae %al
; SDAG-NEXT:    retq
;
; FAST-LABEL: fcmp_ole3:
; FAST:       ## BB#0:
; FAST-NEXT:    xorps %xmm1, %xmm1
; FAST-NEXT:    ucomiss %xmm0, %xmm1
; FAST-NEXT:    setae %al
; FAST-NEXT:    andb $1, %al
; FAST-NEXT:    movzbl %al, %eax
; FAST-NEXT:    retq
  %1 = fcmp ole float %x, 0.000000e+00
  ret i1 %1
}

define zeroext i1 @fcmp_one2(float %x) {
; SDAG-LABEL: fcmp_one2:
; SDAG:       ## BB#0:
; SDAG-NEXT:    xorl %eax, %eax
; SDAG-NEXT:    retq
;
; FAST-LABEL: fcmp_one2:
; FAST:       ## BB#0:
; FAST-NEXT:    xorl %eax, %eax
; FAST-NEXT:    andb $1, %al
; FAST-NEXT:    movzbl %al, %eax
; FAST-NEXT:    retq
  %1 = fcmp one float %x, %x
  ret i1 %1
}

define zeroext i1 @fcmp_one3(float %x) {
; SDAG-LABEL: fcmp_one3:
; SDAG:       ## BB#0:
; SDAG-NEXT:    xorps %xmm1, %xmm1
; SDAG-NEXT:    ucomiss %xmm1, %xmm0
; SDAG-NEXT:    setne %al
; SDAG-NEXT:    retq
;
; FAST-LABEL: fcmp_one3:
; FAST:       ## BB#0:
; FAST-NEXT:    xorps %xmm1, %xmm1
; FAST-NEXT:    ucomiss %xmm1, %xmm0
; FAST-NEXT:    setne %al
; FAST-NEXT:    andb $1, %al
; FAST-NEXT:    movzbl %al, %eax
; FAST-NEXT:    retq
  %1 = fcmp one float %x, 0.000000e+00
  ret i1 %1
}

define zeroext i1 @fcmp_ord2(float %x) {
; SDAG-LABEL: fcmp_ord2:
; SDAG:       ## BB#0:
; SDAG-NEXT:    ucomiss %xmm0, %xmm0
; SDAG-NEXT:    setnp %al
; SDAG-NEXT:    retq
;
; FAST-LABEL: fcmp_ord2:
; FAST:       ## BB#0:
; FAST-NEXT:    ucomiss %xmm0, %xmm0
; FAST-NEXT:    setnp %al
; FAST-NEXT:    andb $1, %al
; FAST-NEXT:    movzbl %al, %eax
; FAST-NEXT:    retq
  %1 = fcmp ord float %x, %x
  ret i1 %1
}

define zeroext i1 @fcmp_ord3(float %x) {
; SDAG-LABEL: fcmp_ord3:
; SDAG:       ## BB#0:
; SDAG-NEXT:    ucomiss %xmm0, %xmm0
; SDAG-NEXT:    setnp %al
; SDAG-NEXT:    retq
;
; FAST-LABEL: fcmp_ord3:
; FAST:       ## BB#0:
; FAST-NEXT:    ucomiss %xmm0, %xmm0
; FAST-NEXT:    setnp %al
; FAST-NEXT:    andb $1, %al
; FAST-NEXT:    movzbl %al, %eax
; FAST-NEXT:    retq
  %1 = fcmp ord float %x, 0.000000e+00
  ret i1 %1
}

define zeroext i1 @fcmp_uno2(float %x) {
; SDAG-LABEL: fcmp_uno2:
; SDAG:       ## BB#0:
; SDAG-NEXT:    ucomiss %xmm0, %xmm0
; SDAG-NEXT:    setp %al
; SDAG-NEXT:    retq
;
; FAST-LABEL: fcmp_uno2:
; FAST:       ## BB#0:
; FAST-NEXT:    ucomiss %xmm0, %xmm0
; FAST-NEXT:    setp %al
; FAST-NEXT:    andb $1, %al
; FAST-NEXT:    movzbl %al, %eax
; FAST-NEXT:    retq
  %1 = fcmp uno float %x, %x
  ret i1 %1
}

define zeroext i1 @fcmp_uno3(float %x) {
; SDAG-LABEL: fcmp_uno3:
; SDAG:       ## BB#0:
; SDAG-NEXT:    ucomiss %xmm0, %xmm0
; SDAG-NEXT:    setp %al
; SDAG-NEXT:    retq
;
; FAST-LABEL: fcmp_uno3:
; FAST:       ## BB#0:
; FAST-NEXT:    ucomiss %xmm0, %xmm0
; FAST-NEXT:    setp %al
; FAST-NEXT:    andb $1, %al
; FAST-NEXT:    movzbl %al, %eax
; FAST-NEXT:    retq
  %1 = fcmp uno float %x, 0.000000e+00
  ret i1 %1
}

define zeroext i1 @fcmp_ueq2(float %x) {
; SDAG-LABEL: fcmp_ueq2:
; SDAG:       ## BB#0:
; SDAG-NEXT:    movb $1, %al
; SDAG-NEXT:    retq
;
; FAST-LABEL: fcmp_ueq2:
; FAST:       ## BB#0:
; FAST-NEXT:    movb $1, %al
; FAST-NEXT:    andb $1, %al
; FAST-NEXT:    movzbl %al, %eax
; FAST-NEXT:    retq
  %1 = fcmp ueq float %x, %x
  ret i1 %1
}

define zeroext i1 @fcmp_ueq3(float %x) {
; SDAG-LABEL: fcmp_ueq3:
; SDAG:       ## BB#0:
; SDAG-NEXT:    xorps %xmm1, %xmm1
; SDAG-NEXT:    ucomiss %xmm1, %xmm0
; SDAG-NEXT:    sete %al
; SDAG-NEXT:    retq
;
; FAST-LABEL: fcmp_ueq3:
; FAST:       ## BB#0:
; FAST-NEXT:    xorps %xmm1, %xmm1
; FAST-NEXT:    ucomiss %xmm1, %xmm0
; FAST-NEXT:    sete %al
; FAST-NEXT:    andb $1, %al
; FAST-NEXT:    movzbl %al, %eax
; FAST-NEXT:    retq
  %1 = fcmp ueq float %x, 0.000000e+00
  ret i1 %1
}

define zeroext i1 @fcmp_ugt2(float %x) {
; SDAG-LABEL: fcmp_ugt2:
; SDAG:       ## BB#0:
; SDAG-NEXT:    ucomiss %xmm0, %xmm0
; SDAG-NEXT:    setp %al
; SDAG-NEXT:    retq
;
; FAST-LABEL: fcmp_ugt2:
; FAST:       ## BB#0:
; FAST-NEXT:    ucomiss %xmm0, %xmm0
; FAST-NEXT:    setp %al
; FAST-NEXT:    andb $1, %al
; FAST-NEXT:    movzbl %al, %eax
; FAST-NEXT:    retq
  %1 = fcmp ugt float %x, %x
  ret i1 %1
}

define zeroext i1 @fcmp_ugt3(float %x) {
; SDAG-LABEL: fcmp_ugt3:
; SDAG:       ## BB#0:
; SDAG-NEXT:    xorps %xmm1, %xmm1
; SDAG-NEXT:    ucomiss %xmm0, %xmm1
; SDAG-NEXT:    setb %al
; SDAG-NEXT:    retq
;
; FAST-LABEL: fcmp_ugt3:
; FAST:       ## BB#0:
; FAST-NEXT:    xorps %xmm1, %xmm1
; FAST-NEXT:    ucomiss %xmm0, %xmm1
; FAST-NEXT:    setb %al
; FAST-NEXT:    andb $1, %al
; FAST-NEXT:    movzbl %al, %eax
; FAST-NEXT:    retq
  %1 = fcmp ugt float %x, 0.000000e+00
  ret i1 %1
}

define zeroext i1 @fcmp_uge2(float %x) {
; SDAG-LABEL: fcmp_uge2:
; SDAG:       ## BB#0:
; SDAG-NEXT:    movb $1, %al
; SDAG-NEXT:    retq
;
; FAST-LABEL: fcmp_uge2:
; FAST:       ## BB#0:
; FAST-NEXT:    movb $1, %al
; FAST-NEXT:    andb $1, %al
; FAST-NEXT:    movzbl %al, %eax
; FAST-NEXT:    retq
  %1 = fcmp uge float %x, %x
  ret i1 %1
}

define zeroext i1 @fcmp_uge3(float %x) {
; SDAG-LABEL: fcmp_uge3:
; SDAG:       ## BB#0:
; SDAG-NEXT:    xorps %xmm1, %xmm1
; SDAG-NEXT:    ucomiss %xmm0, %xmm1
; SDAG-NEXT:    setbe %al
; SDAG-NEXT:    retq
;
; FAST-LABEL: fcmp_uge3:
; FAST:       ## BB#0:
; FAST-NEXT:    xorps %xmm1, %xmm1
; FAST-NEXT:    ucomiss %xmm0, %xmm1
; FAST-NEXT:    setbe %al
; FAST-NEXT:    andb $1, %al
; FAST-NEXT:    movzbl %al, %eax
; FAST-NEXT:    retq
  %1 = fcmp uge float %x, 0.000000e+00
  ret i1 %1
}

define zeroext i1 @fcmp_ult2(float %x) {
; SDAG-LABEL: fcmp_ult2:
; SDAG:       ## BB#0:
; SDAG-NEXT:    ucomiss %xmm0, %xmm0
; SDAG-NEXT:    setp %al
; SDAG-NEXT:    retq
;
; FAST-LABEL: fcmp_ult2:
; FAST:       ## BB#0:
; FAST-NEXT:    ucomiss %xmm0, %xmm0
; FAST-NEXT:    setp %al
; FAST-NEXT:    andb $1, %al
; FAST-NEXT:    movzbl %al, %eax
; FAST-NEXT:    retq
  %1 = fcmp ult float %x, %x
  ret i1 %1
}

define zeroext i1 @fcmp_ult3(float %x) {
; SDAG-LABEL: fcmp_ult3:
; SDAG:       ## BB#0:
; SDAG-NEXT:    xorps %xmm1, %xmm1
; SDAG-NEXT:    ucomiss %xmm1, %xmm0
; SDAG-NEXT:    setb %al
; SDAG-NEXT:    retq
;
; FAST-LABEL: fcmp_ult3:
; FAST:       ## BB#0:
; FAST-NEXT:    xorps %xmm1, %xmm1
; FAST-NEXT:    ucomiss %xmm1, %xmm0
; FAST-NEXT:    setb %al
; FAST-NEXT:    andb $1, %al
; FAST-NEXT:    movzbl %al, %eax
; FAST-NEXT:    retq
  %1 = fcmp ult float %x, 0.000000e+00
  ret i1 %1
}

define zeroext i1 @fcmp_ule2(float %x) {
; SDAG-LABEL: fcmp_ule2:
; SDAG:       ## BB#0:
; SDAG-NEXT:    movb $1, %al
; SDAG-NEXT:    retq
;
; FAST-LABEL: fcmp_ule2:
; FAST:       ## BB#0:
; FAST-NEXT:    movb $1, %al
; FAST-NEXT:    andb $1, %al
; FAST-NEXT:    movzbl %al, %eax
; FAST-NEXT:    retq
  %1 = fcmp ule float %x, %x
  ret i1 %1
}

define zeroext i1 @fcmp_ule3(float %x) {
; SDAG-LABEL: fcmp_ule3:
; SDAG:       ## BB#0:
; SDAG-NEXT:    xorps %xmm1, %xmm1
; SDAG-NEXT:    ucomiss %xmm1, %xmm0
; SDAG-NEXT:    setbe %al
; SDAG-NEXT:    retq
;
; FAST-LABEL: fcmp_ule3:
; FAST:       ## BB#0:
; FAST-NEXT:    xorps %xmm1, %xmm1
; FAST-NEXT:    ucomiss %xmm1, %xmm0
; FAST-NEXT:    setbe %al
; FAST-NEXT:    andb $1, %al
; FAST-NEXT:    movzbl %al, %eax
; FAST-NEXT:    retq
  %1 = fcmp ule float %x, 0.000000e+00
  ret i1 %1
}

define zeroext i1 @fcmp_une2(float %x) {
; SDAG-LABEL: fcmp_une2:
; SDAG:       ## BB#0:
; SDAG-NEXT:    ucomiss %xmm0, %xmm0
; SDAG-NEXT:    setp %al
; SDAG-NEXT:    retq
;
; FAST-LABEL: fcmp_une2:
; FAST:       ## BB#0:
; FAST-NEXT:    ucomiss %xmm0, %xmm0
; FAST-NEXT:    setp %al
; FAST-NEXT:    andb $1, %al
; FAST-NEXT:    movzbl %al, %eax
; FAST-NEXT:    retq
  %1 = fcmp une float %x, %x
  ret i1 %1
}

define zeroext i1 @fcmp_une3(float %x) {
; SDAG-LABEL: fcmp_une3:
; SDAG:       ## BB#0:
; SDAG-NEXT:    xorps %xmm1, %xmm1
; SDAG-NEXT:    cmpneqss %xmm0, %xmm1
; SDAG-NEXT:    movd %xmm1, %eax
; SDAG-NEXT:    andl $1, %eax
; SDAG-NEXT:    ## kill: %AL<def> %AL<kill> %EAX<kill>
; SDAG-NEXT:    retq
;
; FAST-LABEL: fcmp_une3:
; FAST:       ## BB#0:
; FAST-NEXT:    xorps %xmm1, %xmm1
; FAST-NEXT:    ucomiss %xmm1, %xmm0
; FAST-NEXT:    setne %al
; FAST-NEXT:    setp %cl
; FAST-NEXT:    orb %al, %cl
; FAST-NEXT:    andb $1, %cl
; FAST-NEXT:    movzbl %cl, %eax
; FAST-NEXT:    retq
  %1 = fcmp une float %x, 0.000000e+00
  ret i1 %1
}

define zeroext i1 @icmp_eq2(i32 %x) {
; SDAG-LABEL: icmp_eq2:
; SDAG:       ## BB#0:
; SDAG-NEXT:    movb $1, %al
; SDAG-NEXT:    retq
;
; FAST-LABEL: icmp_eq2:
; FAST:       ## BB#0:
; FAST-NEXT:    movb $1, %al
; FAST-NEXT:    andb $1, %al
; FAST-NEXT:    movzbl %al, %eax
; FAST-NEXT:    retq
  %1 = icmp eq i32 %x, %x
  ret i1 %1
}

define zeroext i1 @icmp_ne2(i32 %x) {
; SDAG-LABEL: icmp_ne2:
; SDAG:       ## BB#0:
; SDAG-NEXT:    xorl %eax, %eax
; SDAG-NEXT:    retq
;
; FAST-LABEL: icmp_ne2:
; FAST:       ## BB#0:
; FAST-NEXT:    xorl %eax, %eax
; FAST-NEXT:    andb $1, %al
; FAST-NEXT:    movzbl %al, %eax
; FAST-NEXT:    retq
  %1 = icmp ne i32 %x, %x
  ret i1 %1
}

define zeroext i1 @icmp_ugt2(i32 %x) {
; SDAG-LABEL: icmp_ugt2:
; SDAG:       ## BB#0:
; SDAG-NEXT:    xorl %eax, %eax
; SDAG-NEXT:    retq
;
; FAST-LABEL: icmp_ugt2:
; FAST:       ## BB#0:
; FAST-NEXT:    xorl %eax, %eax
; FAST-NEXT:    andb $1, %al
; FAST-NEXT:    movzbl %al, %eax
; FAST-NEXT:    retq
  %1 = icmp ugt i32 %x, %x
  ret i1 %1
}

define zeroext i1 @icmp_uge2(i32 %x) {
; SDAG-LABEL: icmp_uge2:
; SDAG:       ## BB#0:
; SDAG-NEXT:    movb $1, %al
; SDAG-NEXT:    retq
;
; FAST-LABEL: icmp_uge2:
; FAST:       ## BB#0:
; FAST-NEXT:    movb $1, %al
; FAST-NEXT:    andb $1, %al
; FAST-NEXT:    movzbl %al, %eax
; FAST-NEXT:    retq
  %1 = icmp uge i32 %x, %x
  ret i1 %1
}

define zeroext i1 @icmp_ult2(i32 %x) {
; SDAG-LABEL: icmp_ult2:
; SDAG:       ## BB#0:
; SDAG-NEXT:    xorl %eax, %eax
; SDAG-NEXT:    retq
;
; FAST-LABEL: icmp_ult2:
; FAST:       ## BB#0:
; FAST-NEXT:    xorl %eax, %eax
; FAST-NEXT:    andb $1, %al
; FAST-NEXT:    movzbl %al, %eax
; FAST-NEXT:    retq
  %1 = icmp ult i32 %x, %x
  ret i1 %1
}

define zeroext i1 @icmp_ule2(i32 %x) {
; SDAG-LABEL: icmp_ule2:
; SDAG:       ## BB#0:
; SDAG-NEXT:    movb $1, %al
; SDAG-NEXT:    retq
;
; FAST-LABEL: icmp_ule2:
; FAST:       ## BB#0:
; FAST-NEXT:    movb $1, %al
; FAST-NEXT:    andb $1, %al
; FAST-NEXT:    movzbl %al, %eax
; FAST-NEXT:    retq
  %1 = icmp ule i32 %x, %x
  ret i1 %1
}

define zeroext i1 @icmp_sgt2(i32 %x) {
; SDAG-LABEL: icmp_sgt2:
; SDAG:       ## BB#0:
; SDAG-NEXT:    xorl %eax, %eax
; SDAG-NEXT:    retq
;
; FAST-LABEL: icmp_sgt2:
; FAST:       ## BB#0:
; FAST-NEXT:    xorl %eax, %eax
; FAST-NEXT:    andb $1, %al
; FAST-NEXT:    movzbl %al, %eax
; FAST-NEXT:    retq
  %1 = icmp sgt i32 %x, %x
  ret i1 %1
}

define zeroext i1 @icmp_sge2(i32 %x) {
; SDAG-LABEL: icmp_sge2:
; SDAG:       ## BB#0:
; SDAG-NEXT:    movb $1, %al
; SDAG-NEXT:    retq
;
; FAST-LABEL: icmp_sge2:
; FAST:       ## BB#0:
; FAST-NEXT:    movb $1, %al
; FAST-NEXT:    andb $1, %al
; FAST-NEXT:    movzbl %al, %eax
; FAST-NEXT:    retq
  %1 = icmp sge i32 %x, %x
  ret i1 %1
}

define zeroext i1 @icmp_slt2(i32 %x) {
; SDAG-LABEL: icmp_slt2:
; SDAG:       ## BB#0:
; SDAG-NEXT:    xorl %eax, %eax
; SDAG-NEXT:    retq
;
; FAST-LABEL: icmp_slt2:
; FAST:       ## BB#0:
; FAST-NEXT:    xorl %eax, %eax
; FAST-NEXT:    andb $1, %al
; FAST-NEXT:    movzbl %al, %eax
; FAST-NEXT:    retq
  %1 = icmp slt i32 %x, %x
  ret i1 %1
}

define zeroext i1 @icmp_sle2(i32 %x) {
; SDAG-LABEL: icmp_sle2:
; SDAG:       ## BB#0:
; SDAG-NEXT:    movb $1, %al
; SDAG-NEXT:    retq
;
; FAST-LABEL: icmp_sle2:
; FAST:       ## BB#0:
; FAST-NEXT:    movb $1, %al
; FAST-NEXT:    andb $1, %al
; FAST-NEXT:    movzbl %al, %eax
; FAST-NEXT:    retq
  %1 = icmp sle i32 %x, %x
  ret i1 %1
}

