//===-- is_void type_traits -------------------------------------*- C++ -*-===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//
#ifndef LLVM_LIBC_SRC___SUPPORT_CPP_TYPE_TRAITS_IS_VOID_H
#define LLVM_LIBC_SRC___SUPPORT_CPP_TYPE_TRAITS_IS_VOID_H

#include "src/__support/CPP/type_traits/is_same.h"
#include "src/__support/CPP/type_traits/remove_cv.h"
#include "src/__support/macros/attributes.h"

namespace LIBC_NAMESPACE::cpp {

// is_void
template <typename T> struct is_void : is_same<void, remove_cv_t<T>> {};
template <typename T>
LIBC_INLINE_VAR constexpr bool is_void_v = is_void<T>::value;

} // namespace LIBC_NAMESPACE::cpp

#endif // LLVM_LIBC_SRC___SUPPORT_CPP_TYPE_TRAITS_IS_VOID_H
