; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i386-apple-darwin10 -mcpu=corei7-avx -mattr=+avx | FileCheck %s

declare i32 @llvm.x86.avx.ptestz.256(<4 x i64> %p1, <4 x i64> %p2) nounwind
declare i32 @llvm.x86.avx.ptestc.256(<4 x i64> %p1, <4 x i64> %p2) nounwind

define <4 x float> @test1(<4 x i64> %a, <4 x float> %b) nounwind {
; CHECK-LABEL: test1:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    vptest %ymm0, %ymm0
; CHECK-NEXT:    jne LBB0_2
; CHECK-NEXT:  ## %bb.1: ## %bb1
; CHECK-NEXT:    vaddps LCPI0_0, %xmm1, %xmm0
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retl
; CHECK-NEXT:  LBB0_2: ## %bb2
; CHECK-NEXT:    vdivps LCPI0_0, %xmm1, %xmm0
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retl
entry:

  %res = call i32 @llvm.x86.avx.ptestz.256(<4 x i64> %a, <4 x i64> %a) nounwind
  %one = icmp ne i32 %res, 0
  br i1 %one, label %bb1, label %bb2

bb1:
  %c = fadd <4 x float> %b, < float 1.000000e+002, float 2.000000e+002, float 3.000000e+002, float 4.000000e+002 >
  br label %return

bb2:
	%d = fdiv <4 x float> %b, < float 1.000000e+002, float 2.000000e+002, float 3.000000e+002, float 4.000000e+002 >
	br label %return

return:
  %e = phi <4 x float> [%c, %bb1], [%d, %bb2]
  ret <4 x float> %e
}

define <4 x float> @test3(<4 x i64> %a, <4 x float> %b) nounwind {
; CHECK-LABEL: test3:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    vptest %ymm0, %ymm0
; CHECK-NEXT:    jne LBB1_2
; CHECK-NEXT:  ## %bb.1: ## %bb1
; CHECK-NEXT:    vaddps LCPI1_0, %xmm1, %xmm0
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retl
; CHECK-NEXT:  LBB1_2: ## %bb2
; CHECK-NEXT:    vdivps LCPI1_0, %xmm1, %xmm0
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retl
entry:

  %res = call i32 @llvm.x86.avx.ptestz.256(<4 x i64> %a, <4 x i64> %a) nounwind
  %one = trunc i32 %res to i1
  br i1 %one, label %bb1, label %bb2

bb1:
  %c = fadd <4 x float> %b, < float 1.000000e+002, float 2.000000e+002, float 3.000000e+002, float 4.000000e+002 >
  br label %return

bb2:
	%d = fdiv <4 x float> %b, < float 1.000000e+002, float 2.000000e+002, float 3.000000e+002, float 4.000000e+002 >
	br label %return

return:
  %e = phi <4 x float> [%c, %bb1], [%d, %bb2]
  ret <4 x float> %e
}

define <4 x float> @test4(<4 x i64> %a, <4 x float> %b) nounwind {
; CHECK-LABEL: test4:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    vptest %ymm0, %ymm0
; CHECK-NEXT:    jae LBB2_2
; CHECK-NEXT:  ## %bb.1: ## %bb1
; CHECK-NEXT:    vaddps LCPI2_0, %xmm1, %xmm0
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retl
; CHECK-NEXT:  LBB2_2: ## %bb2
; CHECK-NEXT:    vdivps LCPI2_0, %xmm1, %xmm0
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retl
entry:

  %res = call i32 @llvm.x86.avx.ptestc.256(<4 x i64> %a, <4 x i64> %a) nounwind
  %one = icmp ne i32 %res, 0
  br i1 %one, label %bb1, label %bb2

bb1:
  %c = fadd <4 x float> %b, < float 1.000000e+002, float 2.000000e+002, float 3.000000e+002, float 4.000000e+002 >
  br label %return

bb2:
	%d = fdiv <4 x float> %b, < float 1.000000e+002, float 2.000000e+002, float 3.000000e+002, float 4.000000e+002 >
	br label %return

return:
  %e = phi <4 x float> [%c, %bb1], [%d, %bb2]
  ret <4 x float> %e
}

define <4 x float> @test6(<4 x i64> %a, <4 x float> %b) nounwind {
; CHECK-LABEL: test6:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    vptest %ymm0, %ymm0
; CHECK-NEXT:    jae LBB3_2
; CHECK-NEXT:  ## %bb.1: ## %bb1
; CHECK-NEXT:    vaddps LCPI3_0, %xmm1, %xmm0
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retl
; CHECK-NEXT:  LBB3_2: ## %bb2
; CHECK-NEXT:    vdivps LCPI3_0, %xmm1, %xmm0
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retl
entry:

  %res = call i32 @llvm.x86.avx.ptestc.256(<4 x i64> %a, <4 x i64> %a) nounwind
  %one = trunc i32 %res to i1
  br i1 %one, label %bb1, label %bb2

bb1:
  %c = fadd <4 x float> %b, < float 1.000000e+002, float 2.000000e+002, float 3.000000e+002, float 4.000000e+002 >
  br label %return

bb2:
	%d = fdiv <4 x float> %b, < float 1.000000e+002, float 2.000000e+002, float 3.000000e+002, float 4.000000e+002 >
	br label %return

return:
  %e = phi <4 x float> [%c, %bb1], [%d, %bb2]
  ret <4 x float> %e
}

define <4 x float> @test7(<4 x i64> %a, <4 x float> %b) nounwind {
; CHECK-LABEL: test7:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    vptest %ymm0, %ymm0
; CHECK-NEXT:    jne LBB4_2
; CHECK-NEXT:  ## %bb.1: ## %bb1
; CHECK-NEXT:    vaddps LCPI4_0, %xmm1, %xmm0
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retl
; CHECK-NEXT:  LBB4_2: ## %bb2
; CHECK-NEXT:    vdivps LCPI4_0, %xmm1, %xmm0
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retl
entry:

  %res = call i32 @llvm.x86.avx.ptestz.256(<4 x i64> %a, <4 x i64> %a) nounwind
  %one = icmp eq i32 %res, 1
  br i1 %one, label %bb1, label %bb2

bb1:
  %c = fadd <4 x float> %b, < float 1.000000e+002, float 2.000000e+002, float 3.000000e+002, float 4.000000e+002 >
  br label %return

bb2:
	%d = fdiv <4 x float> %b, < float 1.000000e+002, float 2.000000e+002, float 3.000000e+002, float 4.000000e+002 >
	br label %return

return:
  %e = phi <4 x float> [%c, %bb1], [%d, %bb2]
  ret <4 x float> %e
}

define <4 x float> @test8(<4 x i64> %a, <4 x float> %b) nounwind {
; CHECK-LABEL: test8:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    vptest %ymm0, %ymm0
; CHECK-NEXT:    je LBB5_2
; CHECK-NEXT:  ## %bb.1: ## %bb1
; CHECK-NEXT:    vaddps LCPI5_0, %xmm1, %xmm0
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retl
; CHECK-NEXT:  LBB5_2: ## %bb2
; CHECK-NEXT:    vdivps LCPI5_0, %xmm1, %xmm0
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    retl
entry:

  %res = call i32 @llvm.x86.avx.ptestz.256(<4 x i64> %a, <4 x i64> %a) nounwind
  %one = icmp ne i32 %res, 1
  br i1 %one, label %bb1, label %bb2

bb1:
  %c = fadd <4 x float> %b, < float 1.000000e+002, float 2.000000e+002, float 3.000000e+002, float 4.000000e+002 >
  br label %return

bb2:
	%d = fdiv <4 x float> %b, < float 1.000000e+002, float 2.000000e+002, float 3.000000e+002, float 4.000000e+002 >
	br label %return

return:
  %e = phi <4 x float> [%c, %bb1], [%d, %bb2]
  ret <4 x float> %e
}


