; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefix=RV32I

; TODO: check the generated instructions for the equivalent of seqz, snez,
; sltz, sgtz map to something simple

define i32 @icmp_eq(i32 %a, i32 %b) nounwind {
; RV32I-LABEL: icmp_eq:
; RV32I:       # %bb.0:
; RV32I-NEXT:    xor a0, a0, a1
; RV32I-NEXT:    seqz a0, a0
; RV32I-NEXT:    ret
  %1 = icmp eq i32 %a, %b
  %2 = zext i1 %1 to i32
  ret i32 %2
}

define i32 @icmp_eq_constant(i32 %a) nounwind {
; RV32I-LABEL: icmp_eq_constant:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi a0, a0, -42
; RV32I-NEXT:    seqz a0, a0
; RV32I-NEXT:    ret
  %1 = icmp eq i32 %a, 42
  %2 = zext i1 %1 to i32
  ret i32 %2
}

define i32 @icmp_eq_constant_2048(i32 %a) nounwind {
; RV32I-LABEL: icmp_eq_constant_2048:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi a0, a0, -2048
; RV32I-NEXT:    seqz a0, a0
; RV32I-NEXT:    ret
  %1 = icmp eq i32 %a, 2048
  %2 = zext i1 %1 to i32
  ret i32 %2
}

define i32 @icmp_eq_constant_neg_2048(i32 %a) nounwind {
; RV32I-LABEL: icmp_eq_constant_neg_2048:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi a1, zero, -2048
; RV32I-NEXT:    xor a0, a0, a1
; RV32I-NEXT:    seqz a0, a0
; RV32I-NEXT:    ret
  %1 = icmp eq i32 %a, -2048
  %2 = zext i1 %1 to i32
  ret i32 %2
}

define i32 @icmp_eq_constant_neg_2047(i32 %a) nounwind {
; RV32I-LABEL: icmp_eq_constant_neg_2047:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi a0, a0, 2047
; RV32I-NEXT:    seqz a0, a0
; RV32I-NEXT:    ret
  %1 = icmp eq i32 %a, -2047
  %2 = zext i1 %1 to i32
  ret i32 %2
}

define i32 @icmp_eqz(i32 %a) nounwind {
; RV32I-LABEL: icmp_eqz:
; RV32I:       # %bb.0:
; RV32I-NEXT:    seqz a0, a0
; RV32I-NEXT:    ret
  %1 = icmp eq i32 %a, 0
  %2 = zext i1 %1 to i32
  ret i32 %2
}

define i32 @icmp_ne(i32 %a, i32 %b) nounwind {
; RV32I-LABEL: icmp_ne:
; RV32I:       # %bb.0:
; RV32I-NEXT:    xor a0, a0, a1
; RV32I-NEXT:    snez a0, a0
; RV32I-NEXT:    ret
  %1 = icmp ne i32 %a, %b
  %2 = zext i1 %1 to i32
  ret i32 %2
}

define i32 @icmp_ne_constant(i32 %a) nounwind {
; RV32I-LABEL: icmp_ne_constant:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi a0, a0, -42
; RV32I-NEXT:    snez a0, a0
; RV32I-NEXT:    ret
  %1 = icmp ne i32 %a, 42
  %2 = zext i1 %1 to i32
  ret i32 %2
}

define i32 @icmp_ne_constant_2048(i32 %a) nounwind {
; RV32I-LABEL: icmp_ne_constant_2048:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi a0, a0, -2048
; RV32I-NEXT:    snez a0, a0
; RV32I-NEXT:    ret
  %1 = icmp ne i32 %a, 2048
  %2 = zext i1 %1 to i32
  ret i32 %2
}

define i32 @icmp_ne_constant_neg_2048(i32 %a) nounwind {
; RV32I-LABEL: icmp_ne_constant_neg_2048:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi a1, zero, -2048
; RV32I-NEXT:    xor a0, a0, a1
; RV32I-NEXT:    snez a0, a0
; RV32I-NEXT:    ret
  %1 = icmp ne i32 %a, -2048
  %2 = zext i1 %1 to i32
  ret i32 %2
}

define i32 @icmp_nez(i32 %a) nounwind {
; RV32I-LABEL: icmp_nez:
; RV32I:       # %bb.0:
; RV32I-NEXT:    snez a0, a0
; RV32I-NEXT:    ret
  %1 = icmp ne i32 %a, 0
  %2 = zext i1 %1 to i32
  ret i32 %2
}

define i32 @icmp_ugt(i32 %a, i32 %b) nounwind {
; RV32I-LABEL: icmp_ugt:
; RV32I:       # %bb.0:
; RV32I-NEXT:    sltu a0, a1, a0
; RV32I-NEXT:    ret
  %1 = icmp ugt i32 %a, %b
  %2 = zext i1 %1 to i32
  ret i32 %2
}

define i32 @icmp_uge(i32 %a, i32 %b) nounwind {
; RV32I-LABEL: icmp_uge:
; RV32I:       # %bb.0:
; RV32I-NEXT:    sltu a0, a0, a1
; RV32I-NEXT:    xori a0, a0, 1
; RV32I-NEXT:    ret
  %1 = icmp uge i32 %a, %b
  %2 = zext i1 %1 to i32
  ret i32 %2
}

define i32 @icmp_ult(i32 %a, i32 %b) nounwind {
; RV32I-LABEL: icmp_ult:
; RV32I:       # %bb.0:
; RV32I-NEXT:    sltu a0, a0, a1
; RV32I-NEXT:    ret
  %1 = icmp ult i32 %a, %b
  %2 = zext i1 %1 to i32
  ret i32 %2
}

define i32 @icmp_ule(i32 %a, i32 %b) nounwind {
; RV32I-LABEL: icmp_ule:
; RV32I:       # %bb.0:
; RV32I-NEXT:    sltu a0, a1, a0
; RV32I-NEXT:    xori a0, a0, 1
; RV32I-NEXT:    ret
  %1 = icmp ule i32 %a, %b
  %2 = zext i1 %1 to i32
  ret i32 %2
}

define i32 @icmp_sgt(i32 %a, i32 %b) nounwind {
; RV32I-LABEL: icmp_sgt:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slt a0, a1, a0
; RV32I-NEXT:    ret
  %1 = icmp sgt i32 %a, %b
  %2 = zext i1 %1 to i32
  ret i32 %2
}

define i32 @icmp_sge(i32 %a, i32 %b) nounwind {
; RV32I-LABEL: icmp_sge:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slt a0, a0, a1
; RV32I-NEXT:    xori a0, a0, 1
; RV32I-NEXT:    ret
  %1 = icmp sge i32 %a, %b
  %2 = zext i1 %1 to i32
  ret i32 %2
}

define i32 @icmp_slt(i32 %a, i32 %b) nounwind {
; RV32I-LABEL: icmp_slt:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slt a0, a0, a1
; RV32I-NEXT:    ret
  %1 = icmp slt i32 %a, %b
  %2 = zext i1 %1 to i32
  ret i32 %2
}

define i32 @icmp_sle(i32 %a, i32 %b) nounwind {
; RV32I-LABEL: icmp_sle:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slt a0, a1, a0
; RV32I-NEXT:    xori a0, a0, 1
; RV32I-NEXT:    ret
  %1 = icmp sle i32 %a, %b
  %2 = zext i1 %1 to i32
  ret i32 %2
}

; TODO: check variants with an immediate?
