#ifndef STATIC_HEADER_H
#define STATIC_HEADER_H

#include "igzip_lib.h"

#define LONG_BITS_CHECK 12
#define SHORT_BITS_CHECK 10
#if (LONG_BITS_CHECK == ISAL_DECODE_LONG_BITS) && (SHORT_BITS_CHECK == ISAL_DECODE_SHORT_BITS)
# define ISAL_STATIC_INFLATE_TABLE
#else
# warning "Incompatible compile time defines for optimized static inflate table."
#endif

struct inflate_huff_code_large static_lit_huff_code = {
	.short_code_lookup = {
		0x74000100, 0x84000050, 0x84000010, 0xc4000171,
		0x9400011d, 0x84000070, 0x84000030, 0x940000c0,
		0x74000108, 0x84000060, 0x84000020, 0x940000a0,
		0x84000000, 0x84000080, 0x84000040, 0x940000e0,
		0x74000104, 0x84000058, 0x84000018, 0x94000090,
		0xa4000139, 0x84000078, 0x84000038, 0x940000d0,
		0x8400010f, 0x84000068, 0x84000028, 0x940000b0,
		0x84000008, 0x84000088, 0x84000048, 0x940000f0,
		0x74000102, 0x84000054, 0x84000014, 0x36000060,
		0xa4000129, 0x84000074, 0x84000034, 0x940000c8,
		0x8400010b, 0x84000064, 0x84000024, 0x940000a8,
		0x84000004, 0x84000084, 0x84000044, 0x940000e8,
		0x74000106, 0x8400005c, 0x8400001c, 0x94000098,
		0xb4000151, 0x8400007c, 0x8400003c, 0x940000d8,
		0x94000115, 0x8400006c, 0x8400002c, 0x940000b8,
		0x8400000c, 0x8400008c, 0x8400004c, 0x940000f8,
		0x74000101, 0x84000052, 0x84000012, 0x36000020,
		0xa4000121, 0x84000072, 0x84000032, 0x940000c4,
		0x84000109, 0x84000062, 0x84000022, 0x940000a4,
		0x84000002, 0x84000082, 0x84000042, 0x940000e4,
		0x74000105, 0x8400005a, 0x8400001a, 0x94000094,
		0xb4000141, 0x8400007a, 0x8400003a, 0x940000d4,
		0x94000111, 0x8400006a, 0x8400002a, 0x940000b4,
		0x8400000a, 0x8400008a, 0x8400004a, 0x940000f4,
		0x74000103, 0x84000056, 0x84000016, 0x00000000,
		0xa4000131, 0x84000076, 0x84000036, 0x940000cc,
		0x8400010d, 0x84000066, 0x84000026, 0x940000ac,
		0x84000006, 0x84000086, 0x84000046, 0x940000ec,
		0x74000107, 0x8400005e, 0x8400001e, 0x9400009c,
		0xb4000161, 0x8400007e, 0x8400003e, 0x940000dc,
		0x94000119, 0x8400006e, 0x8400002e, 0x940000bc,
		0x8400000e, 0x8400008e, 0x8400004e, 0x940000fc,
		0x74000100, 0x84000051, 0x84000011, 0x36000000,
		0x9400011e, 0x84000071, 0x84000031, 0x940000c2,
		0x74000108, 0x84000061, 0x84000021, 0x940000a2,
		0x84000001, 0x84000081, 0x84000041, 0x940000e2,
		0x74000104, 0x84000059, 0x84000019, 0x94000092,
		0xa400013a, 0x84000079, 0x84000039, 0x940000d2,
		0x84000110, 0x84000069, 0x84000029, 0x940000b2,
		0x84000009, 0x84000089, 0x84000049, 0x940000f2,
		0x74000102, 0x84000055, 0x84000015, 0x84000200,
		0xa400012a, 0x84000075, 0x84000035, 0x940000ca,
		0x8400010c, 0x84000065, 0x84000025, 0x940000aa,
		0x84000005, 0x84000085, 0x84000045, 0x940000ea,
		0x74000106, 0x8400005d, 0x8400001d, 0x9400009a,
		0xb4000152, 0x8400007d, 0x8400003d, 0x940000da,
		0x94000116, 0x8400006d, 0x8400002d, 0x940000ba,
		0x8400000d, 0x8400008d, 0x8400004d, 0x940000fa,
		0x74000101, 0x84000053, 0x84000013, 0x36000040,
		0xa4000122, 0x84000073, 0x84000033, 0x940000c6,
		0x8400010a, 0x84000063, 0x84000023, 0x940000a6,
		0x84000003, 0x84000083, 0x84000043, 0x940000e6,
		0x74000105, 0x8400005b, 0x8400001b, 0x94000096,
		0xb4000142, 0x8400007b, 0x8400003b, 0x940000d6,
		0x94000112, 0x8400006b, 0x8400002b, 0x940000b6,
		0x8400000b, 0x8400008b, 0x8400004b, 0x940000f6,
		0x74000103, 0x84000057, 0x84000017, 0x00000000,
		0xa4000132, 0x84000077, 0x84000037, 0x940000ce,
		0x8400010e, 0x84000067, 0x84000027, 0x940000ae,
		0x84000007, 0x84000087, 0x84000047, 0x940000ee,
		0x74000107, 0x8400005f, 0x8400001f, 0x9400009e,
		0xb4000162, 0x8400007f, 0x8400003f, 0x940000de,
		0x9400011a, 0x8400006f, 0x8400002f, 0x940000be,
		0x8400000f, 0x8400008f, 0x8400004f, 0x940000fe,
		0x74000100, 0x84000050, 0x84000010, 0xc4000172,
		0x9400011f, 0x84000070, 0x84000030, 0x940000c1,
		0x74000108, 0x84000060, 0x84000020, 0x940000a1,
		0x84000000, 0x84000080, 0x84000040, 0x940000e1,
		0x74000104, 0x84000058, 0x84000018, 0x94000091,
		0xa400013b, 0x84000078, 0x84000038, 0x940000d1,
		0x8400010f, 0x84000068, 0x84000028, 0x940000b1,
		0x84000008, 0x84000088, 0x84000048, 0x940000f1,
		0x74000102, 0x84000054, 0x84000014, 0x36000062,
		0xa400012b, 0x84000074, 0x84000034, 0x940000c9,
		0x8400010b, 0x84000064, 0x84000024, 0x940000a9,
		0x84000004, 0x84000084, 0x84000044, 0x940000e9,
		0x74000106, 0x8400005c, 0x8400001c, 0x94000099,
		0xb4000153, 0x8400007c, 0x8400003c, 0x940000d9,
		0x94000117, 0x8400006c, 0x8400002c, 0x940000b9,
		0x8400000c, 0x8400008c, 0x8400004c, 0x940000f9,
		0x74000101, 0x84000052, 0x84000012, 0x36000022,
		0xa4000123, 0x84000072, 0x84000032, 0x940000c5,
		0x84000109, 0x84000062, 0x84000022, 0x940000a5,
		0x84000002, 0x84000082, 0x84000042, 0x940000e5,
		0x74000105, 0x8400005a, 0x8400001a, 0x94000095,
		0xb4000143, 0x8400007a, 0x8400003a, 0x940000d5,
		0x94000113, 0x8400006a, 0x8400002a, 0x940000b5,
		0x8400000a, 0x8400008a, 0x8400004a, 0x940000f5,
		0x74000103, 0x84000056, 0x84000016, 0x00000000,
		0xa4000133, 0x84000076, 0x84000036, 0x940000cd,
		0x8400010d, 0x84000066, 0x84000026, 0x940000ad,
		0x84000006, 0x84000086, 0x84000046, 0x940000ed,
		0x74000107, 0x8400005e, 0x8400001e, 0x9400009d,
		0xb4000163, 0x8400007e, 0x8400003e, 0x940000dd,
		0x9400011b, 0x8400006e, 0x8400002e, 0x940000bd,
		0x8400000e, 0x8400008e, 0x8400004e, 0x940000fd,
		0x74000100, 0x84000051, 0x84000011, 0x36000002,
		0x94000120, 0x84000071, 0x84000031, 0x940000c3,
		0x74000108, 0x84000061, 0x84000021, 0x940000a3,
		0x84000001, 0x84000081, 0x84000041, 0x940000e3,
		0x74000104, 0x84000059, 0x84000019, 0x94000093,
		0xa400013c, 0x84000079, 0x84000039, 0x940000d3,
		0x84000110, 0x84000069, 0x84000029, 0x940000b3,
		0x84000009, 0x84000089, 0x84000049, 0x940000f3,
		0x74000102, 0x84000055, 0x84000015, 0x84000200,
		0xa400012c, 0x84000075, 0x84000035, 0x940000cb,
		0x8400010c, 0x84000065, 0x84000025, 0x940000ab,
		0x84000005, 0x84000085, 0x84000045, 0x940000eb,
		0x74000106, 0x8400005d, 0x8400001d, 0x9400009b,
		0xb4000154, 0x8400007d, 0x8400003d, 0x940000db,
		0x94000118, 0x8400006d, 0x8400002d, 0x940000bb,
		0x8400000d, 0x8400008d, 0x8400004d, 0x940000fb,
		0x74000101, 0x84000053, 0x84000013, 0x36000042,
		0xa4000124, 0x84000073, 0x84000033, 0x940000c7,
		0x8400010a, 0x84000063, 0x84000023, 0x940000a7,
		0x84000003, 0x84000083, 0x84000043, 0x940000e7,
		0x74000105, 0x8400005b, 0x8400001b, 0x94000097,
		0xb4000144, 0x8400007b, 0x8400003b, 0x940000d7,
		0x94000114, 0x8400006b, 0x8400002b, 0x940000b7,
		0x8400000b, 0x8400008b, 0x8400004b, 0x940000f7,
		0x74000103, 0x84000057, 0x84000017, 0x00000000,
		0xa4000134, 0x84000077, 0x84000037, 0x940000cf,
		0x8400010e, 0x84000067, 0x84000027, 0x940000af,
		0x84000007, 0x84000087, 0x84000047, 0x940000ef,
		0x74000107, 0x8400005f, 0x8400001f, 0x9400009f,
		0xb4000164, 0x8400007f, 0x8400003f, 0x940000df,
		0x9400011c, 0x8400006f, 0x8400002f, 0x940000bf,
		0x8400000f, 0x8400008f, 0x8400004f, 0x940000ff,
		0x74000100, 0x84000050, 0x84000010, 0xc4000173,
		0x9400011d, 0x84000070, 0x84000030, 0x940000c0,
		0x74000108, 0x84000060, 0x84000020, 0x940000a0,
		0x84000000, 0x84000080, 0x84000040, 0x940000e0,
		0x74000104, 0x84000058, 0x84000018, 0x94000090,
		0xa400013d, 0x84000078, 0x84000038, 0x940000d0,
		0x8400010f, 0x84000068, 0x84000028, 0x940000b0,
		0x84000008, 0x84000088, 0x84000048, 0x940000f0,
		0x74000102, 0x84000054, 0x84000014, 0x36000064,
		0xa400012d, 0x84000074, 0x84000034, 0x940000c8,
		0x8400010b, 0x84000064, 0x84000024, 0x940000a8,
		0x84000004, 0x84000084, 0x84000044, 0x940000e8,
		0x74000106, 0x8400005c, 0x8400001c, 0x94000098,
		0xb4000155, 0x8400007c, 0x8400003c, 0x940000d8,
		0x94000115, 0x8400006c, 0x8400002c, 0x940000b8,
		0x8400000c, 0x8400008c, 0x8400004c, 0x940000f8,
		0x74000101, 0x84000052, 0x84000012, 0x36000024,
		0xa4000125, 0x84000072, 0x84000032, 0x940000c4,
		0x84000109, 0x84000062, 0x84000022, 0x940000a4,
		0x84000002, 0x84000082, 0x84000042, 0x940000e4,
		0x74000105, 0x8400005a, 0x8400001a, 0x94000094,
		0xb4000145, 0x8400007a, 0x8400003a, 0x940000d4,
		0x94000111, 0x8400006a, 0x8400002a, 0x940000b4,
		0x8400000a, 0x8400008a, 0x8400004a, 0x940000f4,
		0x74000103, 0x84000056, 0x84000016, 0x00000000,
		0xa4000135, 0x84000076, 0x84000036, 0x940000cc,
		0x8400010d, 0x84000066, 0x84000026, 0x940000ac,
		0x84000006, 0x84000086, 0x84000046, 0x940000ec,
		0x74000107, 0x8400005e, 0x8400001e, 0x9400009c,
		0xb4000165, 0x8400007e, 0x8400003e, 0x940000dc,
		0x94000119, 0x8400006e, 0x8400002e, 0x940000bc,
		0x8400000e, 0x8400008e, 0x8400004e, 0x940000fc,
		0x74000100, 0x84000051, 0x84000011, 0x36000004,
		0x9400011e, 0x84000071, 0x84000031, 0x940000c2,
		0x74000108, 0x84000061, 0x84000021, 0x940000a2,
		0x84000001, 0x84000081, 0x84000041, 0x940000e2,
		0x74000104, 0x84000059, 0x84000019, 0x94000092,
		0xa400013e, 0x84000079, 0x84000039, 0x940000d2,
		0x84000110, 0x84000069, 0x84000029, 0x940000b2,
		0x84000009, 0x84000089, 0x84000049, 0x940000f2,
		0x74000102, 0x84000055, 0x84000015, 0x84000200,
		0xa400012e, 0x84000075, 0x84000035, 0x940000ca,
		0x8400010c, 0x84000065, 0x84000025, 0x940000aa,
		0x84000005, 0x84000085, 0x84000045, 0x940000ea,
		0x74000106, 0x8400005d, 0x8400001d, 0x9400009a,
		0xb4000156, 0x8400007d, 0x8400003d, 0x940000da,
		0x94000116, 0x8400006d, 0x8400002d, 0x940000ba,
		0x8400000d, 0x8400008d, 0x8400004d, 0x940000fa,
		0x74000101, 0x84000053, 0x84000013, 0x36000044,
		0xa4000126, 0x84000073, 0x84000033, 0x940000c6,
		0x8400010a, 0x84000063, 0x84000023, 0x940000a6,
		0x84000003, 0x84000083, 0x84000043, 0x940000e6,
		0x74000105, 0x8400005b, 0x8400001b, 0x94000096,
		0xb4000146, 0x8400007b, 0x8400003b, 0x940000d6,
		0x94000112, 0x8400006b, 0x8400002b, 0x940000b6,
		0x8400000b, 0x8400008b, 0x8400004b, 0x940000f6,
		0x74000103, 0x84000057, 0x84000017, 0x00000000,
		0xa4000136, 0x84000077, 0x84000037, 0x940000ce,
		0x8400010e, 0x84000067, 0x84000027, 0x940000ae,
		0x84000007, 0x84000087, 0x84000047, 0x940000ee,
		0x74000107, 0x8400005f, 0x8400001f, 0x9400009e,
		0xb4000166, 0x8400007f, 0x8400003f, 0x940000de,
		0x9400011a, 0x8400006f, 0x8400002f, 0x940000be,
		0x8400000f, 0x8400008f, 0x8400004f, 0x940000fe,
		0x74000100, 0x84000050, 0x84000010, 0xc4000174,
		0x9400011f, 0x84000070, 0x84000030, 0x940000c1,
		0x74000108, 0x84000060, 0x84000020, 0x940000a1,
		0x84000000, 0x84000080, 0x84000040, 0x940000e1,
		0x74000104, 0x84000058, 0x84000018, 0x94000091,
		0xa400013f, 0x84000078, 0x84000038, 0x940000d1,
		0x8400010f, 0x84000068, 0x84000028, 0x940000b1,
		0x84000008, 0x84000088, 0x84000048, 0x940000f1,
		0x74000102, 0x84000054, 0x84000014, 0x36000066,
		0xa400012f, 0x84000074, 0x84000034, 0x940000c9,
		0x8400010b, 0x84000064, 0x84000024, 0x940000a9,
		0x84000004, 0x84000084, 0x84000044, 0x940000e9,
		0x74000106, 0x8400005c, 0x8400001c, 0x94000099,
		0xb4000157, 0x8400007c, 0x8400003c, 0x940000d9,
		0x94000117, 0x8400006c, 0x8400002c, 0x940000b9,
		0x8400000c, 0x8400008c, 0x8400004c, 0x940000f9,
		0x74000101, 0x84000052, 0x84000012, 0x36000026,
		0xa4000127, 0x84000072, 0x84000032, 0x940000c5,
		0x84000109, 0x84000062, 0x84000022, 0x940000a5,
		0x84000002, 0x84000082, 0x84000042, 0x940000e5,
		0x74000105, 0x8400005a, 0x8400001a, 0x94000095,
		0xb4000147, 0x8400007a, 0x8400003a, 0x940000d5,
		0x94000113, 0x8400006a, 0x8400002a, 0x940000b5,
		0x8400000a, 0x8400008a, 0x8400004a, 0x940000f5,
		0x74000103, 0x84000056, 0x84000016, 0x00000000,
		0xa4000137, 0x84000076, 0x84000036, 0x940000cd,
		0x8400010d, 0x84000066, 0x84000026, 0x940000ad,
		0x84000006, 0x84000086, 0x84000046, 0x940000ed,
		0x74000107, 0x8400005e, 0x8400001e, 0x9400009d,
		0xb4000167, 0x8400007e, 0x8400003e, 0x940000dd,
		0x9400011b, 0x8400006e, 0x8400002e, 0x940000bd,
		0x8400000e, 0x8400008e, 0x8400004e, 0x940000fd,
		0x74000100, 0x84000051, 0x84000011, 0x36000006,
		0x94000120, 0x84000071, 0x84000031, 0x940000c3,
		0x74000108, 0x84000061, 0x84000021, 0x940000a3,
		0x84000001, 0x84000081, 0x84000041, 0x940000e3,
		0x74000104, 0x84000059, 0x84000019, 0x94000093,
		0xa4000140, 0x84000079, 0x84000039, 0x940000d3,
		0x84000110, 0x84000069, 0x84000029, 0x940000b3,
		0x84000009, 0x84000089, 0x84000049, 0x940000f3,
		0x74000102, 0x84000055, 0x84000015, 0x84000200,
		0xa4000130, 0x84000075, 0x84000035, 0x940000cb,
		0x8400010c, 0x84000065, 0x84000025, 0x940000ab,
		0x84000005, 0x84000085, 0x84000045, 0x940000eb,
		0x74000106, 0x8400005d, 0x8400001d, 0x9400009b,
		0xb4000158, 0x8400007d, 0x8400003d, 0x940000db,
		0x94000118, 0x8400006d, 0x8400002d, 0x940000bb,
		0x8400000d, 0x8400008d, 0x8400004d, 0x940000fb,
		0x74000101, 0x84000053, 0x84000013, 0x36000046,
		0xa4000128, 0x84000073, 0x84000033, 0x940000c7,
		0x8400010a, 0x84000063, 0x84000023, 0x940000a7,
		0x84000003, 0x84000083, 0x84000043, 0x940000e7,
		0x74000105, 0x8400005b, 0x8400001b, 0x94000097,
		0xb4000148, 0x8400007b, 0x8400003b, 0x940000d7,
		0x94000114, 0x8400006b, 0x8400002b, 0x940000b7,
		0x8400000b, 0x8400008b, 0x8400004b, 0x940000f7,
		0x74000103, 0x84000057, 0x84000017, 0x00000000,
		0xa4000138, 0x84000077, 0x84000037, 0x940000cf,
		0x8400010e, 0x84000067, 0x84000027, 0x940000af,
		0x84000007, 0x84000087, 0x84000047, 0x940000ef,
		0x74000107, 0x8400005f, 0x8400001f, 0x9400009f,
		0xb4000168, 0x8400007f, 0x8400003f, 0x940000df,
		0x9400011c, 0x8400006f, 0x8400002f, 0x940000bf,
		0x8400000f, 0x8400008f, 0x8400004f, 0x940000ff,
		0x74000100, 0x84000050, 0x84000010, 0xc4000175,
		0x9400011d, 0x84000070, 0x84000030, 0x940000c0,
		0x74000108, 0x84000060, 0x84000020, 0x940000a0,
		0x84000000, 0x84000080, 0x84000040, 0x940000e0,
		0x74000104, 0x84000058, 0x84000018, 0x94000090,
		0xa4000139, 0x84000078, 0x84000038, 0x940000d0,
		0x8400010f, 0x84000068, 0x84000028, 0x940000b0,
		0x84000008, 0x84000088, 0x84000048, 0x940000f0,
		0x74000102, 0x84000054, 0x84000014, 0x36000068,
		0xa4000129, 0x84000074, 0x84000034, 0x940000c8,
		0x8400010b, 0x84000064, 0x84000024, 0x940000a8,
		0x84000004, 0x84000084, 0x84000044, 0x940000e8,
		0x74000106, 0x8400005c, 0x8400001c, 0x94000098,
		0xb4000159, 0x8400007c, 0x8400003c, 0x940000d8,
		0x94000115, 0x8400006c, 0x8400002c, 0x940000b8,
		0x8400000c, 0x8400008c, 0x8400004c, 0x940000f8,
		0x74000101, 0x84000052, 0x84000012, 0x36000028,
		0xa4000121, 0x84000072, 0x84000032, 0x940000c4,
		0x84000109, 0x84000062, 0x84000022, 0x940000a4,
		0x84000002, 0x84000082, 0x84000042, 0x940000e4,
		0x74000105, 0x8400005a, 0x8400001a, 0x94000094,
		0xb4000149, 0x8400007a, 0x8400003a, 0x940000d4,
		0x94000111, 0x8400006a, 0x8400002a, 0x940000b4,
		0x8400000a, 0x8400008a, 0x8400004a, 0x940000f4,
		0x74000103, 0x84000056, 0x84000016, 0x00000000,
		0xa4000131, 0x84000076, 0x84000036, 0x940000cc,
		0x8400010d, 0x84000066, 0x84000026, 0x940000ac,
		0x84000006, 0x84000086, 0x84000046, 0x940000ec,
		0x74000107, 0x8400005e, 0x8400001e, 0x9400009c,
		0xb4000169, 0x8400007e, 0x8400003e, 0x940000dc,
		0x94000119, 0x8400006e, 0x8400002e, 0x940000bc,
		0x8400000e, 0x8400008e, 0x8400004e, 0x940000fc,
		0x74000100, 0x84000051, 0x84000011, 0x36000008,
		0x9400011e, 0x84000071, 0x84000031, 0x940000c2,
		0x74000108, 0x84000061, 0x84000021, 0x940000a2,
		0x84000001, 0x84000081, 0x84000041, 0x940000e2,
		0x74000104, 0x84000059, 0x84000019, 0x94000092,
		0xa400013a, 0x84000079, 0x84000039, 0x940000d2,
		0x84000110, 0x84000069, 0x84000029, 0x940000b2,
		0x84000009, 0x84000089, 0x84000049, 0x940000f2,
		0x74000102, 0x84000055, 0x84000015, 0x84000200,
		0xa400012a, 0x84000075, 0x84000035, 0x940000ca,
		0x8400010c, 0x84000065, 0x84000025, 0x940000aa,
		0x84000005, 0x84000085, 0x84000045, 0x940000ea,
		0x74000106, 0x8400005d, 0x8400001d, 0x9400009a,
		0xb400015a, 0x8400007d, 0x8400003d, 0x940000da,
		0x94000116, 0x8400006d, 0x8400002d, 0x940000ba,
		0x8400000d, 0x8400008d, 0x8400004d, 0x940000fa,
		0x74000101, 0x84000053, 0x84000013, 0x36000048,
		0xa4000122, 0x84000073, 0x84000033, 0x940000c6,
		0x8400010a, 0x84000063, 0x84000023, 0x940000a6,
		0x84000003, 0x84000083, 0x84000043, 0x940000e6,
		0x74000105, 0x8400005b, 0x8400001b, 0x94000096,
		0xb400014a, 0x8400007b, 0x8400003b, 0x940000d6,
		0x94000112, 0x8400006b, 0x8400002b, 0x940000b6,
		0x8400000b, 0x8400008b, 0x8400004b, 0x940000f6,
		0x74000103, 0x84000057, 0x84000017, 0x00000000,
		0xa4000132, 0x84000077, 0x84000037, 0x940000ce,
		0x8400010e, 0x84000067, 0x84000027, 0x940000ae,
		0x84000007, 0x84000087, 0x84000047, 0x940000ee,
		0x74000107, 0x8400005f, 0x8400001f, 0x9400009e,
		0xb400016a, 0x8400007f, 0x8400003f, 0x940000de,
		0x9400011a, 0x8400006f, 0x8400002f, 0x940000be,
		0x8400000f, 0x8400008f, 0x8400004f, 0x940000fe,
		0x74000100, 0x84000050, 0x84000010, 0xc4000176,
		0x9400011f, 0x84000070, 0x84000030, 0x940000c1,
		0x74000108, 0x84000060, 0x84000020, 0x940000a1,
		0x84000000, 0x84000080, 0x84000040, 0x940000e1,
		0x74000104, 0x84000058, 0x84000018, 0x94000091,
		0xa400013b, 0x84000078, 0x84000038, 0x940000d1,
		0x8400010f, 0x84000068, 0x84000028, 0x940000b1,
		0x84000008, 0x84000088, 0x84000048, 0x940000f1,
		0x74000102, 0x84000054, 0x84000014, 0x3600006a,
		0xa400012b, 0x84000074, 0x84000034, 0x940000c9,
		0x8400010b, 0x84000064, 0x84000024, 0x940000a9,
		0x84000004, 0x84000084, 0x84000044, 0x940000e9,
		0x74000106, 0x8400005c, 0x8400001c, 0x94000099,
		0xb400015b, 0x8400007c, 0x8400003c, 0x940000d9,
		0x94000117, 0x8400006c, 0x8400002c, 0x940000b9,
		0x8400000c, 0x8400008c, 0x8400004c, 0x940000f9,
		0x74000101, 0x84000052, 0x84000012, 0x3600002a,
		0xa4000123, 0x84000072, 0x84000032, 0x940000c5,
		0x84000109, 0x84000062, 0x84000022, 0x940000a5,
		0x84000002, 0x84000082, 0x84000042, 0x940000e5,
		0x74000105, 0x8400005a, 0x8400001a, 0x94000095,
		0xb400014b, 0x8400007a, 0x8400003a, 0x940000d5,
		0x94000113, 0x8400006a, 0x8400002a, 0x940000b5,
		0x8400000a, 0x8400008a, 0x8400004a, 0x940000f5,
		0x74000103, 0x84000056, 0x84000016, 0x00000000,
		0xa4000133, 0x84000076, 0x84000036, 0x940000cd,
		0x8400010d, 0x84000066, 0x84000026, 0x940000ad,
		0x84000006, 0x84000086, 0x84000046, 0x940000ed,
		0x74000107, 0x8400005e, 0x8400001e, 0x9400009d,
		0xb400016b, 0x8400007e, 0x8400003e, 0x940000dd,
		0x9400011b, 0x8400006e, 0x8400002e, 0x940000bd,
		0x8400000e, 0x8400008e, 0x8400004e, 0x940000fd,
		0x74000100, 0x84000051, 0x84000011, 0x3600000a,
		0x94000120, 0x84000071, 0x84000031, 0x940000c3,
		0x74000108, 0x84000061, 0x84000021, 0x940000a3,
		0x84000001, 0x84000081, 0x84000041, 0x940000e3,
		0x74000104, 0x84000059, 0x84000019, 0x94000093,
		0xa400013c, 0x84000079, 0x84000039, 0x940000d3,
		0x84000110, 0x84000069, 0x84000029, 0x940000b3,
		0x84000009, 0x84000089, 0x84000049, 0x940000f3,
		0x74000102, 0x84000055, 0x84000015, 0x84000200,
		0xa400012c, 0x84000075, 0x84000035, 0x940000cb,
		0x8400010c, 0x84000065, 0x84000025, 0x940000ab,
		0x84000005, 0x84000085, 0x84000045, 0x940000eb,
		0x74000106, 0x8400005d, 0x8400001d, 0x9400009b,
		0xb400015c, 0x8400007d, 0x8400003d, 0x940000db,
		0x94000118, 0x8400006d, 0x8400002d, 0x940000bb,
		0x8400000d, 0x8400008d, 0x8400004d, 0x940000fb,
		0x74000101, 0x84000053, 0x84000013, 0x3600004a,
		0xa4000124, 0x84000073, 0x84000033, 0x940000c7,
		0x8400010a, 0x84000063, 0x84000023, 0x940000a7,
		0x84000003, 0x84000083, 0x84000043, 0x940000e7,
		0x74000105, 0x8400005b, 0x8400001b, 0x94000097,
		0xb400014c, 0x8400007b, 0x8400003b, 0x940000d7,
		0x94000114, 0x8400006b, 0x8400002b, 0x940000b7,
		0x8400000b, 0x8400008b, 0x8400004b, 0x940000f7,
		0x74000103, 0x84000057, 0x84000017, 0x00000000,
		0xa4000134, 0x84000077, 0x84000037, 0x940000cf,
		0x8400010e, 0x84000067, 0x84000027, 0x940000af,
		0x84000007, 0x84000087, 0x84000047, 0x940000ef,
		0x74000107, 0x8400005f, 0x8400001f, 0x9400009f,
		0xb400016c, 0x8400007f, 0x8400003f, 0x940000df,
		0x9400011c, 0x8400006f, 0x8400002f, 0x940000bf,
		0x8400000f, 0x8400008f, 0x8400004f, 0x940000ff,
		0x74000100, 0x84000050, 0x84000010, 0xc4000177,
		0x9400011d, 0x84000070, 0x84000030, 0x940000c0,
		0x74000108, 0x84000060, 0x84000020, 0x940000a0,
		0x84000000, 0x84000080, 0x84000040, 0x940000e0,
		0x74000104, 0x84000058, 0x84000018, 0x94000090,
		0xa400013d, 0x84000078, 0x84000038, 0x940000d0,
		0x8400010f, 0x84000068, 0x84000028, 0x940000b0,
		0x84000008, 0x84000088, 0x84000048, 0x940000f0,
		0x74000102, 0x84000054, 0x84000014, 0x3600006c,
		0xa400012d, 0x84000074, 0x84000034, 0x940000c8,
		0x8400010b, 0x84000064, 0x84000024, 0x940000a8,
		0x84000004, 0x84000084, 0x84000044, 0x940000e8,
		0x74000106, 0x8400005c, 0x8400001c, 0x94000098,
		0xb400015d, 0x8400007c, 0x8400003c, 0x940000d8,
		0x94000115, 0x8400006c, 0x8400002c, 0x940000b8,
		0x8400000c, 0x8400008c, 0x8400004c, 0x940000f8,
		0x74000101, 0x84000052, 0x84000012, 0x3600002c,
		0xa4000125, 0x84000072, 0x84000032, 0x940000c4,
		0x84000109, 0x84000062, 0x84000022, 0x940000a4,
		0x84000002, 0x84000082, 0x84000042, 0x940000e4,
		0x74000105, 0x8400005a, 0x8400001a, 0x94000094,
		0xb400014d, 0x8400007a, 0x8400003a, 0x940000d4,
		0x94000111, 0x8400006a, 0x8400002a, 0x940000b4,
		0x8400000a, 0x8400008a, 0x8400004a, 0x940000f4,
		0x74000103, 0x84000056, 0x84000016, 0x00000000,
		0xa4000135, 0x84000076, 0x84000036, 0x940000cc,
		0x8400010d, 0x84000066, 0x84000026, 0x940000ac,
		0x84000006, 0x84000086, 0x84000046, 0x940000ec,
		0x74000107, 0x8400005e, 0x8400001e, 0x9400009c,
		0xb400016d, 0x8400007e, 0x8400003e, 0x940000dc,
		0x94000119, 0x8400006e, 0x8400002e, 0x940000bc,
		0x8400000e, 0x8400008e, 0x8400004e, 0x940000fc,
		0x74000100, 0x84000051, 0x84000011, 0x3600000c,
		0x9400011e, 0x84000071, 0x84000031, 0x940000c2,
		0x74000108, 0x84000061, 0x84000021, 0x940000a2,
		0x84000001, 0x84000081, 0x84000041, 0x940000e2,
		0x74000104, 0x84000059, 0x84000019, 0x94000092,
		0xa400013e, 0x84000079, 0x84000039, 0x940000d2,
		0x84000110, 0x84000069, 0x84000029, 0x940000b2,
		0x84000009, 0x84000089, 0x84000049, 0x940000f2,
		0x74000102, 0x84000055, 0x84000015, 0x84000200,
		0xa400012e, 0x84000075, 0x84000035, 0x940000ca,
		0x8400010c, 0x84000065, 0x84000025, 0x940000aa,
		0x84000005, 0x84000085, 0x84000045, 0x940000ea,
		0x74000106, 0x8400005d, 0x8400001d, 0x9400009a,
		0xb400015e, 0x8400007d, 0x8400003d, 0x940000da,
		0x94000116, 0x8400006d, 0x8400002d, 0x940000ba,
		0x8400000d, 0x8400008d, 0x8400004d, 0x940000fa,
		0x74000101, 0x84000053, 0x84000013, 0x3600004c,
		0xa4000126, 0x84000073, 0x84000033, 0x940000c6,
		0x8400010a, 0x84000063, 0x84000023, 0x940000a6,
		0x84000003, 0x84000083, 0x84000043, 0x940000e6,
		0x74000105, 0x8400005b, 0x8400001b, 0x94000096,
		0xb400014e, 0x8400007b, 0x8400003b, 0x940000d6,
		0x94000112, 0x8400006b, 0x8400002b, 0x940000b6,
		0x8400000b, 0x8400008b, 0x8400004b, 0x940000f6,
		0x74000103, 0x84000057, 0x84000017, 0x00000000,
		0xa4000136, 0x84000077, 0x84000037, 0x940000ce,
		0x8400010e, 0x84000067, 0x84000027, 0x940000ae,
		0x84000007, 0x84000087, 0x84000047, 0x940000ee,
		0x74000107, 0x8400005f, 0x8400001f, 0x9400009e,
		0xb400016e, 0x8400007f, 0x8400003f, 0x940000de,
		0x9400011a, 0x8400006f, 0x8400002f, 0x940000be,
		0x8400000f, 0x8400008f, 0x8400004f, 0x940000fe,
		0x74000100, 0x84000050, 0x84000010, 0xc4000178,
		0x9400011f, 0x84000070, 0x84000030, 0x940000c1,
		0x74000108, 0x84000060, 0x84000020, 0x940000a1,
		0x84000000, 0x84000080, 0x84000040, 0x940000e1,
		0x74000104, 0x84000058, 0x84000018, 0x94000091,
		0xa400013f, 0x84000078, 0x84000038, 0x940000d1,
		0x8400010f, 0x84000068, 0x84000028, 0x940000b1,
		0x84000008, 0x84000088, 0x84000048, 0x940000f1,
		0x74000102, 0x84000054, 0x84000014, 0x3600006e,
		0xa400012f, 0x84000074, 0x84000034, 0x940000c9,
		0x8400010b, 0x84000064, 0x84000024, 0x940000a9,
		0x84000004, 0x84000084, 0x84000044, 0x940000e9,
		0x74000106, 0x8400005c, 0x8400001c, 0x94000099,
		0xb400015f, 0x8400007c, 0x8400003c, 0x940000d9,
		0x94000117, 0x8400006c, 0x8400002c, 0x940000b9,
		0x8400000c, 0x8400008c, 0x8400004c, 0x940000f9,
		0x74000101, 0x84000052, 0x84000012, 0x3600002e,
		0xa4000127, 0x84000072, 0x84000032, 0x940000c5,
		0x84000109, 0x84000062, 0x84000022, 0x940000a5,
		0x84000002, 0x84000082, 0x84000042, 0x940000e5,
		0x74000105, 0x8400005a, 0x8400001a, 0x94000095,
		0xb400014f, 0x8400007a, 0x8400003a, 0x940000d5,
		0x94000113, 0x8400006a, 0x8400002a, 0x940000b5,
		0x8400000a, 0x8400008a, 0x8400004a, 0x940000f5,
		0x74000103, 0x84000056, 0x84000016, 0x00000000,
		0xa4000137, 0x84000076, 0x84000036, 0x940000cd,
		0x8400010d, 0x84000066, 0x84000026, 0x940000ad,
		0x84000006, 0x84000086, 0x84000046, 0x940000ed,
		0x74000107, 0x8400005e, 0x8400001e, 0x9400009d,
		0xb400016f, 0x8400007e, 0x8400003e, 0x940000dd,
		0x9400011b, 0x8400006e, 0x8400002e, 0x940000bd,
		0x8400000e, 0x8400008e, 0x8400004e, 0x940000fd,
		0x74000100, 0x84000051, 0x84000011, 0x3600000e,
		0x94000120, 0x84000071, 0x84000031, 0x940000c3,
		0x74000108, 0x84000061, 0x84000021, 0x940000a3,
		0x84000001, 0x84000081, 0x84000041, 0x940000e3,
		0x74000104, 0x84000059, 0x84000019, 0x94000093,
		0xa4000140, 0x84000079, 0x84000039, 0x940000d3,
		0x84000110, 0x84000069, 0x84000029, 0x940000b3,
		0x84000009, 0x84000089, 0x84000049, 0x940000f3,
		0x74000102, 0x84000055, 0x84000015, 0x84000200,
		0xa4000130, 0x84000075, 0x84000035, 0x940000cb,
		0x8400010c, 0x84000065, 0x84000025, 0x940000ab,
		0x84000005, 0x84000085, 0x84000045, 0x940000eb,
		0x74000106, 0x8400005d, 0x8400001d, 0x9400009b,
		0xb4000160, 0x8400007d, 0x8400003d, 0x940000db,
		0x94000118, 0x8400006d, 0x8400002d, 0x940000bb,
		0x8400000d, 0x8400008d, 0x8400004d, 0x940000fb,
		0x74000101, 0x84000053, 0x84000013, 0x3600004e,
		0xa4000128, 0x84000073, 0x84000033, 0x940000c7,
		0x8400010a, 0x84000063, 0x84000023, 0x940000a7,
		0x84000003, 0x84000083, 0x84000043, 0x940000e7,
		0x74000105, 0x8400005b, 0x8400001b, 0x94000097,
		0xb4000150, 0x8400007b, 0x8400003b, 0x940000d7,
		0x94000114, 0x8400006b, 0x8400002b, 0x940000b7,
		0x8400000b, 0x8400008b, 0x8400004b, 0x940000f7,
		0x74000103, 0x84000057, 0x84000017, 0x00000000,
		0xa4000138, 0x84000077, 0x84000037, 0x940000cf,
		0x8400010e, 0x84000067, 0x84000027, 0x940000af,
		0x84000007, 0x84000087, 0x84000047, 0x940000ef,
		0x74000107, 0x8400005f, 0x8400001f, 0x9400009f,
		0xb4000170, 0x8400007f, 0x8400003f, 0x940000df,
		0x9400011c, 0x8400006f, 0x8400002f, 0x940000bf,
		0x8400000f, 0x8400008f, 0x8400004f, 0x940000ff,
		0x74000100, 0x84000050, 0x84000010, 0xc4000179,
		0x9400011d, 0x84000070, 0x84000030, 0x940000c0,
		0x74000108, 0x84000060, 0x84000020, 0x940000a0,
		0x84000000, 0x84000080, 0x84000040, 0x940000e0,
		0x74000104, 0x84000058, 0x84000018, 0x94000090,
		0xa4000139, 0x84000078, 0x84000038, 0x940000d0,
		0x8400010f, 0x84000068, 0x84000028, 0x940000b0,
		0x84000008, 0x84000088, 0x84000048, 0x940000f0,
		0x74000102, 0x84000054, 0x84000014, 0x36000070,
		0xa4000129, 0x84000074, 0x84000034, 0x940000c8,
		0x8400010b, 0x84000064, 0x84000024, 0x940000a8,
		0x84000004, 0x84000084, 0x84000044, 0x940000e8,
		0x74000106, 0x8400005c, 0x8400001c, 0x94000098,
		0xb4000151, 0x8400007c, 0x8400003c, 0x940000d8,
		0x94000115, 0x8400006c, 0x8400002c, 0x940000b8,
		0x8400000c, 0x8400008c, 0x8400004c, 0x940000f8,
		0x74000101, 0x84000052, 0x84000012, 0x36000030,
		0xa4000121, 0x84000072, 0x84000032, 0x940000c4,
		0x84000109, 0x84000062, 0x84000022, 0x940000a4,
		0x84000002, 0x84000082, 0x84000042, 0x940000e4,
		0x74000105, 0x8400005a, 0x8400001a, 0x94000094,
		0xb4000141, 0x8400007a, 0x8400003a, 0x940000d4,
		0x94000111, 0x8400006a, 0x8400002a, 0x940000b4,
		0x8400000a, 0x8400008a, 0x8400004a, 0x940000f4,
		0x74000103, 0x84000056, 0x84000016, 0x00000000,
		0xa4000131, 0x84000076, 0x84000036, 0x940000cc,
		0x8400010d, 0x84000066, 0x84000026, 0x940000ac,
		0x84000006, 0x84000086, 0x84000046, 0x940000ec,
		0x74000107, 0x8400005e, 0x8400001e, 0x9400009c,
		0xb4000161, 0x8400007e, 0x8400003e, 0x940000dc,
		0x94000119, 0x8400006e, 0x8400002e, 0x940000bc,
		0x8400000e, 0x8400008e, 0x8400004e, 0x940000fc,
		0x74000100, 0x84000051, 0x84000011, 0x36000010,
		0x9400011e, 0x84000071, 0x84000031, 0x940000c2,
		0x74000108, 0x84000061, 0x84000021, 0x940000a2,
		0x84000001, 0x84000081, 0x84000041, 0x940000e2,
		0x74000104, 0x84000059, 0x84000019, 0x94000092,
		0xa400013a, 0x84000079, 0x84000039, 0x940000d2,
		0x84000110, 0x84000069, 0x84000029, 0x940000b2,
		0x84000009, 0x84000089, 0x84000049, 0x940000f2,
		0x74000102, 0x84000055, 0x84000015, 0x84000200,
		0xa400012a, 0x84000075, 0x84000035, 0x940000ca,
		0x8400010c, 0x84000065, 0x84000025, 0x940000aa,
		0x84000005, 0x84000085, 0x84000045, 0x940000ea,
		0x74000106, 0x8400005d, 0x8400001d, 0x9400009a,
		0xb4000152, 0x8400007d, 0x8400003d, 0x940000da,
		0x94000116, 0x8400006d, 0x8400002d, 0x940000ba,
		0x8400000d, 0x8400008d, 0x8400004d, 0x940000fa,
		0x74000101, 0x84000053, 0x84000013, 0x36000050,
		0xa4000122, 0x84000073, 0x84000033, 0x940000c6,
		0x8400010a, 0x84000063, 0x84000023, 0x940000a6,
		0x84000003, 0x84000083, 0x84000043, 0x940000e6,
		0x74000105, 0x8400005b, 0x8400001b, 0x94000096,
		0xb4000142, 0x8400007b, 0x8400003b, 0x940000d6,
		0x94000112, 0x8400006b, 0x8400002b, 0x940000b6,
		0x8400000b, 0x8400008b, 0x8400004b, 0x940000f6,
		0x74000103, 0x84000057, 0x84000017, 0x00000000,
		0xa4000132, 0x84000077, 0x84000037, 0x940000ce,
		0x8400010e, 0x84000067, 0x84000027, 0x940000ae,
		0x84000007, 0x84000087, 0x84000047, 0x940000ee,
		0x74000107, 0x8400005f, 0x8400001f, 0x9400009e,
		0xb4000162, 0x8400007f, 0x8400003f, 0x940000de,
		0x9400011a, 0x8400006f, 0x8400002f, 0x940000be,
		0x8400000f, 0x8400008f, 0x8400004f, 0x940000fe,
		0x74000100, 0x84000050, 0x84000010, 0xc400017a,
		0x9400011f, 0x84000070, 0x84000030, 0x940000c1,
		0x74000108, 0x84000060, 0x84000020, 0x940000a1,
		0x84000000, 0x84000080, 0x84000040, 0x940000e1,
		0x74000104, 0x84000058, 0x84000018, 0x94000091,
		0xa400013b, 0x84000078, 0x84000038, 0x940000d1,
		0x8400010f, 0x84000068, 0x84000028, 0x940000b1,
		0x84000008, 0x84000088, 0x84000048, 0x940000f1,
		0x74000102, 0x84000054, 0x84000014, 0x36000072,
		0xa400012b, 0x84000074, 0x84000034, 0x940000c9,
		0x8400010b, 0x84000064, 0x84000024, 0x940000a9,
		0x84000004, 0x84000084, 0x84000044, 0x940000e9,
		0x74000106, 0x8400005c, 0x8400001c, 0x94000099,
		0xb4000153, 0x8400007c, 0x8400003c, 0x940000d9,
		0x94000117, 0x8400006c, 0x8400002c, 0x940000b9,
		0x8400000c, 0x8400008c, 0x8400004c, 0x940000f9,
		0x74000101, 0x84000052, 0x84000012, 0x36000032,
		0xa4000123, 0x84000072, 0x84000032, 0x940000c5,
		0x84000109, 0x84000062, 0x84000022, 0x940000a5,
		0x84000002, 0x84000082, 0x84000042, 0x940000e5,
		0x74000105, 0x8400005a, 0x8400001a, 0x94000095,
		0xb4000143, 0x8400007a, 0x8400003a, 0x940000d5,
		0x94000113, 0x8400006a, 0x8400002a, 0x940000b5,
		0x8400000a, 0x8400008a, 0x8400004a, 0x940000f5,
		0x74000103, 0x84000056, 0x84000016, 0x00000000,
		0xa4000133, 0x84000076, 0x84000036, 0x940000cd,
		0x8400010d, 0x84000066, 0x84000026, 0x940000ad,
		0x84000006, 0x84000086, 0x84000046, 0x940000ed,
		0x74000107, 0x8400005e, 0x8400001e, 0x9400009d,
		0xb4000163, 0x8400007e, 0x8400003e, 0x940000dd,
		0x9400011b, 0x8400006e, 0x8400002e, 0x940000bd,
		0x8400000e, 0x8400008e, 0x8400004e, 0x940000fd,
		0x74000100, 0x84000051, 0x84000011, 0x36000012,
		0x94000120, 0x84000071, 0x84000031, 0x940000c3,
		0x74000108, 0x84000061, 0x84000021, 0x940000a3,
		0x84000001, 0x84000081, 0x84000041, 0x940000e3,
		0x74000104, 0x84000059, 0x84000019, 0x94000093,
		0xa400013c, 0x84000079, 0x84000039, 0x940000d3,
		0x84000110, 0x84000069, 0x84000029, 0x940000b3,
		0x84000009, 0x84000089, 0x84000049, 0x940000f3,
		0x74000102, 0x84000055, 0x84000015, 0x84000200,
		0xa400012c, 0x84000075, 0x84000035, 0x940000cb,
		0x8400010c, 0x84000065, 0x84000025, 0x940000ab,
		0x84000005, 0x84000085, 0x84000045, 0x940000eb,
		0x74000106, 0x8400005d, 0x8400001d, 0x9400009b,
		0xb4000154, 0x8400007d, 0x8400003d, 0x940000db,
		0x94000118, 0x8400006d, 0x8400002d, 0x940000bb,
		0x8400000d, 0x8400008d, 0x8400004d, 0x940000fb,
		0x74000101, 0x84000053, 0x84000013, 0x36000052,
		0xa4000124, 0x84000073, 0x84000033, 0x940000c7,
		0x8400010a, 0x84000063, 0x84000023, 0x940000a7,
		0x84000003, 0x84000083, 0x84000043, 0x940000e7,
		0x74000105, 0x8400005b, 0x8400001b, 0x94000097,
		0xb4000144, 0x8400007b, 0x8400003b, 0x940000d7,
		0x94000114, 0x8400006b, 0x8400002b, 0x940000b7,
		0x8400000b, 0x8400008b, 0x8400004b, 0x940000f7,
		0x74000103, 0x84000057, 0x84000017, 0x00000000,
		0xa4000134, 0x84000077, 0x84000037, 0x940000cf,
		0x8400010e, 0x84000067, 0x84000027, 0x940000af,
		0x84000007, 0x84000087, 0x84000047, 0x940000ef,
		0x74000107, 0x8400005f, 0x8400001f, 0x9400009f,
		0xb4000164, 0x8400007f, 0x8400003f, 0x940000df,
		0x9400011c, 0x8400006f, 0x8400002f, 0x940000bf,
		0x8400000f, 0x8400008f, 0x8400004f, 0x940000ff,
		0x74000100, 0x84000050, 0x84000010, 0xc400017b,
		0x9400011d, 0x84000070, 0x84000030, 0x940000c0,
		0x74000108, 0x84000060, 0x84000020, 0x940000a0,
		0x84000000, 0x84000080, 0x84000040, 0x940000e0,
		0x74000104, 0x84000058, 0x84000018, 0x94000090,
		0xa400013d, 0x84000078, 0x84000038, 0x940000d0,
		0x8400010f, 0x84000068, 0x84000028, 0x940000b0,
		0x84000008, 0x84000088, 0x84000048, 0x940000f0,
		0x74000102, 0x84000054, 0x84000014, 0x36000074,
		0xa400012d, 0x84000074, 0x84000034, 0x940000c8,
		0x8400010b, 0x84000064, 0x84000024, 0x940000a8,
		0x84000004, 0x84000084, 0x84000044, 0x940000e8,
		0x74000106, 0x8400005c, 0x8400001c, 0x94000098,
		0xb4000155, 0x8400007c, 0x8400003c, 0x940000d8,
		0x94000115, 0x8400006c, 0x8400002c, 0x940000b8,
		0x8400000c, 0x8400008c, 0x8400004c, 0x940000f8,
		0x74000101, 0x84000052, 0x84000012, 0x36000034,
		0xa4000125, 0x84000072, 0x84000032, 0x940000c4,
		0x84000109, 0x84000062, 0x84000022, 0x940000a4,
		0x84000002, 0x84000082, 0x84000042, 0x940000e4,
		0x74000105, 0x8400005a, 0x8400001a, 0x94000094,
		0xb4000145, 0x8400007a, 0x8400003a, 0x940000d4,
		0x94000111, 0x8400006a, 0x8400002a, 0x940000b4,
		0x8400000a, 0x8400008a, 0x8400004a, 0x940000f4,
		0x74000103, 0x84000056, 0x84000016, 0x00000000,
		0xa4000135, 0x84000076, 0x84000036, 0x940000cc,
		0x8400010d, 0x84000066, 0x84000026, 0x940000ac,
		0x84000006, 0x84000086, 0x84000046, 0x940000ec,
		0x74000107, 0x8400005e, 0x8400001e, 0x9400009c,
		0xb4000165, 0x8400007e, 0x8400003e, 0x940000dc,
		0x94000119, 0x8400006e, 0x8400002e, 0x940000bc,
		0x8400000e, 0x8400008e, 0x8400004e, 0x940000fc,
		0x74000100, 0x84000051, 0x84000011, 0x36000014,
		0x9400011e, 0x84000071, 0x84000031, 0x940000c2,
		0x74000108, 0x84000061, 0x84000021, 0x940000a2,
		0x84000001, 0x84000081, 0x84000041, 0x940000e2,
		0x74000104, 0x84000059, 0x84000019, 0x94000092,
		0xa400013e, 0x84000079, 0x84000039, 0x940000d2,
		0x84000110, 0x84000069, 0x84000029, 0x940000b2,
		0x84000009, 0x84000089, 0x84000049, 0x940000f2,
		0x74000102, 0x84000055, 0x84000015, 0x84000200,
		0xa400012e, 0x84000075, 0x84000035, 0x940000ca,
		0x8400010c, 0x84000065, 0x84000025, 0x940000aa,
		0x84000005, 0x84000085, 0x84000045, 0x940000ea,
		0x74000106, 0x8400005d, 0x8400001d, 0x9400009a,
		0xb4000156, 0x8400007d, 0x8400003d, 0x940000da,
		0x94000116, 0x8400006d, 0x8400002d, 0x940000ba,
		0x8400000d, 0x8400008d, 0x8400004d, 0x940000fa,
		0x74000101, 0x84000053, 0x84000013, 0x36000054,
		0xa4000126, 0x84000073, 0x84000033, 0x940000c6,
		0x8400010a, 0x84000063, 0x84000023, 0x940000a6,
		0x84000003, 0x84000083, 0x84000043, 0x940000e6,
		0x74000105, 0x8400005b, 0x8400001b, 0x94000096,
		0xb4000146, 0x8400007b, 0x8400003b, 0x940000d6,
		0x94000112, 0x8400006b, 0x8400002b, 0x940000b6,
		0x8400000b, 0x8400008b, 0x8400004b, 0x940000f6,
		0x74000103, 0x84000057, 0x84000017, 0x00000000,
		0xa4000136, 0x84000077, 0x84000037, 0x940000ce,
		0x8400010e, 0x84000067, 0x84000027, 0x940000ae,
		0x84000007, 0x84000087, 0x84000047, 0x940000ee,
		0x74000107, 0x8400005f, 0x8400001f, 0x9400009e,
		0xb4000166, 0x8400007f, 0x8400003f, 0x940000de,
		0x9400011a, 0x8400006f, 0x8400002f, 0x940000be,
		0x8400000f, 0x8400008f, 0x8400004f, 0x940000fe,
		0x74000100, 0x84000050, 0x84000010, 0xc400017c,
		0x9400011f, 0x84000070, 0x84000030, 0x940000c1,
		0x74000108, 0x84000060, 0x84000020, 0x940000a1,
		0x84000000, 0x84000080, 0x84000040, 0x940000e1,
		0x74000104, 0x84000058, 0x84000018, 0x94000091,
		0xa400013f, 0x84000078, 0x84000038, 0x940000d1,
		0x8400010f, 0x84000068, 0x84000028, 0x940000b1,
		0x84000008, 0x84000088, 0x84000048, 0x940000f1,
		0x74000102, 0x84000054, 0x84000014, 0x36000076,
		0xa400012f, 0x84000074, 0x84000034, 0x940000c9,
		0x8400010b, 0x84000064, 0x84000024, 0x940000a9,
		0x84000004, 0x84000084, 0x84000044, 0x940000e9,
		0x74000106, 0x8400005c, 0x8400001c, 0x94000099,
		0xb4000157, 0x8400007c, 0x8400003c, 0x940000d9,
		0x94000117, 0x8400006c, 0x8400002c, 0x940000b9,
		0x8400000c, 0x8400008c, 0x8400004c, 0x940000f9,
		0x74000101, 0x84000052, 0x84000012, 0x36000036,
		0xa4000127, 0x84000072, 0x84000032, 0x940000c5,
		0x84000109, 0x84000062, 0x84000022, 0x940000a5,
		0x84000002, 0x84000082, 0x84000042, 0x940000e5,
		0x74000105, 0x8400005a, 0x8400001a, 0x94000095,
		0xb4000147, 0x8400007a, 0x8400003a, 0x940000d5,
		0x94000113, 0x8400006a, 0x8400002a, 0x940000b5,
		0x8400000a, 0x8400008a, 0x8400004a, 0x940000f5,
		0x74000103, 0x84000056, 0x84000016, 0x00000000,
		0xa4000137, 0x84000076, 0x84000036, 0x940000cd,
		0x8400010d, 0x84000066, 0x84000026, 0x940000ad,
		0x84000006, 0x84000086, 0x84000046, 0x940000ed,
		0x74000107, 0x8400005e, 0x8400001e, 0x9400009d,
		0xb4000167, 0x8400007e, 0x8400003e, 0x940000dd,
		0x9400011b, 0x8400006e, 0x8400002e, 0x940000bd,
		0x8400000e, 0x8400008e, 0x8400004e, 0x940000fd,
		0x74000100, 0x84000051, 0x84000011, 0x36000016,
		0x94000120, 0x84000071, 0x84000031, 0x940000c3,
		0x74000108, 0x84000061, 0x84000021, 0x940000a3,
		0x84000001, 0x84000081, 0x84000041, 0x940000e3,
		0x74000104, 0x84000059, 0x84000019, 0x94000093,
		0xa4000140, 0x84000079, 0x84000039, 0x940000d3,
		0x84000110, 0x84000069, 0x84000029, 0x940000b3,
		0x84000009, 0x84000089, 0x84000049, 0x940000f3,
		0x74000102, 0x84000055, 0x84000015, 0x84000200,
		0xa4000130, 0x84000075, 0x84000035, 0x940000cb,
		0x8400010c, 0x84000065, 0x84000025, 0x940000ab,
		0x84000005, 0x84000085, 0x84000045, 0x940000eb,
		0x74000106, 0x8400005d, 0x8400001d, 0x9400009b,
		0xb4000158, 0x8400007d, 0x8400003d, 0x940000db,
		0x94000118, 0x8400006d, 0x8400002d, 0x940000bb,
		0x8400000d, 0x8400008d, 0x8400004d, 0x940000fb,
		0x74000101, 0x84000053, 0x84000013, 0x36000056,
		0xa4000128, 0x84000073, 0x84000033, 0x940000c7,
		0x8400010a, 0x84000063, 0x84000023, 0x940000a7,
		0x84000003, 0x84000083, 0x84000043, 0x940000e7,
		0x74000105, 0x8400005b, 0x8400001b, 0x94000097,
		0xb4000148, 0x8400007b, 0x8400003b, 0x940000d7,
		0x94000114, 0x8400006b, 0x8400002b, 0x940000b7,
		0x8400000b, 0x8400008b, 0x8400004b, 0x940000f7,
		0x74000103, 0x84000057, 0x84000017, 0x00000000,
		0xa4000138, 0x84000077, 0x84000037, 0x940000cf,
		0x8400010e, 0x84000067, 0x84000027, 0x940000af,
		0x84000007, 0x84000087, 0x84000047, 0x940000ef,
		0x74000107, 0x8400005f, 0x8400001f, 0x9400009f,
		0xb4000168, 0x8400007f, 0x8400003f, 0x940000df,
		0x9400011c, 0x8400006f, 0x8400002f, 0x940000bf,
		0x8400000f, 0x8400008f, 0x8400004f, 0x940000ff,
		0x74000100, 0x84000050, 0x84000010, 0xc400017d,
		0x9400011d, 0x84000070, 0x84000030, 0x940000c0,
		0x74000108, 0x84000060, 0x84000020, 0x940000a0,
		0x84000000, 0x84000080, 0x84000040, 0x940000e0,
		0x74000104, 0x84000058, 0x84000018, 0x94000090,
		0xa4000139, 0x84000078, 0x84000038, 0x940000d0,
		0x8400010f, 0x84000068, 0x84000028, 0x940000b0,
		0x84000008, 0x84000088, 0x84000048, 0x940000f0,
		0x74000102, 0x84000054, 0x84000014, 0x36000078,
		0xa4000129, 0x84000074, 0x84000034, 0x940000c8,
		0x8400010b, 0x84000064, 0x84000024, 0x940000a8,
		0x84000004, 0x84000084, 0x84000044, 0x940000e8,
		0x74000106, 0x8400005c, 0x8400001c, 0x94000098,
		0xb4000159, 0x8400007c, 0x8400003c, 0x940000d8,
		0x94000115, 0x8400006c, 0x8400002c, 0x940000b8,
		0x8400000c, 0x8400008c, 0x8400004c, 0x940000f8,
		0x74000101, 0x84000052, 0x84000012, 0x36000038,
		0xa4000121, 0x84000072, 0x84000032, 0x940000c4,
		0x84000109, 0x84000062, 0x84000022, 0x940000a4,
		0x84000002, 0x84000082, 0x84000042, 0x940000e4,
		0x74000105, 0x8400005a, 0x8400001a, 0x94000094,
		0xb4000149, 0x8400007a, 0x8400003a, 0x940000d4,
		0x94000111, 0x8400006a, 0x8400002a, 0x940000b4,
		0x8400000a, 0x8400008a, 0x8400004a, 0x940000f4,
		0x74000103, 0x84000056, 0x84000016, 0x00000000,
		0xa4000131, 0x84000076, 0x84000036, 0x940000cc,
		0x8400010d, 0x84000066, 0x84000026, 0x940000ac,
		0x84000006, 0x84000086, 0x84000046, 0x940000ec,
		0x74000107, 0x8400005e, 0x8400001e, 0x9400009c,
		0xb4000169, 0x8400007e, 0x8400003e, 0x940000dc,
		0x94000119, 0x8400006e, 0x8400002e, 0x940000bc,
		0x8400000e, 0x8400008e, 0x8400004e, 0x940000fc,
		0x74000100, 0x84000051, 0x84000011, 0x36000018,
		0x9400011e, 0x84000071, 0x84000031, 0x940000c2,
		0x74000108, 0x84000061, 0x84000021, 0x940000a2,
		0x84000001, 0x84000081, 0x84000041, 0x940000e2,
		0x74000104, 0x84000059, 0x84000019, 0x94000092,
		0xa400013a, 0x84000079, 0x84000039, 0x940000d2,
		0x84000110, 0x84000069, 0x84000029, 0x940000b2,
		0x84000009, 0x84000089, 0x84000049, 0x940000f2,
		0x74000102, 0x84000055, 0x84000015, 0x84000200,
		0xa400012a, 0x84000075, 0x84000035, 0x940000ca,
		0x8400010c, 0x84000065, 0x84000025, 0x940000aa,
		0x84000005, 0x84000085, 0x84000045, 0x940000ea,
		0x74000106, 0x8400005d, 0x8400001d, 0x9400009a,
		0xb400015a, 0x8400007d, 0x8400003d, 0x940000da,
		0x94000116, 0x8400006d, 0x8400002d, 0x940000ba,
		0x8400000d, 0x8400008d, 0x8400004d, 0x940000fa,
		0x74000101, 0x84000053, 0x84000013, 0x36000058,
		0xa4000122, 0x84000073, 0x84000033, 0x940000c6,
		0x8400010a, 0x84000063, 0x84000023, 0x940000a6,
		0x84000003, 0x84000083, 0x84000043, 0x940000e6,
		0x74000105, 0x8400005b, 0x8400001b, 0x94000096,
		0xb400014a, 0x8400007b, 0x8400003b, 0x940000d6,
		0x94000112, 0x8400006b, 0x8400002b, 0x940000b6,
		0x8400000b, 0x8400008b, 0x8400004b, 0x940000f6,
		0x74000103, 0x84000057, 0x84000017, 0x00000000,
		0xa4000132, 0x84000077, 0x84000037, 0x940000ce,
		0x8400010e, 0x84000067, 0x84000027, 0x940000ae,
		0x84000007, 0x84000087, 0x84000047, 0x940000ee,
		0x74000107, 0x8400005f, 0x8400001f, 0x9400009e,
		0xb400016a, 0x8400007f, 0x8400003f, 0x940000de,
		0x9400011a, 0x8400006f, 0x8400002f, 0x940000be,
		0x8400000f, 0x8400008f, 0x8400004f, 0x940000fe,
		0x74000100, 0x84000050, 0x84000010, 0xc400017e,
		0x9400011f, 0x84000070, 0x84000030, 0x940000c1,
		0x74000108, 0x84000060, 0x84000020, 0x940000a1,
		0x84000000, 0x84000080, 0x84000040, 0x940000e1,
		0x74000104, 0x84000058, 0x84000018, 0x94000091,
		0xa400013b, 0x84000078, 0x84000038, 0x940000d1,
		0x8400010f, 0x84000068, 0x84000028, 0x940000b1,
		0x84000008, 0x84000088, 0x84000048, 0x940000f1,
		0x74000102, 0x84000054, 0x84000014, 0x3600007a,
		0xa400012b, 0x84000074, 0x84000034, 0x940000c9,
		0x8400010b, 0x84000064, 0x84000024, 0x940000a9,
		0x84000004, 0x84000084, 0x84000044, 0x940000e9,
		0x74000106, 0x8400005c, 0x8400001c, 0x94000099,
		0xb400015b, 0x8400007c, 0x8400003c, 0x940000d9,
		0x94000117, 0x8400006c, 0x8400002c, 0x940000b9,
		0x8400000c, 0x8400008c, 0x8400004c, 0x940000f9,
		0x74000101, 0x84000052, 0x84000012, 0x3600003a,
		0xa4000123, 0x84000072, 0x84000032, 0x940000c5,
		0x84000109, 0x84000062, 0x84000022, 0x940000a5,
		0x84000002, 0x84000082, 0x84000042, 0x940000e5,
		0x74000105, 0x8400005a, 0x8400001a, 0x94000095,
		0xb400014b, 0x8400007a, 0x8400003a, 0x940000d5,
		0x94000113, 0x8400006a, 0x8400002a, 0x940000b5,
		0x8400000a, 0x8400008a, 0x8400004a, 0x940000f5,
		0x74000103, 0x84000056, 0x84000016, 0x00000000,
		0xa4000133, 0x84000076, 0x84000036, 0x940000cd,
		0x8400010d, 0x84000066, 0x84000026, 0x940000ad,
		0x84000006, 0x84000086, 0x84000046, 0x940000ed,
		0x74000107, 0x8400005e, 0x8400001e, 0x9400009d,
		0xb400016b, 0x8400007e, 0x8400003e, 0x940000dd,
		0x9400011b, 0x8400006e, 0x8400002e, 0x940000bd,
		0x8400000e, 0x8400008e, 0x8400004e, 0x940000fd,
		0x74000100, 0x84000051, 0x84000011, 0x3600001a,
		0x94000120, 0x84000071, 0x84000031, 0x940000c3,
		0x74000108, 0x84000061, 0x84000021, 0x940000a3,
		0x84000001, 0x84000081, 0x84000041, 0x940000e3,
		0x74000104, 0x84000059, 0x84000019, 0x94000093,
		0xa400013c, 0x84000079, 0x84000039, 0x940000d3,
		0x84000110, 0x84000069, 0x84000029, 0x940000b3,
		0x84000009, 0x84000089, 0x84000049, 0x940000f3,
		0x74000102, 0x84000055, 0x84000015, 0x84000200,
		0xa400012c, 0x84000075, 0x84000035, 0x940000cb,
		0x8400010c, 0x84000065, 0x84000025, 0x940000ab,
		0x84000005, 0x84000085, 0x84000045, 0x940000eb,
		0x74000106, 0x8400005d, 0x8400001d, 0x9400009b,
		0xb400015c, 0x8400007d, 0x8400003d, 0x940000db,
		0x94000118, 0x8400006d, 0x8400002d, 0x940000bb,
		0x8400000d, 0x8400008d, 0x8400004d, 0x940000fb,
		0x74000101, 0x84000053, 0x84000013, 0x3600005a,
		0xa4000124, 0x84000073, 0x84000033, 0x940000c7,
		0x8400010a, 0x84000063, 0x84000023, 0x940000a7,
		0x84000003, 0x84000083, 0x84000043, 0x940000e7,
		0x74000105, 0x8400005b, 0x8400001b, 0x94000097,
		0xb400014c, 0x8400007b, 0x8400003b, 0x940000d7,
		0x94000114, 0x8400006b, 0x8400002b, 0x940000b7,
		0x8400000b, 0x8400008b, 0x8400004b, 0x940000f7,
		0x74000103, 0x84000057, 0x84000017, 0x00000000,
		0xa4000134, 0x84000077, 0x84000037, 0x940000cf,
		0x8400010e, 0x84000067, 0x84000027, 0x940000af,
		0x84000007, 0x84000087, 0x84000047, 0x940000ef,
		0x74000107, 0x8400005f, 0x8400001f, 0x9400009f,
		0xb400016c, 0x8400007f, 0x8400003f, 0x940000df,
		0x9400011c, 0x8400006f, 0x8400002f, 0x940000bf,
		0x8400000f, 0x8400008f, 0x8400004f, 0x940000ff,
		0x74000100, 0x84000050, 0x84000010, 0xc400017f,
		0x9400011d, 0x84000070, 0x84000030, 0x940000c0,
		0x74000108, 0x84000060, 0x84000020, 0x940000a0,
		0x84000000, 0x84000080, 0x84000040, 0x940000e0,
		0x74000104, 0x84000058, 0x84000018, 0x94000090,
		0xa400013d, 0x84000078, 0x84000038, 0x940000d0,
		0x8400010f, 0x84000068, 0x84000028, 0x940000b0,
		0x84000008, 0x84000088, 0x84000048, 0x940000f0,
		0x74000102, 0x84000054, 0x84000014, 0x3600007c,
		0xa400012d, 0x84000074, 0x84000034, 0x940000c8,
		0x8400010b, 0x84000064, 0x84000024, 0x940000a8,
		0x84000004, 0x84000084, 0x84000044, 0x940000e8,
		0x74000106, 0x8400005c, 0x8400001c, 0x94000098,
		0xb400015d, 0x8400007c, 0x8400003c, 0x940000d8,
		0x94000115, 0x8400006c, 0x8400002c, 0x940000b8,
		0x8400000c, 0x8400008c, 0x8400004c, 0x940000f8,
		0x74000101, 0x84000052, 0x84000012, 0x3600003c,
		0xa4000125, 0x84000072, 0x84000032, 0x940000c4,
		0x84000109, 0x84000062, 0x84000022, 0x940000a4,
		0x84000002, 0x84000082, 0x84000042, 0x940000e4,
		0x74000105, 0x8400005a, 0x8400001a, 0x94000094,
		0xb400014d, 0x8400007a, 0x8400003a, 0x940000d4,
		0x94000111, 0x8400006a, 0x8400002a, 0x940000b4,
		0x8400000a, 0x8400008a, 0x8400004a, 0x940000f4,
		0x74000103, 0x84000056, 0x84000016, 0x00000000,
		0xa4000135, 0x84000076, 0x84000036, 0x940000cc,
		0x8400010d, 0x84000066, 0x84000026, 0x940000ac,
		0x84000006, 0x84000086, 0x84000046, 0x940000ec,
		0x74000107, 0x8400005e, 0x8400001e, 0x9400009c,
		0xb400016d, 0x8400007e, 0x8400003e, 0x940000dc,
		0x94000119, 0x8400006e, 0x8400002e, 0x940000bc,
		0x8400000e, 0x8400008e, 0x8400004e, 0x940000fc,
		0x74000100, 0x84000051, 0x84000011, 0x3600001c,
		0x9400011e, 0x84000071, 0x84000031, 0x940000c2,
		0x74000108, 0x84000061, 0x84000021, 0x940000a2,
		0x84000001, 0x84000081, 0x84000041, 0x940000e2,
		0x74000104, 0x84000059, 0x84000019, 0x94000092,
		0xa400013e, 0x84000079, 0x84000039, 0x940000d2,
		0x84000110, 0x84000069, 0x84000029, 0x940000b2,
		0x84000009, 0x84000089, 0x84000049, 0x940000f2,
		0x74000102, 0x84000055, 0x84000015, 0x84000200,
		0xa400012e, 0x84000075, 0x84000035, 0x940000ca,
		0x8400010c, 0x84000065, 0x84000025, 0x940000aa,
		0x84000005, 0x84000085, 0x84000045, 0x940000ea,
		0x74000106, 0x8400005d, 0x8400001d, 0x9400009a,
		0xb400015e, 0x8400007d, 0x8400003d, 0x940000da,
		0x94000116, 0x8400006d, 0x8400002d, 0x940000ba,
		0x8400000d, 0x8400008d, 0x8400004d, 0x940000fa,
		0x74000101, 0x84000053, 0x84000013, 0x3600005c,
		0xa4000126, 0x84000073, 0x84000033, 0x940000c6,
		0x8400010a, 0x84000063, 0x84000023, 0x940000a6,
		0x84000003, 0x84000083, 0x84000043, 0x940000e6,
		0x74000105, 0x8400005b, 0x8400001b, 0x94000096,
		0xb400014e, 0x8400007b, 0x8400003b, 0x940000d6,
		0x94000112, 0x8400006b, 0x8400002b, 0x940000b6,
		0x8400000b, 0x8400008b, 0x8400004b, 0x940000f6,
		0x74000103, 0x84000057, 0x84000017, 0x00000000,
		0xa4000136, 0x84000077, 0x84000037, 0x940000ce,
		0x8400010e, 0x84000067, 0x84000027, 0x940000ae,
		0x84000007, 0x84000087, 0x84000047, 0x940000ee,
		0x74000107, 0x8400005f, 0x8400001f, 0x9400009e,
		0xb400016e, 0x8400007f, 0x8400003f, 0x940000de,
		0x9400011a, 0x8400006f, 0x8400002f, 0x940000be,
		0x8400000f, 0x8400008f, 0x8400004f, 0x940000fe,
		0x74000100, 0x84000050, 0x84000010, 0xc4000180,
		0x9400011f, 0x84000070, 0x84000030, 0x940000c1,
		0x74000108, 0x84000060, 0x84000020, 0x940000a1,
		0x84000000, 0x84000080, 0x84000040, 0x940000e1,
		0x74000104, 0x84000058, 0x84000018, 0x94000091,
		0xa400013f, 0x84000078, 0x84000038, 0x940000d1,
		0x8400010f, 0x84000068, 0x84000028, 0x940000b1,
		0x84000008, 0x84000088, 0x84000048, 0x940000f1,
		0x74000102, 0x84000054, 0x84000014, 0x3600007e,
		0xa400012f, 0x84000074, 0x84000034, 0x940000c9,
		0x8400010b, 0x84000064, 0x84000024, 0x940000a9,
		0x84000004, 0x84000084, 0x84000044, 0x940000e9,
		0x74000106, 0x8400005c, 0x8400001c, 0x94000099,
		0xb400015f, 0x8400007c, 0x8400003c, 0x940000d9,
		0x94000117, 0x8400006c, 0x8400002c, 0x940000b9,
		0x8400000c, 0x8400008c, 0x8400004c, 0x940000f9,
		0x74000101, 0x84000052, 0x84000012, 0x3600003e,
		0xa4000127, 0x84000072, 0x84000032, 0x940000c5,
		0x84000109, 0x84000062, 0x84000022, 0x940000a5,
		0x84000002, 0x84000082, 0x84000042, 0x940000e5,
		0x74000105, 0x8400005a, 0x8400001a, 0x94000095,
		0xb400014f, 0x8400007a, 0x8400003a, 0x940000d5,
		0x94000113, 0x8400006a, 0x8400002a, 0x940000b5,
		0x8400000a, 0x8400008a, 0x8400004a, 0x940000f5,
		0x74000103, 0x84000056, 0x84000016, 0x00000000,
		0xa4000137, 0x84000076, 0x84000036, 0x940000cd,
		0x8400010d, 0x84000066, 0x84000026, 0x940000ad,
		0x84000006, 0x84000086, 0x84000046, 0x940000ed,
		0x74000107, 0x8400005e, 0x8400001e, 0x9400009d,
		0xb400016f, 0x8400007e, 0x8400003e, 0x940000dd,
		0x9400011b, 0x8400006e, 0x8400002e, 0x940000bd,
		0x8400000e, 0x8400008e, 0x8400004e, 0x940000fd,
		0x74000100, 0x84000051, 0x84000011, 0x3600001e,
		0x94000120, 0x84000071, 0x84000031, 0x940000c3,
		0x74000108, 0x84000061, 0x84000021, 0x940000a3,
		0x84000001, 0x84000081, 0x84000041, 0x940000e3,
		0x74000104, 0x84000059, 0x84000019, 0x94000093,
		0xa4000140, 0x84000079, 0x84000039, 0x940000d3,
		0x84000110, 0x84000069, 0x84000029, 0x940000b3,
		0x84000009, 0x84000089, 0x84000049, 0x940000f3,
		0x74000102, 0x84000055, 0x84000015, 0x84000200,
		0xa4000130, 0x84000075, 0x84000035, 0x940000cb,
		0x8400010c, 0x84000065, 0x84000025, 0x940000ab,
		0x84000005, 0x84000085, 0x84000045, 0x940000eb,
		0x74000106, 0x8400005d, 0x8400001d, 0x9400009b,
		0xb4000160, 0x8400007d, 0x8400003d, 0x940000db,
		0x94000118, 0x8400006d, 0x8400002d, 0x940000bb,
		0x8400000d, 0x8400008d, 0x8400004d, 0x940000fb,
		0x74000101, 0x84000053, 0x84000013, 0x3600005e,
		0xa4000128, 0x84000073, 0x84000033, 0x940000c7,
		0x8400010a, 0x84000063, 0x84000023, 0x940000a7,
		0x84000003, 0x84000083, 0x84000043, 0x940000e7,
		0x74000105, 0x8400005b, 0x8400001b, 0x94000097,
		0xb4000150, 0x8400007b, 0x8400003b, 0x940000d7,
		0x94000114, 0x8400006b, 0x8400002b, 0x940000b7,
		0x8400000b, 0x8400008b, 0x8400004b, 0x940000f7,
		0x74000103, 0x84000057, 0x84000017, 0x00000000,
		0xa4000138, 0x84000077, 0x84000037, 0x940000cf,
		0x8400010e, 0x84000067, 0x84000027, 0x940000af,
		0x84000007, 0x84000087, 0x84000047, 0x940000ef,
		0x74000107, 0x8400005f, 0x8400001f, 0x9400009f,
		0xb4000170, 0x8400007f, 0x8400003f, 0x940000df,
		0x9400011c, 0x8400006f, 0x8400002f, 0x940000bf,
		0x8400000f, 0x8400008f, 0x8400004f, 0x940000ff	},

	.long_code_lookup = {
		0x3581, 0x3591, 0x3582, 0x3592, 0x3583, 0x3593, 0x3584, 0x3594,
		0x3585, 0x3595, 0x3586, 0x3596, 0x3587, 0x3597, 0x3588, 0x3598,
		0x3589, 0x3599, 0x358a, 0x359a, 0x358b, 0x359b, 0x358c, 0x359c,
		0x358d, 0x359d, 0x358e, 0x359e, 0x358f, 0x359f, 0x3590, 0x35a0,
		0x35a1, 0x35b1, 0x35a2, 0x35b2, 0x35a3, 0x35b3, 0x35a4, 0x35b4,
		0x35a5, 0x35b5, 0x35a6, 0x35b6, 0x35a7, 0x35b7, 0x35a8, 0x35b8,
		0x35a9, 0x35b9, 0x35aa, 0x35ba, 0x35ab, 0x35bb, 0x35ac, 0x35bc,
		0x35ad, 0x35bd, 0x35ae, 0x35be, 0x35af, 0x35bf, 0x35b0, 0x35c0,
		0x35c1, 0x35d1, 0x35c2, 0x35d2, 0x35c3, 0x35d3, 0x35c4, 0x35d4,
		0x35c5, 0x35d5, 0x35c6, 0x35d6, 0x35c7, 0x35d7, 0x35c8, 0x35d8,
		0x35c9, 0x35d9, 0x35ca, 0x35da, 0x35cb, 0x35db, 0x35cc, 0x35dc,
		0x35cd, 0x35dd, 0x35ce, 0x35de, 0x35cf, 0x35df, 0x35d0, 0x35e0,
		0x35e1, 0x35f1, 0x35e2, 0x35f2, 0x35e3, 0x35f3, 0x35e4, 0x35f4,
		0x35e5, 0x35f5, 0x35e6, 0x35f6, 0x35e7, 0x35f7, 0x35e8, 0x35f8,
		0x35e9, 0x35f9, 0x35ea, 0x35fa, 0x35eb, 0x35fb, 0x35ec, 0x35fc,
		0x35ed, 0x35fd, 0x35ee, 0x35fe, 0x35ef, 0x35ff, 0x35f0, 0x3600,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000	}
};

struct inflate_huff_code_small static_dist_huff_code = {
	.short_code_lookup = {
		0x2800, 0x28f0, 0x2868, 0x2978, 0x2824, 0x2934, 0x28ac, 0x29bc,
		0x2802, 0x2912, 0x288a, 0x299a, 0x2846, 0x2956, 0x28ce, 0x0005,
		0x2801, 0x28f1, 0x2869, 0x2979, 0x2825, 0x2935, 0x28ad, 0x29bd,
		0x2803, 0x2913, 0x288b, 0x299b, 0x2847, 0x2957, 0x28cf, 0x0005,
		0x2800, 0x28f0, 0x2868, 0x2978, 0x2824, 0x2934, 0x28ac, 0x29bc,
		0x2802, 0x2912, 0x288a, 0x299a, 0x2846, 0x2956, 0x28ce, 0x0005,
		0x2801, 0x28f1, 0x2869, 0x2979, 0x2825, 0x2935, 0x28ad, 0x29bd,
		0x2803, 0x2913, 0x288b, 0x299b, 0x2847, 0x2957, 0x28cf, 0x0005,
		0x2800, 0x28f0, 0x2868, 0x2978, 0x2824, 0x2934, 0x28ac, 0x29bc,
		0x2802, 0x2912, 0x288a, 0x299a, 0x2846, 0x2956, 0x28ce, 0x0005,
		0x2801, 0x28f1, 0x2869, 0x2979, 0x2825, 0x2935, 0x28ad, 0x29bd,
		0x2803, 0x2913, 0x288b, 0x299b, 0x2847, 0x2957, 0x28cf, 0x0005,
		0x2800, 0x28f0, 0x2868, 0x2978, 0x2824, 0x2934, 0x28ac, 0x29bc,
		0x2802, 0x2912, 0x288a, 0x299a, 0x2846, 0x2956, 0x28ce, 0x0005,
		0x2801, 0x28f1, 0x2869, 0x2979, 0x2825, 0x2935, 0x28ad, 0x29bd,
		0x2803, 0x2913, 0x288b, 0x299b, 0x2847, 0x2957, 0x28cf, 0x0005,
		0x2800, 0x28f0, 0x2868, 0x2978, 0x2824, 0x2934, 0x28ac, 0x29bc,
		0x2802, 0x2912, 0x288a, 0x299a, 0x2846, 0x2956, 0x28ce, 0x0005,
		0x2801, 0x28f1, 0x2869, 0x2979, 0x2825, 0x2935, 0x28ad, 0x29bd,
		0x2803, 0x2913, 0x288b, 0x299b, 0x2847, 0x2957, 0x28cf, 0x0005,
		0x2800, 0x28f0, 0x2868, 0x2978, 0x2824, 0x2934, 0x28ac, 0x29bc,
		0x2802, 0x2912, 0x288a, 0x299a, 0x2846, 0x2956, 0x28ce, 0x0005,
		0x2801, 0x28f1, 0x2869, 0x2979, 0x2825, 0x2935, 0x28ad, 0x29bd,
		0x2803, 0x2913, 0x288b, 0x299b, 0x2847, 0x2957, 0x28cf, 0x0005,
		0x2800, 0x28f0, 0x2868, 0x2978, 0x2824, 0x2934, 0x28ac, 0x29bc,
		0x2802, 0x2912, 0x288a, 0x299a, 0x2846, 0x2956, 0x28ce, 0x0005,
		0x2801, 0x28f1, 0x2869, 0x2979, 0x2825, 0x2935, 0x28ad, 0x29bd,
		0x2803, 0x2913, 0x288b, 0x299b, 0x2847, 0x2957, 0x28cf, 0x0005,
		0x2800, 0x28f0, 0x2868, 0x2978, 0x2824, 0x2934, 0x28ac, 0x29bc,
		0x2802, 0x2912, 0x288a, 0x299a, 0x2846, 0x2956, 0x28ce, 0x0005,
		0x2801, 0x28f1, 0x2869, 0x2979, 0x2825, 0x2935, 0x28ad, 0x29bd,
		0x2803, 0x2913, 0x288b, 0x299b, 0x2847, 0x2957, 0x28cf, 0x0005,
		0x2800, 0x28f0, 0x2868, 0x2978, 0x2824, 0x2934, 0x28ac, 0x29bc,
		0x2802, 0x2912, 0x288a, 0x299a, 0x2846, 0x2956, 0x28ce, 0x0005,
		0x2801, 0x28f1, 0x2869, 0x2979, 0x2825, 0x2935, 0x28ad, 0x29bd,
		0x2803, 0x2913, 0x288b, 0x299b, 0x2847, 0x2957, 0x28cf, 0x0005,
		0x2800, 0x28f0, 0x2868, 0x2978, 0x2824, 0x2934, 0x28ac, 0x29bc,
		0x2802, 0x2912, 0x288a, 0x299a, 0x2846, 0x2956, 0x28ce, 0x0005,
		0x2801, 0x28f1, 0x2869, 0x2979, 0x2825, 0x2935, 0x28ad, 0x29bd,
		0x2803, 0x2913, 0x288b, 0x299b, 0x2847, 0x2957, 0x28cf, 0x0005,
		0x2800, 0x28f0, 0x2868, 0x2978, 0x2824, 0x2934, 0x28ac, 0x29bc,
		0x2802, 0x2912, 0x288a, 0x299a, 0x2846, 0x2956, 0x28ce, 0x0005,
		0x2801, 0x28f1, 0x2869, 0x2979, 0x2825, 0x2935, 0x28ad, 0x29bd,
		0x2803, 0x2913, 0x288b, 0x299b, 0x2847, 0x2957, 0x28cf, 0x0005,
		0x2800, 0x28f0, 0x2868, 0x2978, 0x2824, 0x2934, 0x28ac, 0x29bc,
		0x2802, 0x2912, 0x288a, 0x299a, 0x2846, 0x2956, 0x28ce, 0x0005,
		0x2801, 0x28f1, 0x2869, 0x2979, 0x2825, 0x2935, 0x28ad, 0x29bd,
		0x2803, 0x2913, 0x288b, 0x299b, 0x2847, 0x2957, 0x28cf, 0x0005,
		0x2800, 0x28f0, 0x2868, 0x2978, 0x2824, 0x2934, 0x28ac, 0x29bc,
		0x2802, 0x2912, 0x288a, 0x299a, 0x2846, 0x2956, 0x28ce, 0x0005,
		0x2801, 0x28f1, 0x2869, 0x2979, 0x2825, 0x2935, 0x28ad, 0x29bd,
		0x2803, 0x2913, 0x288b, 0x299b, 0x2847, 0x2957, 0x28cf, 0x0005,
		0x2800, 0x28f0, 0x2868, 0x2978, 0x2824, 0x2934, 0x28ac, 0x29bc,
		0x2802, 0x2912, 0x288a, 0x299a, 0x2846, 0x2956, 0x28ce, 0x0005,
		0x2801, 0x28f1, 0x2869, 0x2979, 0x2825, 0x2935, 0x28ad, 0x29bd,
		0x2803, 0x2913, 0x288b, 0x299b, 0x2847, 0x2957, 0x28cf, 0x0005,
		0x2800, 0x28f0, 0x2868, 0x2978, 0x2824, 0x2934, 0x28ac, 0x29bc,
		0x2802, 0x2912, 0x288a, 0x299a, 0x2846, 0x2956, 0x28ce, 0x0005,
		0x2801, 0x28f1, 0x2869, 0x2979, 0x2825, 0x2935, 0x28ad, 0x29bd,
		0x2803, 0x2913, 0x288b, 0x299b, 0x2847, 0x2957, 0x28cf, 0x0005,
		0x2800, 0x28f0, 0x2868, 0x2978, 0x2824, 0x2934, 0x28ac, 0x29bc,
		0x2802, 0x2912, 0x288a, 0x299a, 0x2846, 0x2956, 0x28ce, 0x0005,
		0x2801, 0x28f1, 0x2869, 0x2979, 0x2825, 0x2935, 0x28ad, 0x29bd,
		0x2803, 0x2913, 0x288b, 0x299b, 0x2847, 0x2957, 0x28cf, 0x0005,
		0x2800, 0x28f0, 0x2868, 0x2978, 0x2824, 0x2934, 0x28ac, 0x29bc,
		0x2802, 0x2912, 0x288a, 0x299a, 0x2846, 0x2956, 0x28ce, 0x0005,
		0x2801, 0x28f1, 0x2869, 0x2979, 0x2825, 0x2935, 0x28ad, 0x29bd,
		0x2803, 0x2913, 0x288b, 0x299b, 0x2847, 0x2957, 0x28cf, 0x0005,
		0x2800, 0x28f0, 0x2868, 0x2978, 0x2824, 0x2934, 0x28ac, 0x29bc,
		0x2802, 0x2912, 0x288a, 0x299a, 0x2846, 0x2956, 0x28ce, 0x0005,
		0x2801, 0x28f1, 0x2869, 0x2979, 0x2825, 0x2935, 0x28ad, 0x29bd,
		0x2803, 0x2913, 0x288b, 0x299b, 0x2847, 0x2957, 0x28cf, 0x0005,
		0x2800, 0x28f0, 0x2868, 0x2978, 0x2824, 0x2934, 0x28ac, 0x29bc,
		0x2802, 0x2912, 0x288a, 0x299a, 0x2846, 0x2956, 0x28ce, 0x0005,
		0x2801, 0x28f1, 0x2869, 0x2979, 0x2825, 0x2935, 0x28ad, 0x29bd,
		0x2803, 0x2913, 0x288b, 0x299b, 0x2847, 0x2957, 0x28cf, 0x0005,
		0x2800, 0x28f0, 0x2868, 0x2978, 0x2824, 0x2934, 0x28ac, 0x29bc,
		0x2802, 0x2912, 0x288a, 0x299a, 0x2846, 0x2956, 0x28ce, 0x0005,
		0x2801, 0x28f1, 0x2869, 0x2979, 0x2825, 0x2935, 0x28ad, 0x29bd,
		0x2803, 0x2913, 0x288b, 0x299b, 0x2847, 0x2957, 0x28cf, 0x0005,
		0x2800, 0x28f0, 0x2868, 0x2978, 0x2824, 0x2934, 0x28ac, 0x29bc,
		0x2802, 0x2912, 0x288a, 0x299a, 0x2846, 0x2956, 0x28ce, 0x0005,
		0x2801, 0x28f1, 0x2869, 0x2979, 0x2825, 0x2935, 0x28ad, 0x29bd,
		0x2803, 0x2913, 0x288b, 0x299b, 0x2847, 0x2957, 0x28cf, 0x0005,
		0x2800, 0x28f0, 0x2868, 0x2978, 0x2824, 0x2934, 0x28ac, 0x29bc,
		0x2802, 0x2912, 0x288a, 0x299a, 0x2846, 0x2956, 0x28ce, 0x0005,
		0x2801, 0x28f1, 0x2869, 0x2979, 0x2825, 0x2935, 0x28ad, 0x29bd,
		0x2803, 0x2913, 0x288b, 0x299b, 0x2847, 0x2957, 0x28cf, 0x0005,
		0x2800, 0x28f0, 0x2868, 0x2978, 0x2824, 0x2934, 0x28ac, 0x29bc,
		0x2802, 0x2912, 0x288a, 0x299a, 0x2846, 0x2956, 0x28ce, 0x0005,
		0x2801, 0x28f1, 0x2869, 0x2979, 0x2825, 0x2935, 0x28ad, 0x29bd,
		0x2803, 0x2913, 0x288b, 0x299b, 0x2847, 0x2957, 0x28cf, 0x0005,
		0x2800, 0x28f0, 0x2868, 0x2978, 0x2824, 0x2934, 0x28ac, 0x29bc,
		0x2802, 0x2912, 0x288a, 0x299a, 0x2846, 0x2956, 0x28ce, 0x0005,
		0x2801, 0x28f1, 0x2869, 0x2979, 0x2825, 0x2935, 0x28ad, 0x29bd,
		0x2803, 0x2913, 0x288b, 0x299b, 0x2847, 0x2957, 0x28cf, 0x0005,
		0x2800, 0x28f0, 0x2868, 0x2978, 0x2824, 0x2934, 0x28ac, 0x29bc,
		0x2802, 0x2912, 0x288a, 0x299a, 0x2846, 0x2956, 0x28ce, 0x0005,
		0x2801, 0x28f1, 0x2869, 0x2979, 0x2825, 0x2935, 0x28ad, 0x29bd,
		0x2803, 0x2913, 0x288b, 0x299b, 0x2847, 0x2957, 0x28cf, 0x0005,
		0x2800, 0x28f0, 0x2868, 0x2978, 0x2824, 0x2934, 0x28ac, 0x29bc,
		0x2802, 0x2912, 0x288a, 0x299a, 0x2846, 0x2956, 0x28ce, 0x0005,
		0x2801, 0x28f1, 0x2869, 0x2979, 0x2825, 0x2935, 0x28ad, 0x29bd,
		0x2803, 0x2913, 0x288b, 0x299b, 0x2847, 0x2957, 0x28cf, 0x0005,
		0x2800, 0x28f0, 0x2868, 0x2978, 0x2824, 0x2934, 0x28ac, 0x29bc,
		0x2802, 0x2912, 0x288a, 0x299a, 0x2846, 0x2956, 0x28ce, 0x0005,
		0x2801, 0x28f1, 0x2869, 0x2979, 0x2825, 0x2935, 0x28ad, 0x29bd,
		0x2803, 0x2913, 0x288b, 0x299b, 0x2847, 0x2957, 0x28cf, 0x0005,
		0x2800, 0x28f0, 0x2868, 0x2978, 0x2824, 0x2934, 0x28ac, 0x29bc,
		0x2802, 0x2912, 0x288a, 0x299a, 0x2846, 0x2956, 0x28ce, 0x0005,
		0x2801, 0x28f1, 0x2869, 0x2979, 0x2825, 0x2935, 0x28ad, 0x29bd,
		0x2803, 0x2913, 0x288b, 0x299b, 0x2847, 0x2957, 0x28cf, 0x0005,
		0x2800, 0x28f0, 0x2868, 0x2978, 0x2824, 0x2934, 0x28ac, 0x29bc,
		0x2802, 0x2912, 0x288a, 0x299a, 0x2846, 0x2956, 0x28ce, 0x0005,
		0x2801, 0x28f1, 0x2869, 0x2979, 0x2825, 0x2935, 0x28ad, 0x29bd,
		0x2803, 0x2913, 0x288b, 0x299b, 0x2847, 0x2957, 0x28cf, 0x0005,
		0x2800, 0x28f0, 0x2868, 0x2978, 0x2824, 0x2934, 0x28ac, 0x29bc,
		0x2802, 0x2912, 0x288a, 0x299a, 0x2846, 0x2956, 0x28ce, 0x0005,
		0x2801, 0x28f1, 0x2869, 0x2979, 0x2825, 0x2935, 0x28ad, 0x29bd,
		0x2803, 0x2913, 0x288b, 0x299b, 0x2847, 0x2957, 0x28cf, 0x0005,
		0x2800, 0x28f0, 0x2868, 0x2978, 0x2824, 0x2934, 0x28ac, 0x29bc,
		0x2802, 0x2912, 0x288a, 0x299a, 0x2846, 0x2956, 0x28ce, 0x0005,
		0x2801, 0x28f1, 0x2869, 0x2979, 0x2825, 0x2935, 0x28ad, 0x29bd,
		0x2803, 0x2913, 0x288b, 0x299b, 0x2847, 0x2957, 0x28cf, 0x0005,
		0x2800, 0x28f0, 0x2868, 0x2978, 0x2824, 0x2934, 0x28ac, 0x29bc,
		0x2802, 0x2912, 0x288a, 0x299a, 0x2846, 0x2956, 0x28ce, 0x0005,
		0x2801, 0x28f1, 0x2869, 0x2979, 0x2825, 0x2935, 0x28ad, 0x29bd,
		0x2803, 0x2913, 0x288b, 0x299b, 0x2847, 0x2957, 0x28cf, 0x0005	},

	.long_code_lookup = {
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
		0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000	}
};

#endif
