#ifndef SC_
#  define SC_(x) static_cast<T>(BOOST_JOIN(x, L))
#endif
   static const boost::array<boost::array<T, 3>, 414> trig_data = {{
      { SC_(-3.9774532318115234375000000000000000000000e+00), SC_(7.0773544860026243860279929113278325110375e-02), SC_(9.9749240866682582129171337066426038082437e-01) }, 
      { SC_(-3.9617328643798828125000000000000000000000e+00), SC_(1.1993037621708977961146677085715171980751e-01), SC_(9.9278230486870952597534166945986069243176e-01) }, 
      { SC_(-3.9047842025756835937500000000000000000000e+00), SC_(2.9468823519354637105911947101495882286179e-01), SC_(9.5559345123253806128916838776381320091963e-01) }, 
      { SC_(-3.8916873931884765625000000000000000000000e+00), SC_(3.3374547909601862041893513083013201963857e-01), SC_(9.4266322469001038147288152092736823391568e-01) }, 
      { SC_(-3.8578090667724609375000000000000000000000e+00), SC_(4.3199709903403737307912472091970588030864e-01), SC_(9.0187499490016691899377344383391047319671e-01) }, 
      { SC_(-3.7453374862670898437500000000000000000000e+00), SC_(7.1738805664233213419617848590715510878805e-01), SC_(6.9667379467505311174160335392136633824863e-01) }, 
      { SC_(-3.7244319915771484375000000000000000000000e+00), SC_(7.6156366259470177260070281063647817588426e-01), SC_(6.4809010779006898537856851402643268133964e-01) }, 
      { SC_(-3.7143068313598632812500000000000000000000e+00), SC_(7.8179011765786965192070724412252980346206e-01), SC_(6.2354166816059239705031197761170482474277e-01) }, 
      { SC_(-3.7084703445434570312500000000000000000000e+00), SC_(7.9309123554739645631663479916579239803262e-01), SC_(6.0910285838920844088315459958697481264632e-01) }, 
      { SC_(-3.6306295394897460937500000000000000000000e+00), SC_(9.1696736941200755880066612020982424508209e-01), SC_(3.9896220802680404308672276469459511697767e-01) }, 
      { SC_(-3.5902690887451171875000000000000000000000e+00), SC_(9.6005749263309399424762040094854912358485e-01), SC_(2.7980280706071672819250833169767675946625e-01) }, 
      { SC_(-3.5683994293212890625000000000000000000000e+00), SC_(9.7700131832151631709443635682201094394830e-01), SC_(2.1323326194104695723693260957232796074504e-01) }, 
      { SC_(-3.4592370986938476562500000000000000000000e+00), SC_(9.9181146279384676289373069342215326327259e-01), SC_(-1.2771069755791767012021871220455601680871e-01) }, 
      { SC_(-3.3931655883789062500000000000000000000000e+00), SC_(9.4420293088917725164777488803566691613860e-01), SC_(-3.2936427447476383305860665908806457784788e-01) }, 
      { SC_(-3.2229461669921875000000000000000000000000e+00), SC_(6.4452819092715720460681805414890459455338e-01), SC_(-7.6458054585515448444199304174329276576484e-01) }, 
      { SC_(-3.2196769714355468750000000000000000000000e+00), SC_(6.3664172619341055705211898635086791126371e-01), SC_(-7.7115971916943020671267760720429588807288e-01) }, 
      { SC_(-3.1211061477661132812500000000000000000000e+00), SC_(3.7135335780369037404310918499389657193681e-01), SC_(-9.2849161743546414936854741692037249771494e-01) }, 
      { SC_(-3.1002845764160156250000000000000000000000e+00), SC_(3.0986713733563102476788873073830476308206e-01), SC_(-9.5077986789762286248285770175256182955887e-01) }, 
      { SC_(-3.0480184555053710937500000000000000000000e+00), SC_(1.5028291058010493207025880578034599707430e-01), SC_(-9.8864303304457275939138181401436526701454e-01) }, 
      { SC_(-2.9985380172729492187500000000000000000000e+00), SC_(-4.5929380467587678038943727972886926572694e-03), SC_(-9.9998945240442343165400505621385600628710e-01) }, 
      { SC_(-2.9928274154663085937500000000000000000000e+00), SC_(-2.2531432037793477675469226940100283743575e-02), SC_(-9.9974613506145963677579891828378701312519e-01) }, 
      { SC_(-2.9841060638427734375000000000000000000000e+00), SC_(-4.9911526865301578262897706703502998396013e-02), SC_(-9.9875364304015145795419227904280421041712e-01) }, 
      { SC_(-2.9607505798339843750000000000000000000000e+00), SC_(-1.2299346485981660064237020203833067995992e-01), SC_(-9.9240748062566369342250467688663564344568e-01) }, 
      { SC_(-2.9161844253540039062500000000000000000000e+00), SC_(-2.6028213071204756629425186005846465917215e-01), SC_(-9.6553260557683736103737209395477391945707e-01) }, 
      { SC_(-2.8910045623779296875000000000000000000000e+00), SC_(-3.3576688840249427771925848349727492747208e-01), SC_(-9.4194511339701049149409128507465051072874e-01) }, 
      { SC_(-2.8649091720581054687500000000000000000000e+00), SC_(-4.1177440566510667850464728538235996067571e-01), SC_(-9.1128581621747419851467502037941438628419e-01) }, 
      { SC_(-2.8070888519287109375000000000000000000000e+00), SC_(-5.6962394780317258349095500647963019767726e-01), SC_(-8.2190544352080338079904161219679275645723e-01) }, 
      { SC_(-2.8056478500366210937500000000000000000000e+00), SC_(-5.7333889774547421097781817548901513478394e-01), SC_(-8.1931831929476876961507584991747574097795e-01) }, 
      { SC_(-2.7644929885864257812500000000000000000000e+00), SC_(-6.7418976093170810969556332422484681604555e-01), SC_(-7.3855816714382508099719065401369284800331e-01) }, 
      { SC_(-2.7390956878662109375000000000000000000000e+00), SC_(-7.3091046787338668451145170450133524796388e-01), SC_(-6.8247336061791230280379473053114594954268e-01) }, 
      { SC_(-2.7355394363403320312500000000000000000000e+00), SC_(-7.3848948635740579707953709312462199704324e-01), SC_(-6.7426499133469398680589790058582600474355e-01) }, 
      { SC_(-2.6991062164306640625000000000000000000000e+00), SC_(-8.1066424743162907541066892533920219267801e-01), SC_(-5.8551129616439550978746461056239261291598e-01) }, 
      { SC_(-2.6305065155029296875000000000000000000000e+00), SC_(-9.1712149632570388738239981145670570715552e-01), SC_(-3.9860777837029461434452340017415559695465e-01) }, 
      { SC_(-2.6090793609619140625000000000000000000000e+00), SC_(-9.4185655472943839830579836290050447836428e-01), SC_(-3.3601522333547986304807314632542163159655e-01) }, 
      { SC_(-2.5050191879272460937500000000000000000000e+00), SC_(-9.9987568381768953436701127766269045040788e-01), SC_(-1.5767590497845478262656414731631988934965e-02) }, 
      { SC_(-2.4929447174072265625000000000000000000000e+00), SC_(-9.9975437034566987067580804393808517747219e-01), SC_(2.2163009153388271557271132253243652915113e-02) }, 
      { SC_(-2.4272384643554687500000000000000000000000e+00), SC_(-9.7398753115843827533170990651639503684643e-01), SC_(2.2660160888195438795075340941984049712659e-01) }, 
      { SC_(-2.3354558944702148437500000000000000000000e+00), SC_(-8.6934023639191873450982490002851733105284e-01), SC_(4.9421407647905260119880040102899169441924e-01) }, 
      { SC_(-2.3183279037475585937500000000000000000000e+00), SC_(-8.4150156664834359869540818771524073982051e-01), SC_(5.4025467450859075039160413881361295523246e-01) }, 
      { SC_(-2.3046054840087890625000000000000000000000e+00), SC_(-8.1743642279419458878430396216469861867532e-01), SC_(5.7601883188783919247059390170720375367970e-01) }, 
      { SC_(-2.2620973587036132812500000000000000000000e+00), SC_(-7.3346328340507778941301945165878879887661e-01), SC_(6.7972907242271353377593468076196477559511e-01) }, 
      { SC_(-2.2317276000976562500000000000000000000000e+00), SC_(-6.6537326993316934952514665105248864416333e-01), SC_(7.4651082487693489365391928166376502681137e-01) }, 
      { SC_(-2.2095050811767578125000000000000000000000e+00), SC_(-6.1167775393828157540960701817140835841373e-01), SC_(7.9110702521025501171584436651855140566145e-01) }, 
      { SC_(-2.1587514877319335937500000000000000000000e+00), SC_(-4.7831282457156194256147826366717615468415e-01), SC_(8.7818952501744986937643074486430914859891e-01) }, 
      { SC_(-2.0518007278442382812500000000000000000000e+00), SC_(-1.6201943644875820325965658806034453314425e-01), SC_(9.8678756691236579534545882522215038541766e-01) }, 
      { SC_(-1.9913291931152343750000000000000000000000e+00), SC_(2.7236774521824119247640639457167240403283e-02), SC_(9.9962901024012268934784446000199714742073e-01) }, 
      { SC_(-1.9808664321899414062500000000000000000000e+00), SC_(6.0073684468702575262797776910860329709958e-02), SC_(9.9819394530038838689681575445113488209634e-01) }, 
      { SC_(-1.9657425880432128906250000000000000000000e+00), SC_(1.0741519398297458068845667640105099725089e-01), SC_(9.9421425060275611673890046532660283866692e-01) }, 
      { SC_(-1.9592390060424804687500000000000000000000e+00), SC_(1.2770475450980803702535188445773082653842e-01), SC_(9.9181222803290223591996402565002586050197e-01) }, 
      { SC_(-1.9399342536926269531250000000000000000000e+00), SC_(1.8758420016848789064877165024139046518307e-01), SC_(9.8224852651818657111887581810958489845723e-01) }, 
      { SC_(-1.8726687431335449218750000000000000000000e+00), SC_(3.8943947239907955191806267942993095630447e-01), SC_(9.2105206005823935504113082081651078396843e-01) }, 
      { SC_(-1.8622159957885742187500000000000000000000e+00), SC_(4.1946983932693600433549716080531291905775e-01), SC_(9.0776927349136162127391594039572935545573e-01) }, 
      { SC_(-1.8571534156799316406250000000000000000000e+00), SC_(4.3385385318065783138522312391833924596257e-01), SC_(9.0098325960047459614595694068784152978597e-01) }, 
      { SC_(-1.8542351722717285156250000000000000000000e+00), SC_(4.4209565798070871752154886197372379282014e-01), SC_(8.9696790867600398251070757116939705415091e-01) }, 
      { SC_(-1.8153147697448730468750000000000000000000e+00), SC_(5.4819603791581527487211750854339931561457e-01), SC_(8.3634986938087221868046812319445417842653e-01) }, 
      { SC_(-1.7951345443725585937500000000000000000000e+00), SC_(6.0008215809974023581434137516121683653367e-01), SC_(7.9993837483293571774722252288759286003132e-01) }, 
      { SC_(-1.7917995452880859375000000000000000000000e+00), SC_(6.0843019022618795009788527140260807985237e-01), SC_(7.9360739892047676462942185706066696498359e-01) }, 
      { SC_(-1.7846164703369140625000000000000000000000e+00), SC_(6.2618253814748614262259811608337148376852e-01), SC_(7.7967648991050901236982422793142962643534e-01) }, 
      { SC_(-1.7720141410827636718750000000000000000000e+00), SC_(6.5655224709393941166212925616015192588965e-01), SC_(7.5428054915654475424462469532824344031256e-01) }, 
      { SC_(-1.7132878303527832031250000000000000000000e+00), SC_(7.8378224352958754678835476318536431268280e-01), SC_(6.2103574351862093135376998317963401489884e-01) }, 
      { SC_(-1.6237645149230957031250000000000000000000e+00), SC_(9.2535791354740309366987559846725871864256e-01), SC_(3.7909462121638822065656109832689999162915e-01) }, 
      { SC_(-1.6114730834960937500000000000000000000000e+00), SC_(9.3930307831262708058711419944650941883676e-01), SC_(3.4308851200881494653328085763181866157541e-01) }, 
      { SC_(-1.6098384857177734375000000000000000000000e+00), SC_(9.4105252753749888823550959379536266333425e-01), SC_(3.3826046238850454312441253682427645862925e-01) }, 
      { SC_(-1.6013464927673339843750000000000000000000e+00), SC_(9.4974082848623693795720143987094090825340e-01), SC_(3.1303731200333974188394551215433704440959e-01) }, 
      { SC_(-1.5846953392028808593750000000000000000000e+00), SC_(9.6480953481970116774592198724118779033893e-01), SC_(2.6294973192797105413764821926664215930415e-01) }, 
      { SC_(-1.5605530738830566406250000000000000000000e+00), SC_(9.8196018693108534535704372647626920244478e-01), SC_(1.8908778723721932992809652230019128825755e-01) }, 
      { SC_(-1.5501422882080078125000000000000000000000e+00), SC_(9.8761831389905454265970551125211297990428e-01), SC_(1.5687595753074646574707218589497119732404e-01) }, 
      { SC_(-1.5346636772155761718750000000000000000000e+00), SC_(9.9407634470097495678440728067370155376700e-01), SC_(1.0868404163421794168841468106351872585391e-01) }, 
      { SC_(-1.4992690086364746093750000000000000000000e+00), SC_(9.9999736309762923085701730064921942403709e-01), SC_(-2.2964750789599640237311476160375647471297e-03) }, 
      { SC_(-1.4964137077331542968750000000000000000000e+00), SC_(9.9993653175125560985405906117690348917772e-01), SC_(-1.1266431079546957052007973149282697740413e-02) }, 
      { SC_(-1.4920530319213867187500000000000000000000e+00), SC_(9.9968836220097897515421090351123102378467e-01), SC_(-2.4963543016252140624424353620834798422298e-02) }, 
      { SC_(-1.4675965309143066406250000000000000000000e+00), SC_(9.9482300571031767470545247345135328742037e-01), SC_(-1.0162276964090895700009449059085389237392e-01) }, 
      { SC_(-1.4632043838500976562500000000000000000000e+00), SC_(9.9332612227433410103147521255561275226122e-01), SC_(-1.1533956306244036792882185538617246505954e-01) }, 
      { SC_(-1.4580922126770019531250000000000000000000e+00), SC_(9.9134570296562978571638835022392061422831e-01), SC_(-1.3127717703996121305882839967483442627768e-01) }, 
      { SC_(-1.4324545860290527343750000000000000000000e+00), SC_(9.7756989934671019373169629057504194866857e-01), SC_(-2.1061123401011376426045773413676664246694e-01) }, 
      { SC_(-1.4035444259643554687500000000000000000000e+00), SC_(9.5443843267148546358442745434898986199886e-01), SC_(-2.9840790579272243805349313736867888474031e-01) }, 
      { SC_(-1.3695478439331054687500000000000000000000e+00), SC_(9.1718955527685559847290691336960412613353e-01), SC_(-3.9845115094706885361124346266024345228301e-01) }, 
      { SC_(-1.3404140472412109375000000000000000000000e+00), SC_(8.7693258816614827774022620024409696405300e-01), SC_(-4.8061339537326732482363246144236277866115e-01) }, 
      { SC_(-1.3152532577514648437500000000000000000000e+00), SC_(8.3624391727841423335265182846988227041057e-01), SC_(-5.4835764863349238490645223769948911756242e-01) }, 
      { SC_(-1.3045396804809570312500000000000000000000e+00), SC_(8.1731732617615535993972423284173533764089e-01), SC_(-5.7618780647655159179892641392622477267985e-01) }, 
      { SC_(-1.3030190467834472656250000000000000000000e+00), SC_(8.1455543925394655461272630731962754843475e-01), SC_(-5.8008571468517493943647864535875052887067e-01) }, 
      { SC_(-1.2769141197204589843750000000000000000000e+00), SC_(7.6429757445950074729137528619490067922475e-01), SC_(-6.4486372023499966079783788886350455652073e-01) }, 
      { SC_(-1.2525095939636230468750000000000000000000e+00), SC_(7.1265966298712510976727080775393286775191e-01), SC_(-7.0150994629518779252029019684147294502654e-01) }, 
      { SC_(-1.2464723587036132812500000000000000000000e+00), SC_(6.9922707000180267922218828300011329952476e-01), SC_(-7.1489964650760188760883502369405946194110e-01) }, 
      { SC_(-1.2001299858093261718750000000000000000000e+00), SC_(5.8811557544674391201807840618842034354183e-01), SC_(-8.0877689749209903443231961711462521827931e-01) }, 
      { SC_(-1.1867241859436035156250000000000000000000e+00), SC_(5.5354205085637434626546678256347217807178e-01), SC_(-8.3282122807582124987721942593859613012643e-01) }, 
      { SC_(-1.1779007911682128906250000000000000000000e+00), SC_(5.3024695959373754552303103234918288901743e-01), SC_(-8.4784324131386296186416330083981392494060e-01) }, 
      { SC_(-1.1591639518737792968750000000000000000000e+00), SC_(4.7945037568626914655477387944495383191264e-01), SC_(-8.7756899287423286625851917347611833444398e-01) }, 
      { SC_(-1.1523027420043945312500000000000000000000e+00), SC_(4.6042435215361969792282407073518388211496e-01), SC_(-8.8769894443100448931565479086756325580560e-01) }, 
      { SC_(-1.1492390632629394531250000000000000000000e+00), SC_(4.5185920599520057053276864006142326681945e-01), SC_(-8.9208926568891461848383857895451033722071e-01) }, 
      { SC_(-1.1158638000488281250000000000000000000000e+00), SC_(3.5601206097761990452977868423235984965323e-01), SC_(-9.3448136013430864303645437573928108578348e-01) }, 
      { SC_(-1.1096482276916503906250000000000000000000e+00), SC_(3.3769792246460164629474039532696958192046e-01), SC_(-9.4125454217394982766035943636083719035312e-01) }, 
      { SC_(-9.9043321609497070312500000000000000000000e-01), SC_(-3.0050413471461695540024564936224673638671e-02), SC_(-9.9954838434674796559331625390455526383528e-01) }, 
      { SC_(-9.5643329620361328125000000000000000000000e-01), SC_(-1.3644190756047759246554033570694178287822e-01), SC_(-9.9064807366756540198038975645604554633439e-01) }, 
      { SC_(-9.4753241539001464843750000000000000000000e-01), SC_(-1.6408639175605146962710766285506114119657e-01), SC_(-9.8644597218523813297671237540079338723261e-01) }, 
      { SC_(-9.2857670783996582031250000000000000000000e-01), SC_(-2.2250476444283772218673996900250402304488e-01), SC_(-9.7493160262668544704751699124979976907538e-01) }, 
      { SC_(-9.0163278579711914062500000000000000000000e-01), SC_(-3.0413446038713361333822828583779165454320e-01), SC_(-9.5262911461125680576016437426221838649931e-01) }, 
      { SC_(-8.9230823516845703125000000000000000000000e-01), SC_(-3.3190624435937551944026868331727174806526e-01), SC_(-9.4331237930775323106949286771312588863657e-01) }, 
      { SC_(-8.9144158363342285156250000000000000000000e-01), SC_(-3.3447333562412172678970446066984069391038e-01), SC_(-9.4240521420271950010600975154227611905033e-01) }, 
      { SC_(-8.8600707054138183593750000000000000000000e-01), SC_(-3.5051351674611297773892844232778109262325e-01), SC_(-9.3655767285217004788794178878222072725075e-01) }, 
      { SC_(-8.6218380928039550781250000000000000000000e-01), SC_(-4.1956162799502567154232074130357340928086e-01), SC_(-9.0772685336182695234250043188704963864421e-01) }, 
      { SC_(-8.6143636703491210937500000000000000000000e-01), SC_(-4.2169195637805975119285327312737312233359e-01), SC_(-9.0673915429193006252439409007275140629891e-01) }, 
      { SC_(-8.4073424339294433593750000000000000000000e-01), SC_(-4.7973102317517230304261884461240907857963e-01), SC_(-8.7741560585808040133569859818046730577292e-01) }, 
      { SC_(-8.1188225746154785156250000000000000000000e-01), SC_(-5.5718281505427452448329165251503905335361e-01), SC_(-8.3038985459132032336863115402098077691083e-01) }, 
      { SC_(-8.1009173393249511718750000000000000000000e-01), SC_(-5.6184499762684714941201079089906385083574e-01), SC_(-8.2724252709933144553839916770138677027624e-01) }, 
      { SC_(-8.0491924285888671875000000000000000000000e-01), SC_(-5.7521280306139546882966748568272662288193e-01), SC_(-8.1800380878957542391952832960065838706905e-01) }, 
      { SC_(-7.9234766960144042968750000000000000000000e-01), SC_(-6.0706271013464043353366890549457782214483e-01), SC_(-7.9465392842669916991006928492234100087798e-01) }, 
      { SC_(-7.8027653694152832031250000000000000000000e-01), SC_(-6.3675435324887283807387968443064323927454e-01), SC_(-7.7106672449186241936833965977451467018076e-01) }, 
      { SC_(-7.7507114410400390625000000000000000000000e-01), SC_(-6.4927807697058951839952462358015400901876e-01), SC_(-7.6055110200786194960603336466921442346690e-01) }, 
      { SC_(-7.6733183860778808593750000000000000000000e-01), SC_(-6.6757619728604092071453324386955542070385e-01), SC_(-7.4454148361062392239556769325773825702564e-01) }, 
      { SC_(-7.6633191108703613281250000000000000000000e-01), SC_(-6.6991177608595655051935696217363478255092e-01), SC_(-7.4244071296054287243575657514607719322578e-01) }, 
      { SC_(-7.4602651596069335937500000000000000000000e-01), SC_(-7.1587832171963837887635431025898472882166e-01), SC_(-6.9822505576058635858412171583081361890022e-01) }, 
      { SC_(-7.3379826545715332031250000000000000000000e-01), SC_(-7.4216668263972512989393331690792412278837e-01), SC_(-6.7021534985372091334416257663429154500405e-01) }, 
      { SC_(-7.3160219192504882812500000000000000000000e-01), SC_(-7.4677291162121044357118392614751604427866e-01), SC_(-6.6507910692546929235444637559841943883780e-01) }, 
      { SC_(-7.3015069961547851562500000000000000000000e-01), SC_(-7.4979789619975431859407425681834155793237e-01), SC_(-6.6166692138448514733500503346266288770938e-01) }, 
      { SC_(-7.2904610633850097656250000000000000000000e-01), SC_(-7.5208948172407025528198849071078367555793e-01), SC_(-6.5906100740372995720833771145494015491300e-01) }, 
      { SC_(-7.1622729301452636718750000000000000000000e-01), SC_(-7.7801389255273384361671151573028725535226e-01), SC_(-6.2824707161668737687554440833515396883131e-01) }, 
      { SC_(-6.9866776466369628906250000000000000000000e-01), SC_(-8.1146998296245819360997140966632402827569e-01), SC_(-5.8439410225541103503434006174383390019441e-01) }, 
      { SC_(-6.8477392196655273437500000000000000000000e-01), SC_(-8.3619709128502380052191736485373876087540e-01), SC_(-5.4842905149751647086512164896949709113631e-01) }, 
      { SC_(-6.2590980529785156250000000000000000000000e-01), SC_(-9.2278195998532618711876533583518132364809e-01), SC_(-3.8532253285480186101800088717832245706995e-01) }, 
      { SC_(-6.2329864501953125000000000000000000000000e-01), SC_(-9.2591175509822434191601497566806265470122e-01), SC_(-3.7773988639131799973972992658851246182229e-01) }, 
      { SC_(-6.2323617935180664062500000000000000000000e-01), SC_(-9.2598586557992392706129793388845742526082e-01), SC_(-3.7755817663798390607300611567844842451415e-01) }, 
      { SC_(-6.1467909812927246093750000000000000000000e-01), SC_(-9.3579990857438429046804091642616234433613e-01), SC_(-3.5253160299776529867139565344134595722872e-01) }, 
      { SC_(-5.7615137100219726562500000000000000000000e-01), SC_(-9.7151915689578774494869132124118403599895e-01), SC_(-2.3696102587661489811187077067744115225597e-01) }, 
      { SC_(-5.5793190002441406250000000000000000000000e-01), SC_(-9.8348395008111562039809975749836686477222e-01), SC_(-1.8099535887100994524708884360178660464816e-01) }, 
      { SC_(-5.5482411384582519531250000000000000000000e-01), SC_(-9.8520417735968563737667037948690963338512e-01), SC_(-1.7138473944031623193691095714321985250340e-01) }, 
      { SC_(-4.9999964237213134765625000000000000000000e-01), SC_(-9.9999999999936885018591827017238645533757e-01), SC_(1.1235210848769422650061483788666125928854e-06) }, 
      { SC_(-4.9999952316284179687500000000000000000000e-01), SC_(-9.9999999999887795588607701655175253650385e-01), SC_(1.4980281131690112288542788461553611206918e-06) }, 
      { SC_(-4.9999821186065673828125000000000000000000e-01), SC_(-9.9999999998422125464799658931844288845336e-01), SC_(5.6176054243563469200773000686083983167359e-06) }, 
      { SC_(-4.9999654293060302734375000000000000000000e-01), SC_(-9.9999999994102255626249187643087021470265e-01), SC_(1.0860703820265881289283604713526279435907e-05) }, 
      { SC_(-4.9999570846557617187500000000000000000000e-01), SC_(-9.9999999990911442677359804232502397526992e-01), SC_(1.3482253018117696189242608854023945230621e-05) }, 
      { SC_(-4.9998497962951660156250000000000000000000e-01), SC_(-9.9999999888665172816630219829107169151373e-01), SC_(4.7187885547329319055657947640681604270190e-05) }, 
      { SC_(-4.9997079372406005859375000000000000000000e-01), SC_(-9.9999999579058138181322106904089468671587e-01), SC_(9.1754221802892278460653643781329654613072e-05) }, 
      { SC_(-4.9996280670166015625000000000000000000000e-01), SC_(-9.9999999317348361865817975703384517397171e-01), SC_(1.1684619256134242811309917534624539649780e-04) }, 
      { SC_(-4.9990046024322509765625000000000000000000e-01), SC_(-9.9999995110517494031950602050113650140195e-01), SC_(3.1271336352745955257438826774914611254936e-04) }, 
      { SC_(-4.9984037876129150390625000000000000000000e-01), SC_(-9.9999987426647421111465519406831701300167e-01), SC_(5.0146488986653011967572952923949622011443e-04) }, 
      { SC_(-4.9973213672637939453125000000000000000000e-01), SC_(-9.9999964592434404522856871599729444235462e-01), SC_(8.4151719325274199816762458443766057922935e-04) }, 
      { SC_(-4.9924457073211669921875000000000000000000e-01), SC_(-9.9999718384107642318385022061791039708231e-01), SC_(2.3732488104711122888975542758864726809649e-03) }, 
      { SC_(-4.9875152111053466796875000000000000000000e-01), SC_(-9.9999230813595346585340014254398865673184e-01), SC_(3.9222020509269767647741982519122733031044e-03) }, 
      { SC_(-4.9767899513244628906250000000000000000000e-01), SC_(-9.9997341602450135387659472378982173884007e-01), SC_(7.2915872270404153887073312687679308998549e-03) }, 
      { SC_(-4.9395751953125000000000000000000000000000e-01), SC_(-9.9981982803353944005287225251112677857740e-01), SC_(1.8981872167508178357172130364879478736824e-02) }, 
      { SC_(-4.9004507064819335937500000000000000000000e-01), SC_(-9.9951099790928556667259410781791684423868e-01), SC_(3.1269235014373849691623925611210178296109e-02) }, 
      { SC_(-4.8443067073822021484375000000000000000000e-01), SC_(-9.9880402260967383350104913506749804650695e-01), SC_(4.8892989464075129410881960564239566356159e-02) }, 
      { SC_(-4.7376620769500732421875000000000000000000e-01), SC_(-9.9660573252044816164949064267275474142215e-01), SC_(8.2322620872886047296075858223633591242075e-02) }, 
      { SC_(-4.6941399574279785156250000000000000000000e-01), SC_(-9.9538702545592996217602751881533829549808e-01), SC_(9.5940969111197941216571259124451089062976e-02) }, 
      { SC_(-4.4300353527069091796875000000000000000000e-01), SC_(-9.8401160380662433728097415173321874784567e-01), SC_(1.7810436146797465795076411723785630146946e-01) }, 
      { SC_(-4.3761062622070312500000000000000000000000e-01), SC_(-9.8085302335197751084221022090414475952815e-01), SC_(1.9474944565077729586702134297397558908793e-01) }, 
      { SC_(-4.3531036376953125000000000000000000000000e-01), SC_(-9.7942007014122136260839903400131683850089e-01), SC_(2.0183242109375051114419382469832542056336e-01) }, 
      { SC_(-4.3109190464019775390625000000000000000000e-01), SC_(-9.7665931966111574917260180371016061375191e-01), SC_(2.1479425811479813351335297938533711689703e-01) }, 
      { SC_(-4.0594112873077392578125000000000000000000e-01), SC_(-9.5665820818914221120054446914475175799646e-01), SC_(2.9121310531008016143287012525633902034398e-01) }, 
      { SC_(-4.0504586696624755859375000000000000000000e-01), SC_(-9.5583537471139125170268184218278625567668e-01), SC_(2.9390259687579195874776972222125494935775e-01) }, 
      { SC_(-3.8366591930389404296875000000000000000000e-01), SC_(-9.3395435745292818950500377706390876384678e-01), SC_(3.5739230293150975861604557304399827529203e-01) }, 
      { SC_(-3.7719452381134033203125000000000000000000e-01), SC_(-9.2649588941063948114565037576896742966883e-01), SC_(3.7630488557177688673822323825781455055180e-01) }, 
      { SC_(-3.6507534980773925781250000000000000000000e-01), SC_(-9.1150066412057132064413124408292341887704e-01), SC_(4.1129860114976980837100694121882074588146e-01) }, 
      { SC_(-3.5173749923706054687500000000000000000000e-01), SC_(-8.9347135185389664492608804389344290514666e-01), SC_(4.4912018816389273992181501551656719931300e-01) }, 
      { SC_(-3.3608675003051757812500000000000000000000e-01), SC_(-8.7031800693966543320350860436306967348037e-01), SC_(4.9249016923850213119131115646030866731998e-01) }, 
      { SC_(-3.1295490264892578125000000000000000000000e-01), SC_(-8.3226273881953944562958166501881716256484e-01), SC_(5.5438139721007871269431006077170037182167e-01) }, 
      { SC_(-3.1164932250976562500000000000000000000000e-01), SC_(-8.2998189329385915216798094773699578116858e-01), SC_(5.5779033409009607911385726274888562536223e-01) }, 
      { SC_(-2.7741205692291259765625000000000000000000e-01), SC_(-7.6530540944132762347540484149979476997405e-01), SC_(6.4366732888957622161629948954256886761344e-01) }, 
      { SC_(-2.5403821468353271484375000000000000000000e-01), SC_(-7.1602029608992953382227635470280008247722e-01), SC_(6.9807946222997396038983310091489535537995e-01) }, 
      { SC_(-2.4502253532409667968750000000000000000000e-01), SC_(-6.9596363589832268991123680045799720786793e-01), SC_(7.1807702755845554542015683130542500947272e-01) }, 
      { SC_(-2.4487495422363281250000000000000000000000e-01), SC_(-6.9563063208909269862653780978177888009691e-01), SC_(7.1839962673941399778860782267787561799555e-01) }, 
      { SC_(-2.1765518188476562500000000000000000000000e-01), SC_(-6.3173078874875549667469135116007165277939e-01), SC_(7.7518785500475641518666097320612357319575e-01) }, 
      { SC_(-2.1368932723999023437500000000000000000000e-01), SC_(-6.2202386486692776449886525877848335545149e-01), SC_(7.8299828322673223309743602710693663069307e-01) }, 
      { SC_(-2.1059674024581909179687500000000000000000e-01), SC_(-6.1438729101183683608883217648211171284716e-01), SC_(7.8900459861976502657750920268897367146832e-01) }, 
      { SC_(-2.0252293348312377929687500000000000000000e-01), SC_(-5.9417901474396082934749814580791914920940e-01), SC_(8.0433282814883042629694480486807704619554e-01) }, 
      { SC_(-2.0193052291870117187500000000000000000000e-01), SC_(-5.9268103254443150996575881860022625766732e-01), SC_(8.0543726860759709778836038114230871482678e-01) }, 
      { SC_(-1.6804337501525878906250000000000000000000e-01), SC_(-5.0374092089163148946618998984850108614529e-01), SC_(8.6385478213600870567222096491880130749985e-01) }, 
      { SC_(-1.5647745132446289062500000000000000000000e-01), SC_(-4.7202680156423389647157458723053975980849e-01), SC_(8.8158419825053543001708103931554730229580e-01) }, 
      { SC_(-1.1699485778808593750000000000000000000000e-01), SC_(-3.5933032028529929530469713105447105627606e-01), SC_(9.3321043764183447208457988309703282077611e-01) }, 
      { SC_(-1.0096526145935058593750000000000000000000e-01), SC_(-3.1189960836173143727543603824518581260722e-01), SC_(9.5011506371796808223989920232214847699279e-01) }, 
      { SC_(-9.9448680877685546875000000000000000000000e-02), SC_(-3.0736928268291189056245817195475556312613e-01), SC_(9.5159031314058267928741366405400232279103e-01) }, 
      { SC_(-8.1884860992431640625000000000000000000000e-02), SC_(-2.5442092538066790930565147205451845021489e-01), SC_(9.6709358012988826356985074356311455428879e-01) }, 
      { SC_(-7.5287580490112304687500000000000000000000e-02), SC_(-2.3432376652499588701838575690686786656742e-01), SC_(9.7215861485744146902547330728628459024868e-01) }, 
      { SC_(-5.8497428894042968750000000000000000000000e-02), SC_(-1.8274239020840994778024779066783021334913e-01), SC_(9.8316083059737344076524840489058370319455e-01) }, 
      { SC_(-4.9724340438842773437500000000000000000000e-02), SC_(-1.5557905845488543885312766674675549571917e-01), SC_(9.8782344402746958678323909764838465267242e-01) }, 
      { SC_(-4.0942430496215820312500000000000000000000e-02), SC_(-1.2827006640310072052424311269660830382159e-01), SC_(9.9173927524573923762600689524600414466974e-01) }, 
      { SC_(-3.7643790245056152343750000000000000000000e-02), SC_(-1.1798598463919036806396859702888971422609e-01), SC_(9.9301526042086620820691531388584889622794e-01) }, 
      { SC_(-2.9248714447021484375000000000000000000000e-02), SC_(-9.1758295000034082027002552701767092555474e-02), SC_(9.9578130897234997276990448032172635803157e-01) }, 
      { SC_(-1.3087511062622070312500000000000000000000e-02), SC_(-4.1104045293708104407288819751202788055321e-02), SC_(9.9915487160924796875744234149878204112867e-01) }, 
      { SC_(4.3266379634587792679667472839355468750000e-07), SC_(1.3592534040740619706779610326861001654897e-06), SC_(9.9999999999907621509175611071696794110532e-01) }, 
      { SC_(5.4143765737535431981086730957031250000000e-07), SC_(1.7009765667864604184755441004045916835365e-06), SC_(9.9999999999855333935962062666627307461693e-01) }, 
      { SC_(1.8175046534452121704816818237304687500000e-06), SC_(5.7098592670977157072989540126815453407108e-06), SC_(9.9999999998369875357483630310113587760776e-01) }, 
      { SC_(3.5000011848751455545425415039062500000000e-06), SC_(1.0995578009737763119439960636873651974923e-05), SC_(9.9999999993954863211405848208762186048286e-01) }, 
      { SC_(4.2991123336832970380783081054687500000000e-06), SC_(1.3506059724046102849155020671161951640821e-05), SC_(9.9999999990879317536109051164750827168428e-01) }, 
      { SC_(1.5021269064163789153099060058593750000000e-05), SC_(4.7190708522057261760788416021622962926434e-05), SC_(9.9999999888651851397319555483294537971851e-01) }, 
      { SC_(2.9195798560976982116699218750000000000000e-05), SC_(9.1721306146247273447149831706287604114171e-05), SC_(9.9999999579360099056629475651173461585519e-01) }, 
      { SC_(3.7263002013787627220153808593750000000000e-05), SC_(1.1706517310983505348361202316956281869806e-04), SC_(9.9999999314787259890635099603563404925619e-01) }, 
      { SC_(9.9631288321688771247863769531250000000000e-05), SC_(3.1300091834834262754869101448379462507049e-04), SC_(9.9999995101521135679231652819210798878235e-01) }, 
      { SC_(1.5968835214152932167053222656250000000000e-04), SC_(5.0167573290818330889234395033921802084588e-04), SC_(9.9999987416072158775656565179455465157942e-01) }, 
      { SC_(2.6795419398695230484008789062500000000000e-04), SC_(8.4180282790654826545804640080269836983800e-04), SC_(9.9999964568393669433278420176617458678238e-01) }, 
      { SC_(7.5547862797975540161132812500000000000000e-04), SC_(2.3734038793507862338875984277728034790946e-03), SC_(9.9999718347304632927889439367053946747070e-01) }, 
      { SC_(1.2485333718359470367431640625000000000000e-03), SC_(3.9223732110256432324523442725717533074569e-03), SC_(9.9999230746460916382277793622681636974491e-01) }, 
      { SC_(2.3210579529404640197753906250000000000000e-03), SC_(7.2917539952678701084037683250818457156304e-03), SC_(9.9997341480845004265309260924926091312942e-01) }, 
      { SC_(6.0425046831369400024414062500000000000000e-03), SC_(1.8981948225542250316374610856647080308219e-02), SC_(9.9981982658955250056570779062314008929280e-01) }, 
      { SC_(7.3254108428955078125000000000000000000000e-03), SC_(2.3011425547596871441918317481228034288225e-02), SC_(9.9973520208816664736064961441785617136149e-01) }, 
      { SC_(1.4650821685791015625000000000000000000000e-02), SC_(4.6010664340327118254150114416531299714854e-02), SC_(9.9894094858853481205059395189866449477251e-01) }, 
      { SC_(1.5569385141134262084960937500000000000000e-02), SC_(4.8893164804289854476092991237587407645619e-02), SC_(9.9880401402648585462910686304657318353997e-01) }, 
      { SC_(2.9301643371582031250000000000000000000000e-02), SC_(9.1923873362630087657532412256452714370418e-02), SC_(9.9576603753392350101603503508172913724917e-01) }, 
      { SC_(3.0586041510105133056640625000000000000000e-02), SC_(9.5941085604771316768085451064236775366471e-02), SC_(9.9538701422762088493914326074304340289989e-01) }, 
      { SC_(4.7656536102294921875000000000000000000000e-02), SC_(1.4915872325264163418011625059388154411208e-01), SC_(9.8881326613149859371779592440701520332605e-01) }, 
      { SC_(6.2389418482780456542968750000000000000000e-02), SC_(1.9474958340190698798717487882189992143950e-01), SC_(9.8085299600132928084969236920300869776998e-01) }, 
      { SC_(9.3762993812561035156250000000000000000000e-02), SC_(2.9032374052866115624523246250757006188327e-01), SC_(9.5692848514685078924747011591238920416053e-01) }, 
      { SC_(9.4441175460815429687500000000000000000000e-02), SC_(2.9236188363443580531878426206975893994594e-01), SC_(9.5630775851591030434790501957749321532648e-01) }, 
      { SC_(1.2280553579330444335937500000000000000000e-01), SC_(3.7630505906138142353083651135748077379234e-01), SC_(9.2649581894621102417883022496077542353252e-01) }, 
      { SC_(1.8752598762512207031250000000000000000000e-01), SC_(5.5563811445251817951602041289839833731771e-01), SC_(8.3142425137089326314567378101647774469588e-01) }, 
      { SC_(1.8888235092163085937500000000000000000000e-01), SC_(5.5917587522787340988979924197133119827530e-01), SC_(8.2904905799544923445249768934109054593180e-01) }, 
      { SC_(2.1897172927856445312500000000000000000000e-01), SC_(6.3493159620419406345635238222941832237409e-01), SC_(7.7256835823219828445022501968227276225912e-01) }, 
      { SC_(2.4596184492111206054687500000000000000000e-01), SC_(6.9807959630727836454168797571135865708139e-01), SC_(7.1602016537208452474905408469995390715758e-01) }, 
      { SC_(2.4638032913208007812500000000000000000000e-01), SC_(6.9902034940513949391212656719293343534798e-01), SC_(7.1510177675455169993189720867072602090539e-01) }, 
      { SC_(2.6471853256225585937500000000000000000000e-01), SC_(7.3903569051771558856508127536694662611127e-01), SC_(6.7366627356652144137630156031564192215880e-01) }, 
      { SC_(2.7952671051025390625000000000000000000000e-01), SC_(7.6956461663549903043783586896628844814904e-01), SC_(6.3856894758722601773867312847833637212198e-01) }, 
      { SC_(2.8940320014953613281250000000000000000000e-01), SC_(7.8900448357357190506916947609555659455861e-01), SC_(6.1438743875570983374750220189262336594174e-01) }, 
      { SC_(3.1148135662078857421875000000000000000000e-01), SC_(8.2968744272649370343629160126126543723377e-01), SC_(5.5822822159218287824183611128426782583130e-01) }, 
      { SC_(3.5747027397155761718750000000000000000000e-01), SC_(9.0141468847825773753334585012065896365062e-01), SC_(4.3295676388716409247982544083589690990554e-01) }, 
      { SC_(3.6271905899047851562500000000000000000000e-01), SC_(9.0843107791662533445839388702373430912235e-01), SC_(4.1803465965783051394311430789283080754524e-01) }, 
      { SC_(3.7505197525024414062500000000000000000000e-01), SC_(9.2394200668363927173078929094288575918620e-01), SC_(3.8253257153530061632247453438154414410921e-01) }, 
      { SC_(3.7772417068481445312500000000000000000000e-01), SC_(9.2712075330418120688363763383575284802393e-01), SC_(3.7476273666506328862476711475996433628584e-01) }, 
      { SC_(3.7776470184326171875000000000000000000000e-01), SC_(9.2716846522289861500880897655062060342404e-01), SC_(3.7464468112628349643869883931576769920045e-01) }, 
      { SC_(3.9778900146484375000000000000000000000000e-01), SC_(9.4888714091948151577078679209168934604460e-01), SC_(3.1561557914281105333039532216374512397784e-01) }, 
      { SC_(4.5167791843414306640625000000000000000000e-01), SC_(9.8849923302968707504021021497429203528978e-01), SC_(1.5122587840617891145460860258123470441026e-01) }, 
      { SC_(4.9245977401733398437500000000000000000000e-01), SC_(9.9971944490156151620025264430521645555204e-01), SC_(2.3686103219265674984235773857091406676367e-02) }, 
      { SC_(5.0000023841857910156250000000000000000000e-01), SC_(9.9999999999971948897151921479471958445202e-01), SC_(-7.4901405658471572113049856673065563715596e-07) }, 
      { SC_(5.0000047683715820312500000000000000000000e-01), SC_(9.9999999999887795588607701655175253650385e-01), SC_(-1.4980281131690112288542788461553611206918e-06) }, 
      { SC_(5.0000166893005371093750000000000000000000e-01), SC_(9.9999999998625495960447237002460255656405e-01), SC_(-5.2430983960694780971372955823540956317309e-06) }, 
      { SC_(5.0000333786010742187500000000000000000000e-01), SC_(9.9999999994501983841826733236935959894956e-01), SC_(-1.0486196791994822995771188961609302512444e-05) }, 
      { SC_(5.0000429153442382812500000000000000000000e-01), SC_(9.9999999990911442677359804232502397526992e-01), SC_(-1.3482253018117696189242608854023945230621e-05) }, 
      { SC_(5.0001502037048339843750000000000000000000e-01), SC_(9.9999999888665172816630219829107169151373e-01), SC_(-4.7187885547329319055657947640681604270190e-05) }, 
      { SC_(5.0002908706665039062500000000000000000000e-01), SC_(9.9999999582487385499707753413380040254131e-01), SC_(-9.1379714776169916676504893028080336305096e-05) }, 
      { SC_(5.0003719329833984375000000000000000000000e-01), SC_(9.9999999317348361865817975703384517397171e-01), SC_(-1.1684619256134242811309917534624539649780e-04) }, 
      { SC_(5.0009965896606445312500000000000000000000e-01), SC_(9.9999995098799146008382980990445170109932e-01), SC_(-3.1308787053741855117950880780497680759570e-04) }, 
      { SC_(5.0015950202941894531250000000000000000000e-01), SC_(9.9999987445420620906323428975050136718796e-01), SC_(-5.0109038288529065804374478551472874530555e-04) }, 
      { SC_(5.0026798248291015625000000000000000000000e-01), SC_(9.9999964560911981419424672295679903989178e-01), SC_(-8.4189170014837154687588880235168421682168e-04) }, 
      { SC_(5.0075531005859375000000000000000000000000e-01), SC_(9.9999718472980465503219274828524949063826e-01), SC_(-2.3728743044973247838253172935228172467424e-03) }, 
      { SC_(5.0124835968017578125000000000000000000000e-01), SC_(9.9999230960477557309064944107279076437187e-01), SC_(-3.9218275467790664715140272043149223642317e-03) }, 
      { SC_(5.0232100486755371093750000000000000000000e-01), SC_(9.9997341602450135387659472378982173884007e-01), SC_(-7.2915872270404153887073312687679308998549e-03) }, 
      { SC_(5.0604248046875000000000000000000000000000e-01), SC_(9.9981982803353944005287225251112677857740e-01), SC_(-1.8981872167508178357172130364879478736824e-02) }, 
      { SC_(5.1556921005249023437500000000000000000000e-01), SC_(9.9880404092037197813676426019506317879923e-01), SC_(-4.8892615404945346627001407931204211546893e-02) }, 
      { SC_(5.2943706512451171875000000000000000000000e-01), SC_(9.9572683932746093128653255090270967383525e-01), SC_(-9.2347503717993389411862662274142639701433e-02) }, 
      { SC_(5.3058600425720214843750000000000000000000e-01), SC_(9.9538702545592996217602751881533829549808e-01), SC_(-9.5940969111197941216571259124451089062976e-02) }, 
      { SC_(5.4257297515869140625000000000000000000000e-01), SC_(9.9106920215903227605044870658837494754048e-01), SC_(-1.3334855279251895255487521999710771239693e-01) }, 
      { SC_(5.5058908462524414062500000000000000000000e-01), SC_(9.8739714174382138915453149696987252659096e-01), SC_(-1.5826207529326756656343050232717560850220e-01) }, 
      { SC_(5.5905342102050781250000000000000000000000e-01), SC_(9.8284013469059532781132507838476113550991e-01), SC_(-1.8445939835468518211677992486313122667274e-01) }, 
      { SC_(5.6238937377929687500000000000000000000000e-01), SC_(9.8085302335197751084221022090414475952815e-01), SC_(-1.9474944565077729586702134297397558908793e-01) }, 
      { SC_(5.8441448211669921875000000000000000000000e-01), SC_(9.6504116991468772916767426390583385372372e-01), SC_(-2.6209834102811640519063851794361108683088e-01) }, 
      { SC_(5.8525204658508300781250000000000000000000e-01), SC_(9.6434817410492476051162649965646040210442e-01), SC_(-2.6463673044476974412739688083545564527880e-01) }, 
      { SC_(5.9003734588623046875000000000000000000000e-01), SC_(9.6026094627939906631076805397577486803884e-01), SC_(-2.7910377111496193552779011382411954822304e-01) }, 
      { SC_(5.9585714340209960937500000000000000000000e-01), SC_(9.5499776001978266636141692238567105276142e-01), SC_(-2.9661301110571261633642980390047730394775e-01) }, 
      { SC_(5.9621167182922363281250000000000000000000e-01), SC_(9.5466680494688901845095401803252261966867e-01), SC_(-2.9767648804112587677259085827521093667614e-01) }, 
      { SC_(6.0056090354919433593750000000000000000000e-01), SC_(9.5051051175135299491269304678178521337214e-01), SC_(-3.1069239940845196054659054661322750736300e-01) }, 
      { SC_(6.2191152572631835937500000000000000000000e-01), SC_(9.2754905951703243153883926482789755369534e-01), SC_(-3.7370140779647676895907118856367789499671e-01) }, 
      { SC_(6.2280535697937011718750000000000000000000e-01), SC_(9.2649603033939893545876174372382758963708e-01), SC_(-3.7630453859252822903265212796461262419442e-01) }, 
      { SC_(6.2296271324157714843750000000000000000000e-01), SC_(9.2630989126115333502365248057892626137266e-01), SC_(-3.7676250523605753878823975673132999953907e-01) }, 
      { SC_(6.2944722175598144531250000000000000000000e-01), SC_(9.1844293010181728336965244165781907892841e-01), SC_(-3.9555351615930349591296252540630912224997e-01) }, 
      { SC_(6.4765357971191406250000000000000000000000e-01), SC_(8.9432887529239949134050237395878828178190e-01), SC_(-4.4741017290427333178127297787300468277305e-01) }, 
      { SC_(6.5442204475402832031250000000000000000000e-01), SC_(8.8461379298050095431129585172737434703837e-01), SC_(-4.6632439060020375534346915352785901416480e-01) }, 
      { SC_(6.7001700401306152343750000000000000000000e-01), SC_(8.6071483294500626682601333005079288538374e-01), SC_(-5.0908739558984364499817281559875753702128e-01) }, 
      { SC_(6.8211269378662109375000000000000000000000e-01), SC_(8.4075295212816897851858279003682255858268e-01), SC_(-5.4141894452241768771763399670177979476562e-01) }, 
      { SC_(6.8214178085327148437500000000000000000000e-01), SC_(8.4070347390919447310792480017212755537161e-01), SC_(-5.4149577002688799196360063837903210919181e-01) }, 
      { SC_(6.9825863838195800781250000000000000000000e-01), SC_(8.1222043896020003746691461356380945497683e-01), SC_(-5.8335063086903400132164783701410063178688e-01) }, 
      { SC_(7.1494054794311523437500000000000000000000e-01), SC_(7.8054717288780521994787822312700291432230e-01), SC_(-6.2509688120870888550628828335146370413120e-01) }, 
      { SC_(7.2543811798095703125000000000000000000000e-01), SC_(7.5951135295894516997773320112577896731863e-01), SC_(-6.5049404664952361883049988945867404359846e-01) }, 
      { SC_(7.4259090423583984375000000000000000000000e-01), SC_(7.2337262491951824535987456504101927606464e-01), SC_(-6.9045785209312086671882625196264011240830e-01) }, 
      { SC_(7.4596190452575683593750000000000000000000e-01), SC_(7.1602003465421440923170662542985439906727e-01), SC_(-6.9807973038455829131535264868499063685839e-01) }, 
      { SC_(7.5602865219116210937500000000000000000000e-01), SC_(6.9358846545678693591707541926346337018824e-01), SC_(-7.2037146014073841524897653425660582431075e-01) }, 
      { SC_(7.5686120986938476562500000000000000000000e-01), SC_(6.9170192246211764852258989945441407825294e-01), SC_(-7.2218311421841661919026098389544915612558e-01) }, 
      { SC_(7.7931451797485351562500000000000000000000e-01), SC_(6.3908181476044847352855857953085128291641e-01), SC_(-7.6913876124044861687290402084436955287024e-01) }, 
      { SC_(7.8940320014953613281250000000000000000000e-01), SC_(6.1438743875570983374750220189262336594174e-01), SC_(-7.8900448357357190506916947609555659455861e-01) }, 
      { SC_(8.1158375740051269531250000000000000000000e-01), SC_(5.5796128098493693774956426339216825838485e-01), SC_(-8.2986698266749247144544102221617571588371e-01) }, 
      { SC_(8.2418441772460937500000000000000000000000e-01), SC_(5.2468150511589894314211461443671616291377e-01), SC_(-8.5129860694665471251751588130558874493180e-01) }, 
      { SC_(8.2675170898437500000000000000000000000000e-01), SC_(5.1779846465489559902121104745771879513585e-01), SC_(-8.5550263003747266858935406540162582481289e-01) }, 
      { SC_(8.3147096633911132812500000000000000000000e-01), SC_(5.0505835326047255373670879218520777551429e-01), SC_(-8.6308519846062689441236636551061290362475e-01) }, 
      { SC_(8.3745932579040527343750000000000000000000e-01), SC_(4.8873272661607996842476388746265342403592e-01), SC_(-8.7243356304902211093269502281486894853917e-01) }, 
      { SC_(8.6291933059692382812500000000000000000000e-01), SC_(4.1746301773122492119427397853204125415748e-01), SC_(-9.0869391371723129146579397894656016506109e-01) }, 
      { SC_(8.6798644065856933593750000000000000000000e-01), SC_(4.0294542272514587374578878976636209227899e-01), SC_(-9.1522400881142398889062108323306662423626e-01) }, 
      { SC_(9.0335583686828613281250000000000000000000e-01), SC_(2.9897332963749714086784291370982450399144e-01), SC_(-9.5426146740055918163080761149229731108190e-01) }, 
      { SC_(9.1433382034301757812500000000000000000000e-01), SC_(2.6589115917260285325419947744388835665930e-01), SC_(-9.6400305573885478922438156284639798679215e-01) }, 
      { SC_(9.1501355171203613281250000000000000000000e-01), SC_(2.6383198469828112364614953143053397663241e-01), SC_(-9.6456865170404846359354329855525529190741e-01) }, 
      { SC_(9.1898488998413085937500000000000000000000e-01), SC_(2.5177748924368554685468194066253512457048e-01), SC_(-9.6778514966398704745696155605927835685840e-01) }, 
      { SC_(9.2835760116577148437500000000000000000000e-01), SC_(2.2317579991567085324239821780226102833604e-01), SC_(-9.7477821186770503727532894707931011073242e-01) }, 
      { SC_(9.2977690696716308593750000000000000000000e-01), SC_(2.1882717603870224476267802834508622324807e-01), SC_(-9.7576363276509071694966752194335069876463e-01) }, 
      { SC_(9.3538975715637207031250000000000000000000e-01), SC_(2.0158812621802170363247911522191766491009e-01), SC_(-9.7947038105698068659823110207787727736299e-01) }, 
      { SC_(9.3773555755615234375000000000000000000000e-01), SC_(1.9436446216493438141119284520433099703994e-01), SC_(-9.8092938372103819416138438587083223662527e-01) }, 
      { SC_(9.4118547439575195312500000000000000000000e-01), SC_(1.8372171307544965759678633944069390248341e-01), SC_(-9.8297829688382344788580833680059302401033e-01) }, 
      { SC_(9.6221923828125000000000000000000000000000e-01), SC_(1.1841327668470778668387435536216132833424e-01), SC_(-9.9296439810538566926151547176977895353997e-01) }, 
      { SC_(9.6258902549743652343750000000000000000000e-01), SC_(1.1725964964250181903523453754202053343958e-01), SC_(-9.9310129119124486365547911348556621357001e-01) }, 
      { SC_(9.7252988815307617187500000000000000000000e-01), SC_(8.6192819213782638491394074725634953259967e-02), SC_(-9.9627847408040498244177144451542073663079e-01) }, 
      { SC_(9.8576259613037109375000000000000000000000e-01), SC_(4.4713211010059575627083311486688378377719e-02), SC_(-9.9899986424482054938737871374409867247170e-01) }, 
      { SC_(9.9292254447937011718750000000000000000000e-01), SC_(2.2232650296677842324843007375331301285692e-02), SC_(-9.9975282408242570097649527615446008373997e-01) }, 
      { SC_(1.0187463760375976562500000000000000000000e+00), SC_(-5.8859438379765556734934765870123841904071e-02), SC_(-9.9826628036492276451542505637106691321082e-01) }, 
      { SC_(1.0309605598449707031250000000000000000000e+00), SC_(-9.7112175410510007601029626216402477139612e-02), SC_(-9.9527344252071668318741827285042372117656e-01) }, 
      { SC_(1.0549998283386230468750000000000000000000e+00), SC_(-1.7192856901965710009702375791535159035281e-01), SC_(-9.8510941887429591504244360987374814133690e-01) }, 
      { SC_(1.0588741302490234375000000000000000000000e+00), SC_(-1.8390577599379700926290144073364960721909e-01), SC_(-9.8294387711411039423820236376193318593662e-01) }, 
      { SC_(1.0620670318603515625000000000000000000000e+00), SC_(-1.9375606847029838950934029494285126550764e-01), SC_(-9.8104973672639708950242367913096020108473e-01) }, 
      { SC_(1.1181068420410156250000000000000000000000e+00), SC_(-3.6258819984772992518820799231180569098655e-01), SC_(-9.3194946071725513105727048061861964248840e-01) }, 
      { SC_(1.1516876220703125000000000000000000000000e+00), SC_(-4.5870805413268734595578922345765392547914e-01), SC_(-8.8858703629627839370537670785560916829442e-01) }, 
      { SC_(1.1688289642333984375000000000000000000000e+00), SC_(-5.0587137931694450781374785885405701636209e-01), SC_(-8.6260891926061838537701835838343488118058e-01) }, 
      { SC_(1.1705040931701660156250000000000000000000e+00), SC_(-5.1040389561102171232839945628556712931483e-01), SC_(-8.5993480179900455684911569359172121555871e-01) }, 
      { SC_(1.1758999824523925781250000000000000000000e+00), SC_(-5.2490720932590276678010742901107605851182e-01), SC_(-8.5115945720980677796658745692560098624430e-01) }, 
      { SC_(1.1807994842529296875000000000000000000000e+00), SC_(-5.3794576213351449656101999511619722673799e-01), SC_(-8.4297945230153281643104823762844171586293e-01) }, 
      { SC_(1.1891193389892578125000000000000000000000e+00), SC_(-5.5979296377411862460909241358429271770818e-01), SC_(-8.2863251065172932498700305887284525583529e-01) }, 
      { SC_(1.1917142868041992187500000000000000000000e+00), SC_(-5.6652952239735693608437886823307669062541e-01), SC_(-8.2404144328560480824870475299437311924647e-01) }, 
      { SC_(1.1924233436584472656250000000000000000000e+00), SC_(-5.6836372349206491783475196579351205405939e-01), SC_(-8.2277741693500288574227483911028922710579e-01) }, 
      { SC_(1.2011218070983886718750000000000000000000e+00), SC_(-5.9063278311796687106048524371800444570677e-01), SC_(-8.0694046589963791967243971905935296149430e-01) }, 
      { SC_(1.2301239967346191406250000000000000000000e+00), SC_(-6.6160401882998010552323897836460784408889e-01), SC_(-7.4985340051774075418915199622139603735114e-01) }, 
      { SC_(1.2407841682434082031250000000000000000000e+00), SC_(-6.8634086817568556959518811234659813992437e-01), SC_(-7.2728000981179608062625166204271349414266e-01) }, 
      { SC_(1.2438230514526367187500000000000000000000e+00), SC_(-6.9325277868362607621169323879677758902929e-01), SC_(-7.2069451562186274391997419869940171414363e-01) }, 
      { SC_(1.2459254264831542968750000000000000000000e+00), SC_(-6.9799767051298434555785079496813786840958e-01), SC_(-7.1610002929649943133658617561573135501453e-01) }, 
      { SC_(1.2588944435119628906250000000000000000000e+00), SC_(-7.2658666078685446797639705399050314266709e-01), SC_(-6.8707483170802325627138896477699785637260e-01) }, 
      { SC_(1.2876129150390625000000000000000000000000e+00), SC_(-7.8553649455508062633354679972242824219306e-01), SC_(-6.1881533248790449269207655071666186653763e-01) }, 
      { SC_(1.2938313484191894531250000000000000000000e+00), SC_(-7.9747487466040254374645405690408172736269e-01), SC_(-6.0335215611231162056565909258670606785548e-01) }, 
      { SC_(1.3088440895080566406250000000000000000000e+00), SC_(-8.2503397585633381997831954679820574155855e-01), SC_(-5.6508312546269719893450093013241323592207e-01) }, 
      { SC_(1.3400340080261230468750000000000000000000e+00), SC_(-8.7635814529904118601081188137331304659294e-01), SC_(-4.8166004730310009054647063509859160339415e-01) }, 
      { SC_(1.3965172767639160156250000000000000000000e+00), SC_(-9.4761861094431282961431221933813838997905e-01), SC_(-3.1940408292940006983994341565252068119454e-01) }, 
      { SC_(1.4298810958862304687500000000000000000000e+00), SC_(-9.7583520681688387292687121126643613552707e-01), SC_(-2.1850777820629058444501355498206934411146e-01) }, 
      { SC_(1.4376215934753417968750000000000000000000e+00), SC_(-9.8085973279310576031594549102020869559287e-01), SC_(-1.9471565059089926259012117189023181391949e-01) }, 
      { SC_(1.4385581016540527343750000000000000000000e+00), SC_(-9.8142836496821321166874402715990365296483e-01), SC_(-1.9182899790130710683882258658552936374515e-01) }, 
      { SC_(1.4508762359619140625000000000000000000000e+00), SC_(-9.8811522692503775605543313370282778446190e-01), SC_(-1.5371499054705478001378349197656046515917e-01) }, 
      { SC_(1.4897150993347167968750000000000000000000e+00), SC_(-9.9947804607370551197887811849305109310236e-01), SC_(-3.2305346565047120856279614352034044384070e-02) }, 
      { SC_(1.5137224197387695312500000000000000000000e+00), SC_(-9.9907089694911573167196250726697255573847e-01), SC_(4.3096900924421168880110982366284253390397e-02) }, 
      { SC_(1.5586290359497070312500000000000000000000e+00), SC_(-9.8308519067229837832374427345689099932686e-01), SC_(1.8314886808498364717878744696881145525833e-01) }, 
      { SC_(1.5618629455566406250000000000000000000000e+00), SC_(-9.8117376294453180844784495147829791557972e-01), SC_(1.9312702273184791024579531762719304741666e-01) }, 
      { SC_(1.5926136970520019531250000000000000000000e+00), SC_(-9.5797049469247552574933165756478309905204e-01), SC_(2.8686674833213716432580156340994598821683e-01) }, 
      { SC_(1.6231675148010253906250000000000000000000e+00), SC_(-9.2606728939251711681210496158583747975198e-01), SC_(3.7735841784329650003568967393481656850060e-01) }, 
      { SC_(1.6461939811706542968750000000000000000000e+00), SC_(-8.9637104909034604680551976122265063246194e-01), SC_(4.4330457064265921856241299960951200122656e-01) }, 
      { SC_(1.6483688354492187500000000000000000000000e+00), SC_(-8.9332126879167771624500856665660808282240e-01), SC_(4.4941863637862982231027837081647791310565e-01) }, 
      { SC_(1.6535034179687500000000000000000000000000e+00), SC_(-8.8595589668325703520032148888999797693220e-01), SC_(4.6376950000206566612805157359154672321704e-01) }, 
      { SC_(1.6629419326782226562500000000000000000000e+00), SC_(-8.7181677811602472074961654135259089550517e-01), SC_(4.8983211960363942589644354461303346098625e-01) }, 
      { SC_(1.6749186515808105468750000000000000000000e+00), SC_(-8.5277366812066057977271247471049374587809e-01), SC_(5.2228064386882407763197582250756453836773e-01) }, 
      { SC_(1.6834988594055175781250000000000000000000e+00), SC_(-8.3838723382722668560374055777113354384596e-01), SC_(5.4507508304409872951355341198113988021048e-01) }, 
      { SC_(1.6856307983398437500000000000000000000000e+00), SC_(-8.3471771610393185875563541949577581755489e-01), SC_(5.5067806786019344468370501442029345114677e-01) }, 
      { SC_(1.7359728813171386718750000000000000000000e+00), SC_(-7.3757065023744374233427634183853418901443e-01), SC_(6.7526997260970699051610458511780887005999e-01) }, 
      { SC_(1.8008880615234375000000000000000000000000e+00), SC_(-5.8552586884378704483186312375203910002446e-01), SC_(8.1065372195206030005809439123205755456281e-01) }, 
      { SC_(1.8067116737365722656250000000000000000000e+00), SC_(-5.7059745650701822420377393113337032791919e-01), SC_(8.2122989633093694745423101092710740880020e-01) }, 
      { SC_(1.8156375885009765625000000000000000000000e+00), SC_(-5.4734755935044899228708043061162129375783e-01), SC_(8.3690540043251406773419700909631405067317e-01) }, 
      { SC_(1.8286676406860351562500000000000000000000e+00), SC_(-5.1263977987267075841172991479886096563513e-01), SC_(8.5860378294769914714655242739801923124408e-01) }, 
      { SC_(1.8300271034240722656250000000000000000000e+00), SC_(-5.0896812351364833785558141036682842052014e-01), SC_(8.6078536770033191005955516536698911049468e-01) }, 
      { SC_(1.8379697799682617187500000000000000000000e+00), SC_(-4.8733303021944621194189301241962776135329e-01), SC_(8.7321619182029161751058004085362886491765e-01) }, 
      { SC_(1.8595538139343261718750000000000000000000e+00), SC_(-4.2704720047850023183941099428684119119884e-01), SC_(9.0422933405385363629189377994064683541132e-01) }, 
      { SC_(1.8623895645141601562500000000000000000000e+00), SC_(-4.1897478653374016114126977981026475973993e-01), SC_(9.0799786797602496580256760833692713013283e-01) }, 
      { SC_(1.8707795143127441406250000000000000000000e+00), SC_(-3.9489919760665687393025430422008659421735e-01), SC_(9.1872445473581390125453764320348506116740e-01) }, 
      { SC_(1.8754711151123046875000000000000000000000e+00), SC_(-3.8131562417744025560344214560627023472595e-01), SC_(9.2444491169467158271243610711145803084185e-01) }, 
      { SC_(1.8823709487915039062500000000000000000000e+00), SC_(-3.6118891323896796352020720713034429892546e-01), SC_(9.3249266428924430063283450002888042014372e-01) }, 
      { SC_(1.9244384765625000000000000000000000000000e+00), SC_(-2.3516033602183473124666530333004541872733e-01), SC_(9.7195659180958167856656353854565326670155e-01) }, 
      { SC_(1.9251780509948730468750000000000000000000e+00), SC_(-2.3290141892920310132381860854941592667200e-01), SC_(9.7250034913143544604665034305341085814036e-01) }, 
      { SC_(1.9450597763061523437500000000000000000000e+00), SC_(-1.7174410080599115791878144870207974985610e-01), SC_(9.8514159583196036484926931679731931240176e-01) }, 
      { SC_(1.9715251922607421875000000000000000000000e+00), SC_(-8.9336983457999063135421037776092465621819e-02), SC_(9.9600145752233977428946067619207389818633e-01) }, 
      { SC_(1.9762740135192871093750000000000000000000e+00), SC_(-7.4468384593612646979323710048902730053452e-02), SC_(9.9722337502488267463745494415864182250959e-01) }, 
      { SC_(1.9858450889587402343750000000000000000000e+00), SC_(-4.4454309841881304935514957598710154439302e-02), SC_(9.9901141852157126129931083219525854429922e-01) }, 
      { SC_(2.0101366043090820312500000000000000000000e+00), SC_(3.1839699504165833040696856658722832974329e-02), SC_(9.9949298823727844199208912730644750424459e-01) }, 
      { SC_(2.0298328399658203125000000000000000000000e+00), SC_(9.3585482259217083943722897191362156410110e-02), SC_(9.9561124818390323590034941369048956558885e-01) }, 
      { SC_(2.0374927520751953125000000000000000000000e+00), SC_(1.1751478523147387713056326549682140475556e-01), SC_(9.9307113302723716274685474269250180568265e-01) }, 
      { SC_(2.0576019287109375000000000000000000000000e+00), SC_(1.7997574747222497593604700115767608457458e-01), SC_(9.8367104782127948181350173374240863950588e-01) }, 
      { SC_(2.0619211196899414062500000000000000000000e+00), SC_(1.9330633826298797623479689902574087695130e-01), SC_(9.8113845077407667087335299035355773609465e-01) }, 
      { SC_(2.0938491821289062500000000000000000000000e+00), SC_(2.9058283605133940895196038349312146948496e-01), SC_(9.5684983952152095341562328895723679333882e-01) }, 
      { SC_(2.1099996566772460937500000000000000000000e+00), SC_(3.3873690542968736401825168823472196107080e-01), SC_(9.4088113430970600963774297340199588888937e-01) }, 
      { SC_(2.1241340637207031250000000000000000000000e+00), SC_(3.8016867992385600615924107152723370088748e-01), SC_(9.2491717186186608460538995036149309316917e-01) }, 
      { SC_(2.1913366317749023437500000000000000000000e+00), SC_(5.6555144959238575986298051424240553269548e-01), SC_(8.2471301545686251460782779794050924721187e-01) }, 
      { SC_(2.2311811447143554687500000000000000000000e+00), SC_(6.6409072491386110431221716662816882524076e-01), SC_(7.4765199731117047178284416396271497606128e-01) }, 
      { SC_(2.2333374023437500000000000000000000000000e+00), SC_(6.6914010605322762479513348096476764142743e-01), SC_(7.4313627180421982616113592960004612209391e-01) }, 
      { SC_(2.3376579284667968750000000000000000000000e+00), SC_(8.7273832759493568470846274321787972310865e-01), SC_(4.8818829517594409686222473986620551444155e-01) }, 
      { SC_(2.3487806320190429687500000000000000000000e+00), SC_(8.8926086331413399471006293915063362270572e-01), SC_(4.5740039022480194691544525128597463590371e-01) }, 
      { SC_(2.3517999649047851562500000000000000000000e+00), SC_(8.9355947075069965065490920875297802645467e-01), SC_(4.4894484319538579092387834408066355537480e-01) }, 
      { SC_(2.3615989685058593750000000000000000000000e+00), SC_(9.0695444786248140377665977375260325926430e-01), SC_(4.2122871400518448160209063533603877707564e-01) }, 
      { SC_(2.3782386779785156250000000000000000000000e+00), SC_(9.2772529803464095872112040596631014126442e-01), SC_(3.7326367541797662646784647430196344006644e-01) }, 
      { SC_(2.3834285736083984375000000000000000000000e+00), SC_(9.3368761060044476921711548941438701101882e-01), SC_(3.5808860050444529143114408314332600529137e-01) }, 
      { SC_(2.3848466873168945312500000000000000000000e+00), SC_(9.3527367258872278243326920322096935824487e-01), SC_(3.5392535563647114688274932903268095238901e-01) }, 
      { SC_(2.4022436141967773437500000000000000000000e+00), SC_(9.5321098636962397016546799166066099108051e-01), SC_(3.0230583101264941654714139135400476632369e-01) }, 
      { SC_(2.4602479934692382812500000000000000000000e+00), SC_(9.9221204663172793548513469089523554880392e-01), SC_(1.2456024453603865992531044703030770606574e-01) }, 
      { SC_(2.4654035568237304687500000000000000000000e+00), SC_(9.9409927898231117057693037228057679279072e-01), SC_(1.0847406845347446518601579735745017867104e-01) }, 
      { SC_(2.4778757095336914062500000000000000000000e+00), SC_(9.9758546444116512850079355986107988926734e-01), SC_(6.9449558211012868711701254228877324083109e-02) }, 
      { SC_(2.5142784118652343750000000000000000000000e+00), SC_(9.9899409553284540256810561838332194308754e-01), SC_(-4.4841912208470250395938017310281418704264e-02) }, 
      { SC_(2.5177888870239257812500000000000000000000e+00), SC_(9.9843881536284522828028348393187866490264e-01), SC_(-5.5856351266783040410469084720035114498915e-02) }, 
      { SC_(2.5667257308959960937500000000000000000000e+00), SC_(9.7810900468525295373101076810092704203059e-01), SC_(-2.0809318814805979949884912276499020086767e-01) }, 
      { SC_(2.5699672698974609375000000000000000000000e+00), SC_(9.7593918728194691849177504208954489276700e-01), SC_(-2.1804289194434414788759075840709254785401e-01) }, 
      { SC_(2.5752258300781250000000000000000000000000e+00), SC_(9.7220405411897038987674094446364189936340e-01), SC_(-2.3413516855576842900574271401719103593906e-01) }, 
      { SC_(2.5876626968383789062500000000000000000000e+00), SC_(9.6231637014349867626162609217881995793322e-01), SC_(-2.7193235142924949432619478747905995121995e-01) }, 
      { SC_(2.6466283798217773437500000000000000000000e+00), SC_(8.9576523522202297669181665064798731910975e-01), SC_(-4.4452743826183985868905617130138276115396e-01) }, 
      { SC_(2.6800680160522460937500000000000000000000e+00), SC_(8.4421341143838647980035969183880613057605e-01), SC_(-5.3600719766395076638299146307861267938126e-01) }, 
      { SC_(2.7257375717163085937500000000000000000000e+00), SC_(7.5889905709718526647373257399273129873174e-01), SC_(-6.5120827784742043835386853758773237310974e-01) }, 
      { SC_(2.7877416610717773437500000000000000000000e+00), SC_(6.1849755782607421827792609946160229156438e-01), SC_(-7.8578672104024637717491890266603742140897e-01) }, 
      { SC_(2.7930345535278320312500000000000000000000e+00), SC_(6.0534650679100039131411264058534198908238e-01), SC_(-7.9596206361605784580057896592926540608297e-01) }, 
      { SC_(2.9794301986694335937500000000000000000000e+00), SC_(6.4576969325134380719184170853709332046455e-02), SC_(-9.9791272916662439637917978556650177608583e-01) }, 
      { SC_(3.0140590667724609375000000000000000000000e+00), SC_(-4.4153501845982175189175058527762162423716e-02), SC_(-9.9902475858946401221242382128074456077456e-01) }, 
      { SC_(3.0274448394775390625000000000000000000000e+00), SC_(-8.6113718924577264256191741572510303127778e-02), SC_(-9.9628531426142125159845398506889259793638e-01) }, 
      { SC_(3.1272258758544921875000000000000000000000e+00), SC_(-3.8913452368727790960356345180278976524450e-01), SC_(-9.2118093905305886299976636088054353344837e-01) }, 
      { SC_(3.2463350296020507812500000000000000000000e+00), SC_(-6.9891857428318090957573573027947012586588e-01), SC_(-7.1520124896560809131726883061795792563693e-01) }, 
      { SC_(3.2589178085327148437500000000000000000000e+00), SC_(-7.2663709244263817401414242437628248351839e-01), SC_(-6.8702149594209125055751180411261051580649e-01) }, 
      { SC_(3.3070068359375000000000000000000000000000e+00), SC_(-8.2175864645735172534612332054328975554008e-01), SC_(-5.6983570173566802821049780901183552862792e-01) }, 
      { SC_(3.3258838653564453125000000000000000000000e+00), SC_(-8.5408772066117639250002441486943704634544e-01), SC_(-5.2012898920921176087604522292013122428088e-01) }, 
      { SC_(3.3375492095947265625000000000000000000000e+00), SC_(-8.7257153578052091358315534289731125877922e-01), SC_(-4.8848635082837587004720613584405617142606e-01) }, 
      { SC_(3.3669977188110351562500000000000000000000e+00), SC_(-9.1396798220297561033487383312195293377728e-01), SC_(-4.0578630768893774739693190146836884794326e-01) }, 
      { SC_(3.4341087341308593750000000000000000000000e+00), SC_(-9.7865116955588442390300932302401182353872e-01), SC_(-2.0552831514635533577558252681957801819126e-01) }, 
      { SC_(3.4719457626342773437500000000000000000000e+00), SC_(-9.9611862556712482137384040772481006307913e-01), SC_(-8.8020928183371141600457936465291857450722e-02) }, 
      { SC_(3.4720849990844726562500000000000000000000e+00), SC_(-9.9615703275215020366558951270835450836767e-01), SC_(-8.7585193374402881607363783226196334139273e-02) }, 
      { SC_(3.5205917358398437500000000000000000000000e+00), SC_(-9.9790827684402469941929089861198503088668e-01), SC_(6.4645734632606333231408358461321085923473e-02) }, 
      { SC_(3.6017761230468750000000000000000000000000e+00), SC_(-9.4931744975485974001547195314422483338195e-01), SC_(3.1431891382945658324672056757940637855560e-01) }, 
      { SC_(3.6401405334472656250000000000000000000000e+00), SC_(-9.0463898322145714242894381928150807960181e-01), SC_(4.2617873015443671099809962769068440492845e-01) }, 
      { SC_(3.6573352813720703125000000000000000000000e+00), SC_(-8.8030890857630174758369213697721090228597e-01), SC_(4.7440091218419933754908503670548458480608e-01) }, 
      { SC_(3.6600542068481445312500000000000000000000e+00), SC_(-8.7622462669288746421939513920418821059507e-01), SC_(4.8190289849399121987063030800400737550306e-01) }, 
      { SC_(3.6743307113647460937500000000000000000000e+00), SC_(-8.5373690109536976936966210865941858472063e-01), SC_(5.2070462232255516658865250812898441468120e-01) }, 
      { SC_(3.6759395599365234375000000000000000000000e+00), SC_(-8.5109418559293582989264089230338154739944e-01), SC_(5.2501303531426465035302709741556823160457e-01) }, 
      { SC_(3.6779518127441406250000000000000000000000e+00), SC_(-8.4775823766338649388282137669646806530795e-01), SC_(5.3038285273363532972430422102518080779833e-01) }, 
      { SC_(3.7191076278686523437500000000000000000000e+00), SC_(-7.7229721139647358113807359437680820809513e-01), SC_(6.3526137712695126271658979722161374772548e-01) }, 
      { SC_(3.7197303771972656250000000000000000000000e+00), SC_(-7.7105289310908725572881798363458383569997e-01), SC_(6.3677110175329601145198110228336758429305e-01) }, 
      { SC_(3.7415590286254882812500000000000000000000e+00), SC_(-7.2560709999357252492032097752516068559035e-01), SC_(6.8810924745923713178558423965711944178988e-01) }, 
      { SC_(3.7509422302246093750000000000000000000000e+00), SC_(-7.0501057704102466691892843105783269928843e-01), SC_(7.0919678951633828078444575818375506502661e-01) }, 
      { SC_(3.7647418975830078125000000000000000000000e+00), SC_(-6.7361202403588387903950332613071875859902e-01), SC_(7.3908513790650654594303944610931020837681e-01) }, 
      { SC_(3.8488769531250000000000000000000000000000e+00), SC_(-4.5713127745715697303348813361224351474208e-01), SC_(8.8939923272419555705330444258023019744461e-01) }, 
      { SC_(3.8996763229370117187500000000000000000000e+00), SC_(-3.0998392718517287188809579093624249170750e-01), SC_(9.5074179717042915066727903436561012864445e-01) }, 
      { SC_(3.9081726074218750000000000000000000000000e+00), SC_(-2.8449945044851010534076472484154609631230e-01), SC_(9.5867620325868929081685950779266605717363e-01) }, 
      { SC_(3.9430503845214843750000000000000000000000e+00), SC_(-1.7795953146963244992533370940904044176079e-01), SC_(9.8403780677325040351109357253557270668483e-01) }, 
      { SC_(3.9525480270385742187500000000000000000000e+00), SC_(-1.4852322763418675969604894254451481003482e-01), SC_(9.8890891939203558912519717829149622171011e-01) }, 
      { SC_(3.9716901779174804687500000000000000000000e+00), SC_(-8.8820726269070577371479191303757464259147e-02), SC_(9.9604762867296402989876530880328911976327e-01) }
   }};
//#undef SC_

