# asn1crypto Documentation

The documentation for *asn1crypto* is composed of tutorials on basic usage and
links to the source for the various pre-defined type classes.

## Tutorials

 - [Universal Types with BER/DER Decoder and DER Encoder](universal_types.md)
 - [PEM Decoder and Encoder](pem.md)

## Reference

 - [Universal types](../asn1crypto/core.py), `asn1crypto.core`
 - [Digest, HMAC, signed digest and encryption algorithms](../asn1crypto/algos.py), `asn1crypto.algos`
 - [Private and public keys](../asn1crypto/keys.py), `asn1crypto.keys`
 - [X.509 certificates](../asn1crypto/x509.py), `asn1crypto.x509`
 - [Certificate revocation lists (CRLs)](../asn1crypto/crl.py), `asn1crypto.crl`
 - [Online certificate status protocol (OCSP)](../asn1crypto/ocsp.py), `asn1crypto.ocsp`
 - [Certificate signing requests (CSRs)](../asn1crypto/csr.py), `asn1crypto.csr`
 - [Private key/certificate containers (PKCS#12)](../asn1crypto/pkcs12.py), `asn1crypto.pkcs12`
 - [Cryptographic message syntax (CMS, PKCS#7)](../asn1crypto/cms.py), `asn1crypto.cms`
 - [Time stamp protocol (TSP)](../asn1crypto/tsp.py), `asn1crypto.tsp`
 - [PDF signatures](../asn1crypto/pdf.py), `asn1crypto.pdf`
