use strict;
use warnings FATAL => 'all';

use Apache::Test;
use Apache::TestRequest;
use Apache::TestUtil;

use IO::Select;

plan tests => 7, need [qw(mod_proxy proxy_http.c)];

my $len = 100000;

my $sock = Apache::TestRequest::vhost_socket('proxy_http_reverse');
ok $sock && $sock->connected;

my $req = 
    "POST /reverse/modules/cgi/perl_echo.pl HTTP/1.0\r\n".
    "Content-Length: 0" . $len . "\r\n".
    "\r\n";

ok $sock->print($req);

my $half_body = 'x' x ($len/2);
ok $sock->print($half_body);
sleep(1);
ok $sock->print($half_body);

my $readable = IO::Select->new($sock)->can_read(10);
ok $readable, 1, "timeout, server hung";
if (!$readable) {
    skip "server hung, not testing further", foreach(1..2);
    exit(0);
}

my $line = Apache::TestRequest::getline($sock) || '';
ok t_cmp($line, qr{^HTTP/1\.. 200}, "request was parsed");

do {
    $line = Apache::TestRequest::getline($sock) || '';
    $line = super_chomp($line);
    print "# header: $line\n";
} until ($line eq "");

my $buffer;
while ($len > 0 && $sock->read($buffer, $len)) {
    print "# got: $buffer\n";
    $len -= length($buffer);
    print "# remaining: $len\n";
}

ok t_cmp($len, 0, "read entire body");

sub super_chomp {
    my ($body) = shift;

    ## super chomp - all leading and trailing \n (and \r for win32)
    $body =~ s/^[\n\r]*//;
    $body =~ s/[\n\r]*$//;
    ## and all the rest change to spaces
    $body =~ s/\n/ /g;
    $body =~ s/\r//g; #rip out all remaining \r's

    $body;
}
