/**
 * SECTION:profile
 * @short_description: This object represents an accessibility profile.
 * 
 * <para>An accessibility profile represents a group of settings that can be enabled to provide a better experience for a user with a disability. An accessibility profile can be associated with an assistive technology service such as the Orca Screen reader if desired.</para><para>Only one accessibility profile can be enabled at a time, as the same setting may be present in multiple profiles, and have multiple different values accross different profiles. The accessibility profile manager library currently only supports GSettings for profile configuration at this time.</para>
 *
 * Since: 0.1
 */
/**
 * A11Y_PROFILE_MANAGER_TYPE_PROFILE:
 * 
 * The type for <link linkend="A11yProfileManagerProfile"><type>A11yProfileManagerProfile</type></link>.
 */
/**
 * a11y_profile_manager_profile_validate:
 * @self: the <link linkend="A11yProfileManagerProfile"><type>A11yProfileManagerProfile</type></link> instance
 * @error: location to store the error occuring, or %NULL to ignore
 * 
 * Validates the profile manifest and gsettings files found in the profile directory given at object creation time. If required manifest data is not present, or the GSettings data is invalid, #error will be set to #ProfileError.
 * 
 * <para>The validity of the profile can be checked with #a11y_profile_manager_profile_get_valid().</para>
 *
 * Since: 0.1
 */
/**
 * a11y_profile_manager_profile_set_settings:
 * @self: the <link linkend="A11yProfileManagerProfile"><type>A11yProfileManagerProfile</type></link> instance
 * @error: location to store the error occuring, or %NULL to ignore
 * 
 * Sets the settings as per the profile GSettings file.
 *
 * Since: 0.1
 */
/**
 * a11y_profile_manager_profile_reset_settings:
 * @self: the <link linkend="A11yProfileManagerProfile"><type>A11yProfileManagerProfile</type></link> instance
 * @error: location to store the error occuring, or %NULL to ignore
 * 
 * Resets the settings given in the profile GSettings file to defaults.
 *
 * Since: 0.1
 */
/**
 * a11y_profile_manager_profile_write_dconf_file:
 * @self: the <link linkend="A11yProfileManagerProfile"><type>A11yProfileManagerProfile</type></link> instance
 * @file: (in): &nbsp;.  <para>A file to write the dconf data to. </para>
 * @error: location to store the error occuring, or %NULL to ignore
 * 
 * Writes the gsettings data in the profile to a format that is consumable by the dconf command-line utility. The file can be used with &apos;dconf compile&apos; to create a dconf database with profile settings.
 *
 * Since: 0.1.2
 */
/**
 * a11y_profile_manager_profile_new:
 * @profile_dir: (in): &nbsp;.  <para>The profile directory name relative to the profiles directory. </para>
 * 
 * Creates a new accessibility profile object.
 * 
 * Returns: <para>A new Profile </para>
 *
 * Since: 0.1
 */
/**
 * A11yProfileManagerProfile:dir-name:
 * 
 * The directory where the profile files are stored, relative to the profiles directory.
 *
 * Since: 0.1
 */
/**
 * a11y_profile_manager_profile_get_dir_name:
 * @self: the <link linkend="A11yProfileManagerProfile"><type>A11yProfileManagerProfile</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="A11yProfileManagerProfile--dir-name"><type>"dir-name"</type></link> property.
 * 
 * The directory where the profile files are stored, relative to the profiles directory.
 * 
 * Returns: the value of the <link linkend="A11yProfileManagerProfile--dir-name"><type>"dir-name"</type></link> property
 *
 * Since: 0.1
 */
/**
 * A11yProfileManagerProfile:name:
 * 
 * The name of the accessibility profile, as per the manifest file.
 *
 * Since: 0.1
 */
/**
 * a11y_profile_manager_profile_get_name:
 * @self: the <link linkend="A11yProfileManagerProfile"><type>A11yProfileManagerProfile</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="A11yProfileManagerProfile--name"><type>"name"</type></link> property.
 * 
 * The name of the accessibility profile, as per the manifest file.
 * 
 * Returns: the value of the <link linkend="A11yProfileManagerProfile--name"><type>"name"</type></link> property
 *
 * Since: 0.1
 */
/**
 * A11yProfileManagerProfile:description:
 * 
 * The description of the accessibility profile, as per the manifest file.
 *
 * Since: 0.1
 */
/**
 * a11y_profile_manager_profile_get_description:
 * @self: the <link linkend="A11yProfileManagerProfile"><type>A11yProfileManagerProfile</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="A11yProfileManagerProfile--description"><type>"description"</type></link> property.
 * 
 * The description of the accessibility profile, as per the manifest file.
 * 
 * Returns: the value of the <link linkend="A11yProfileManagerProfile--description"><type>"description"</type></link> property
 *
 * Since: 0.1
 */
/**
 * A11yProfileManagerProfile:monitor-schema:
 * 
 * The GSettings schema to subscribe to for change events, as per the manifest file.
 *
 * Since: 0.1
 */
/**
 * a11y_profile_manager_profile_get_monitor_schema:
 * @self: the <link linkend="A11yProfileManagerProfile"><type>A11yProfileManagerProfile</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="A11yProfileManagerProfile--monitor-schema"><type>"monitor-schema"</type></link> property.
 * 
 * The GSettings schema to subscribe to for change events, as per the manifest file.
 * 
 * Returns: the value of the <link linkend="A11yProfileManagerProfile--monitor-schema"><type>"monitor-schema"</type></link> property
 *
 * Since: 0.1
 */
/**
 * A11yProfileManagerProfile:monitor-key:
 * 
 * THe GSettings key associated with the GSettings schema to monitor, as per the manifest file.
 *
 * Since: 0.1
 */
/**
 * a11y_profile_manager_profile_get_monitor_key:
 * @self: the <link linkend="A11yProfileManagerProfile"><type>A11yProfileManagerProfile</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="A11yProfileManagerProfile--monitor-key"><type>"monitor-key"</type></link> property.
 * 
 * THe GSettings key associated with the GSettings schema to monitor, as per the manifest file.
 * 
 * Returns: the value of the <link linkend="A11yProfileManagerProfile--monitor-key"><type>"monitor-key"</type></link> property
 *
 * Since: 0.1
 */
/**
 * A11yProfileManagerProfile:at-command:
 * 
 * The command to execute to run an assistive technology that best works with this profile.
 *
 * Since: 0.1.2
 */
/**
 * a11y_profile_manager_profile_get_at_command:
 * @self: the <link linkend="A11yProfileManagerProfile"><type>A11yProfileManagerProfile</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="A11yProfileManagerProfile--at-command"><type>"at-command"</type></link> property.
 * 
 * The command to execute to run an assistive technology that best works with this profile.
 * 
 * Returns: the value of the <link linkend="A11yProfileManagerProfile--at-command"><type>"at-command"</type></link> property
 *
 * Since: 0.1.2
 */
/**
 * A11yProfileManagerProfile:valid:
 * 
 * The validity of the accessibility profile, whether the GSettings exist, the manifest is valid, whether settings values are the correct value type, etc.
 *
 * Since: 0.1
 */
/**
 * a11y_profile_manager_profile_get_valid:
 * @self: the <link linkend="A11yProfileManagerProfile"><type>A11yProfileManagerProfile</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="A11yProfileManagerProfile--valid"><type>"valid"</type></link> property.
 * 
 * The validity of the accessibility profile, whether the GSettings exist, the manifest is valid, whether settings values are the correct value type, etc.
 * 
 * Returns: the value of the <link linkend="A11yProfileManagerProfile--valid"><type>"valid"</type></link> property
 *
 * Since: 0.1
 */
/**
 * A11yProfileManagerProfile:
 * 
 * This object represents an accessibility profile.
 * 
 * <para>An accessibility profile represents a group of settings that can be enabled to provide a better experience for a user with a disability. An accessibility profile can be associated with an assistive technology service such as the Orca Screen reader if desired.</para><para>Only one accessibility profile can be enabled at a time, as the same setting may be present in multiple profiles, and have multiple different values accross different profiles. The accessibility profile manager library currently only supports GSettings for profile configuration at this time.</para>
 *
 * Since: 0.1
 */
/**
 * A11yProfileManagerProfileClass:
 * @parent_class: the parent class structure
 * 
 * The class structure for <link linkend="A11Y-PROFILE-MANAGER-TYPE-PROFILE:CAPS"><literal>A11Y_PROFILE_MANAGER_TYPE_PROFILE</literal></link>. All the fields in this structure are private and should never be accessed directly.
 */
/**
 * A11yProfileManagerProfileError:
 * @A11Y_PROFILE_MANAGER_PROFILE_ERROR_NO_PROFILE_GROUP: No profile group in manifest file:
 * @A11Y_PROFILE_MANAGER_PROFILE_ERROR_NO_NAME_ENTRY: No name entry in profile group.
 * @A11Y_PROFILE_MANAGER_PROFILE_ERROR_NO_DESCRIPTION_ENTRY: No description entry in profile group.
 * @A11Y_PROFILE_MANAGER_PROFILE_ERROR_INVALID_ENTRY: Invalid manifest entry.
 * @A11Y_PROFILE_MANAGER_PROFILE_ERROR_NO_SUCH_MONITOR_SCHEMA: No such assistive technology monitor schema.
 * @A11Y_PROFILE_MANAGER_PROFILE_ERROR_SCHEMA_WITHOUT_KEY: A schema was specified, but no key.
 * @A11Y_PROFILE_MANAGER_PROFILE_ERROR_NO_SUCH_MONITOR_KEY: No such assistive technology monitor key.
 * @A11Y_PROFILE_MANAGER_PROFILE_ERROR_NO_SUCH_SCHEMA: GSettings schema does not exist.
 * @A11Y_PROFILE_MANAGER_PROFILE_ERROR_SCHEMA_NOT_RELOCATABLE: Schema is not relocatable.
 * @A11Y_PROFILE_MANAGER_PROFILE_ERROR_NO_SUCH_KEY: Key does not exist in schema.
 * @A11Y_PROFILE_MANAGER_PROFILE_ERROR_INVALID_SCHEMA_PATH: Invalid schema path.
 * @A11Y_PROFILE_MANAGER_PROFILE_ERROR_INVALID_KEY_TYPE: Invalid key type.
 * 
 * Errors which can be thrown when attempting to activate an accessibility profile.
 *
 * Since: 0.1
 */
