# Pix - an image viewer and browser utility
![build](https://github.com/linuxmint/pix/actions/workflows/build.yml/badge.svg)

Pix is part of the X-Apps project, which aims at producing cross-distribution and cross-desktop software.
 
#### Pix is an image browser:
- Browse your hard disk showing you thumbnails of image files.
- Thumbnails are saved in the same database used by Nautilus so you don't waste disk space.
- Automatically update the content of a folder.
- Copy, move, delete images and folders.
- Bookmarks of folders and catalogs.

#### Pix is an image viewer:
- View single images (including GIF animations).  Supported image types are: BMP, JPEG, GIF, PNG, TIFF, TGA, ICO, XPM.
- Optional support for RAW and HDR (high dynamic range) images.
- View EXIF data attached to JPEG images.
- View in fullscreen mode.
- View images rotated, flipped, mirrored.

#### Pix is an image organizer:
- Add comments to images.
- Organize images in catalogs, catalogs in libraries.
- Print images and comments.
- Search for images on you hard disk and save the result as a catalog.
- Search criteria remain attached to the catalog so you can update it when you want.

#### Pix is an image editor:
- Change image hue, saturation, lightness, contrast and adjust colors.
- Scale and rotate images.
- Save images in the following formats: JPEG, PNG, TIFF, TGA.
- Crop images.
- Red-eye removal tool.

#### Pix is an advanced tool:
- Import images from a digital camera.
- Slide Shows.
- Set an image as Desktop background.
- Create index image.
- Rename images in series.
- Convert image format.
- Change images date and time.
- JPEG lossless transformations.
- Find duplicated images.

 This program is released under the terms of the GNU General Public
  License (GNU GPL). You can find a copy of the license in the file COPYING.

## Installation

- This package may be available through your system's package manager. This is the recommended method of installation.
- The latest unstable version is available for Linux Mint and LMDE in the [releases](https://github.com/linuxmint/pix/releases) section.
- See [INSTALL](INSTALL.md) for instructions for building from source.

  If dcraw is present (and is in your executable search path),
  Pix can view full RAW photos.

Extensions
==========

  Pix has a plug-in system for extensions. Some standard features
  are implemented as extensions and are supplied with the standard
  distribution. Users may write (and share) additional extensions.


Credits
=======

  Pix is based on gThumb 3.2.8.
  Many thanks to the original developers and to all the people who contributed to gThumb.
